/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.sourcemaps;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonBoolean;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNumber;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonSyntaxException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014H\u0082\b\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u001bH\u0002J\b\u0010\"\u001a\u00020\u001bH\u0002J\b\u0010#\u001a\u00020\u001eH\u0002J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u0003H\u0002J\b\u0010)\u001a\u00020\u0010H\u0002J\u0014\u0010*\u001a\u00020\u00102\n\u0010+\u001a\u00060,j\u0002`-H\u0002J\u0014\u0010.\u001a\u00020\u00102\n\u0010+\u001a\u00060,j\u0002`-H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonParser;", "", "content", "", "(Ljava/lang/String;)V", "charCode", "", "col", "getContent", "()Ljava/lang/String;", "index", "line", "offset", "wasCR", "", "advance", "", "advanceAndThen", "T", "f", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "error", "", "text", "expectCharAndAdvance", "expected", "", "expectString", "parse", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonNode;", "parseArray", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonArray;", "parseEscapeSequence", "parseHexEscapeSequence", "parseNode", "parseNumber", "", "parseObject", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonObject;", "parseString", "skipSpaces", "takeExponentTo", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "takeIntegerDigitsTo", "js.parser"})
final class JsonParser {
    private int index;
    private int charCode;
    private int offset;
    private int line;
    private int col;
    private boolean wasCR;
    @NotNull
    private final String content;

    @NotNull
    public final JsonNode parse() {
        JsonNode result2 = this.parseNode();
        this.skipSpaces();
        if (this.charCode != -1) {
            Void void_ = this.error("End of input expected");
            throw null;
        }
        return result2;
    }

    private final void skipSpaces() {
        block3: while (true) {
            switch (this.charCode) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.advance();
                    continue block3;
                }
            }
            break;
        }
    }

    private final JsonNode parseNode() {
        JsonNode jsonNode;
        this.skipSpaces();
        switch (this.charCode) {
            case 91: {
                jsonNode = this.parseArray();
                break;
            }
            case 123: {
                jsonNode = this.parseObject();
                break;
            }
            case 34: {
                jsonNode = new JsonString(this.parseString());
                break;
            }
            case 110: {
                this.expectString("null");
                jsonNode = JsonNull.INSTANCE;
                break;
            }
            case 102: {
                this.expectString("false");
                jsonNode = JsonBoolean.Companion.getFALSE();
                break;
            }
            case 116: {
                this.expectString("true");
                jsonNode = JsonBoolean.Companion.getTRUE();
                break;
            }
            case 45: {
                this.advance();
                jsonNode = new JsonNumber(-this.parseNumber());
                break;
            }
            default: {
                int n = this.charCode;
                if (48 > n || 57 < n) {
                    Void void_ = this.error("Unexpected char");
                    throw null;
                }
                jsonNode = new JsonNumber(this.parseNumber());
            }
        }
        return jsonNode;
    }

    private final JsonArray parseArray() {
        this.advance();
        JsonArray result2 = new JsonArray(new JsonNode[0]);
        while (true) {
            this.skipSpaces();
            if (this.charCode == 93) break;
            Collection collection = result2.getElements();
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.expectCharAndAdvance(',');
            }
            collection = result2.getElements();
            JsonNode jsonNode = this.parseNode();
            boolean bl2 = false;
            collection.add(jsonNode);
        }
        this.advance();
        return result2;
    }

    private final JsonObject parseObject() {
        this.advance();
        JsonObject result2 = new JsonObject(new Pair[0]);
        while (true) {
            this.skipSpaces();
            if (this.charCode == 125) break;
            Map<String, JsonNode> map2 = result2.getProperties();
            boolean bl = false;
            if (!map2.isEmpty()) {
                this.expectCharAndAdvance(',');
            }
            this.skipSpaces();
            String key = this.parseString();
            Map<String, JsonNode> map3 = result2.getProperties();
            boolean bl2 = false;
            Map<String, JsonNode> map4 = map3;
            boolean bl3 = false;
            if (map4.containsKey(key)) {
                Void void_ = this.error("Duplicate property name: " + key);
                throw null;
            }
            this.skipSpaces();
            this.expectCharAndAdvance(':');
            result2.getProperties().put(key, this.parseNode());
        }
        this.advance();
        return result2;
    }

    private final String parseString() {
        this.expectCharAndAdvance('\"');
        StringBuilder sb = new StringBuilder();
        int leftIndex = this.index;
        block4: while (this.index < this.content.length()) {
            this.charCode = this.content.charAt(this.index);
            if (this.charCode < 32) {
                Void void_ = this.error("Invalid character in string literal");
                throw null;
            }
            switch (this.charCode) {
                case 34: {
                    sb.append(this.content, leftIndex, this.index);
                    this.advance();
                    String string2 = sb.toString();
                    Intrinsics.checkNotNullExpressionValue(string2, "sb.toString()");
                    return string2;
                }
                case 92: {
                    sb.append(this.content, leftIndex, this.index);
                    sb.append(this.parseEscapeSequence());
                    leftIndex = this.index;
                    continue block4;
                }
            }
            JsonParser jsonParser = this;
            ++jsonParser.index;
            int cfr_ignored_0 = jsonParser.index;
        }
        Void void_ = this.error("Unexpected end of file");
        throw null;
    }

    private final char parseEscapeSequence() {
        int n;
        this.advance();
        switch (this.charCode) {
            case 34: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 34;
                break;
            }
            case 92: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 92;
                break;
            }
            case 47: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 47;
                break;
            }
            case 98: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 8;
                break;
            }
            case 110: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 10;
                break;
            }
            case 114: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 13;
                break;
            }
            case 102: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 12;
                break;
            }
            case 116: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 9;
                break;
            }
            case 117: {
                n = this.parseHexEscapeSequence();
                break;
            }
            default: {
                Void void_ = this.error("Invalid escape sequence");
                throw null;
            }
        }
        return (char)n;
    }

    private final char parseHexEscapeSequence() {
        this.advance();
        int value2 = 0;
        int n = 4;
        boolean bl = false;
        int n2 = 0;
        int n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            int n4;
            int it = n2;
            boolean bl2 = false;
            value2 *= 16;
            int n5 = this.charCode;
            int n6 = n5;
            if (48 <= n6 && 57 >= n6) {
                n4 = this.charCode - 48;
            } else {
                n6 = n5;
                if (97 <= n6 && 102 >= n6) {
                    n4 = this.charCode - 97 + 10;
                } else {
                    n6 = n5;
                    if (65 <= n6 && 70 >= n6) {
                        n4 = this.charCode - 65 + 10;
                    } else {
                        Void void_ = this.error("Invalid escape sequence, hexadecimal char expected");
                        throw null;
                    }
                }
            }
            value2 += n4;
            this.advance();
        }
        return (char)value2;
    }

    private final double parseNumber() {
        double d;
        StringBuilder sb = new StringBuilder();
        this.takeIntegerDigitsTo(sb);
        if (StringsKt.startsWith$default((CharSequence)sb, '0', false, 2, null) && sb.length() > 1) {
            Void void_ = this.error("Number must not start with zero");
            throw null;
        }
        switch (this.charCode) {
            case 46: {
                sb.append('.');
                this.advance();
                this.takeIntegerDigitsTo(sb);
                if (this.charCode == 101 || this.charCode == 69) {
                    this.takeExponentTo(sb);
                }
                String string2 = sb.toString();
                Intrinsics.checkNotNullExpressionValue(string2, "sb.toString()");
                String string3 = string2;
                boolean bl = false;
                d = Double.parseDouble(string3);
                break;
            }
            case 69: 
            case 101: {
                this.takeExponentTo(sb);
                String string4 = sb.toString();
                Intrinsics.checkNotNullExpressionValue(string4, "sb.toString()");
                String string5 = string4;
                boolean bl = false;
                d = Double.parseDouble(string5);
                break;
            }
            default: {
                String string6 = sb.toString();
                Intrinsics.checkNotNullExpressionValue(string6, "sb.toString()");
                String string7 = string6;
                boolean bl = false;
                return Double.parseDouble(string7);
            }
        }
        return d;
    }

    private final void takeIntegerDigitsTo(StringBuilder buffer) {
        int n;
        int size = 0;
        while (48 <= (n = this.charCode) && 57 >= n) {
            buffer.append((char)this.charCode);
            this.advance();
            ++size;
        }
        if (size == 0) {
            Void void_ = this.error("Invalid char, decimal digit expected");
            throw null;
        }
    }

    private final void takeExponentTo(StringBuilder buffer) {
        buffer.append('e');
        this.advance();
        if (this.charCode == 45 || this.charCode == 43) {
            buffer.append((char)this.charCode);
            this.advance();
        }
        this.takeIntegerDigitsTo(buffer);
    }

    private final void expectString(String expected) {
        String string2 = expected;
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (this.charCode != c) {
                Void void_ = this.error("Unexpected char, '" + expected + "' expected here");
                throw null;
            }
            this.advance();
        }
    }

    private final void expectCharAndAdvance(char expected) {
        if (this.charCode != expected) {
            Void void_ = this.error("Unexpected char, '" + expected + "' expected here");
            throw null;
        }
        this.advance();
    }

    private final void advance() {
        int n;
        if (this.charCode == -1) {
            return;
        }
        switch (this.charCode) {
            case 13: {
                n = this.line;
                this.line = n + 1;
                this.col = 0;
                this.wasCR = true;
                break;
            }
            case 10: {
                if (this.wasCR) break;
                n = this.line;
                this.line = n + 1;
                this.col = 0;
                this.wasCR = false;
                break;
            }
            default: {
                n = this.col;
                this.col = n + 1;
                this.wasCR = false;
            }
        }
        JsonParser jsonParser = this;
        ++jsonParser.index;
        Character c = StringsKt.getOrNull(this.content, jsonParser.index);
        this.charCode = c != null ? c.charValue() : -1;
        n = this.offset;
        this.offset = n + 1;
    }

    private final Void error(String text2) {
        throw (Throwable)new JsonSyntaxException(this.offset, this.line, this.col, text2);
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    public JsonParser(@NotNull String content) {
        Intrinsics.checkNotNullParameter(content, "content");
        this.content = content;
        this.index = -1;
        JsonParser jsonParser = this;
        ++jsonParser.index;
        Character c = StringsKt.getOrNull(this.content, jsonParser.index);
        this.charCode = c != null ? c.charValue() : -1;
    }
}

