/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.ConversionTypeContext;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrSignatureComposer;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitAnyTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBooleanTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitIntTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNothingTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNullableAnyTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNullableNothingTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitStringTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitUnitTypeRef;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeAbbreviation;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.types.impl.IrStarProjectionImpl;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010,\u001a\u0004\u0018\u00010\u00072\b\u0010-\u001a\u0004\u0018\u00010\u0006H\u0002J\u0014\u0010.\u001a\u0004\u0018\u00010\u00072\b\u0010-\u001a\u0004\u0018\u00010\u0006H\u0002J\u0014\u0010/\u001a\u00020\u000b*\u0002002\b\b\u0002\u00101\u001a\u000202J\u0014\u0010/\u001a\u00020\u000b*\u0002032\b\b\u0002\u00101\u001a\u000202J\f\u00104\u001a\u000205*\u000206H\u0002R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0012\u0010\r\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u0012X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u001aX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0012\u0010\u001d\u001a\u00020\u001eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0012\u0010!\u001a\u00020\"X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0012\u0010%\u001a\u00020&X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0012\u0010)\u001a\u00020\u0000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "components", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;)V", "classIdToSymbolMap", "", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getClassIdToSymbolMap$fir2ir", "()Ljava/util/Map;", "classIdToTypeMap", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getClassIdToTypeMap$fir2ir", "classifierStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "getClassifierStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "getDeclarationStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "signatureComposer", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "getSignatureComposer", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "typeConverter", "getTypeConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "getArrayClassSymbol", "classId", "getBuiltInClassSymbol", "toIrType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "typeContext", "Lorg/jetbrains/kotlin/fir/backend/ConversionTypeContext;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "toIrTypeArgument", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "fir2ir"})
public final class Fir2IrTypeConverter
implements Fir2IrComponents {
    @NotNull
    private final Map<ClassId, IrClassSymbol> classIdToSymbolMap;
    @NotNull
    private final Map<ClassId, IrType> classIdToTypeMap;
    private final Fir2IrComponents components;

    @NotNull
    public final Map<ClassId, IrClassSymbol> getClassIdToSymbolMap$fir2ir() {
        return this.classIdToSymbolMap;
    }

    @NotNull
    public final Map<ClassId, IrType> getClassIdToTypeMap$fir2ir() {
        return this.classIdToTypeMap;
    }

    @NotNull
    public final IrType toIrType(@NotNull FirTypeRef $this$toIrType, @NotNull ConversionTypeContext typeContext) {
        Intrinsics.checkNotNullParameter($this$toIrType, "$this$toIrType");
        Intrinsics.checkNotNullParameter(typeContext, "typeContext");
        FirTypeRef firTypeRef = $this$toIrType;
        return !(firTypeRef instanceof FirResolvedTypeRef) ? (IrType)ConversionUtilsKt.createErrorType() : (!(firTypeRef instanceof FirImplicitBuiltinTypeRef) ? this.toIrType(((FirResolvedTypeRef)$this$toIrType).getType(), typeContext) : (firTypeRef instanceof FirImplicitNothingTypeRef ? this.getIrBuiltIns().getNothingType() : (firTypeRef instanceof FirImplicitUnitTypeRef ? this.getIrBuiltIns().getUnitType() : (firTypeRef instanceof FirImplicitBooleanTypeRef ? this.getIrBuiltIns().getBooleanType() : (firTypeRef instanceof FirImplicitStringTypeRef ? this.getIrBuiltIns().getStringType() : (firTypeRef instanceof FirImplicitAnyTypeRef ? this.getIrBuiltIns().getAnyType() : (firTypeRef instanceof FirImplicitIntTypeRef ? this.getIrBuiltIns().getIntType() : (firTypeRef instanceof FirImplicitNullableAnyTypeRef ? this.getIrBuiltIns().getAnyNType() : (firTypeRef instanceof FirImplicitNullableNothingTypeRef ? this.getIrBuiltIns().getNothingNType() : this.toIrType(((FirImplicitBuiltinTypeRef)$this$toIrType).getType(), typeContext))))))))));
    }

    public static /* synthetic */ IrType toIrType$default(Fir2IrTypeConverter fir2IrTypeConverter, FirTypeRef firTypeRef, ConversionTypeContext conversionTypeContext, int n, Object object) {
        if ((n & 1) != 0) {
            conversionTypeContext = ConversionTypeContext.Companion.getDEFAULT$fir2ir();
        }
        return fir2IrTypeConverter.toIrType(firTypeRef, conversionTypeContext);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrType toIrType(@NotNull ConeKotlinType $this$toIrType, @NotNull ConversionTypeContext typeContext) {
        KotlinTypeMarker kotlinTypeMarker;
        Intrinsics.checkNotNullParameter($this$toIrType, "$this$toIrType");
        Intrinsics.checkNotNullParameter(typeContext, "typeContext");
        ConeTypeProjection[] coneTypeProjectionArray = $this$toIrType;
        if (coneTypeProjectionArray instanceof ConeClassErrorType) {
            kotlinTypeMarker = ConversionUtilsKt.createErrorType();
        } else if (coneTypeProjectionArray instanceof ConeLookupTagBasedType) {
            Collection<IrTypeArgument> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ConeTypeProjection[] coneTypeProjectionArray2;
            IrClassifierSymbol irClassifierSymbol;
            ClassId classId = ConeTypeUtilsKt.getClassId((ConeKotlinType)$this$toIrType);
            IrClassSymbol irClassSymbol = this.getBuiltInClassSymbol(classId);
            if (irClassSymbol != null) {
                irClassifierSymbol = irClassSymbol;
            } else {
                coneTypeProjectionArray2 = $this$toIrType;
                boolean bl = false;
                boolean bl2 = false;
                ConeLookupTagBasedType $this$run = (ConeLookupTagBasedType)coneTypeProjectionArray2;
                boolean bl3 = false;
                FirClassifierSymbol<?> firClassifierSymbol = ResolveUtilsKt.toSymbol($this$run.getLookupTag(), this.getSession());
                if (firClassifierSymbol == null) {
                    return ConversionUtilsKt.createErrorType();
                }
                FirClassifierSymbol<?> firSymbol = firClassifierSymbol;
                irClassifierSymbol = ConversionUtilsKt.toSymbol(firSymbol, this.getSession(), this.getClassifierStorage(), typeContext);
            }
            IrClassifierSymbol irSymbol = irClassifierSymbol;
            coneTypeProjectionArray2 = $this$toIrType.getTypeArguments();
            boolean bl = !typeContext.getDefinitelyNotNull$fir2ir() && ConeTypeUtilsKt.isMarkedNullable((ConeKotlinType)$this$toIrType);
            IrClassifierSymbol irClassifierSymbol2 = irSymbol;
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var11_11 = $this$mapTo$iv$iv;
            int n = ((void)var11_11).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var15_18 = item$iv$iv = var11_11[i];
                collection = destination$iv$iv;
                boolean bl4 = false;
                IrTypeArgument irTypeArgument = this.toIrTypeArgument((ConeTypeProjection)it);
                collection.add(irTypeArgument);
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n2 = 16;
            IrTypeAbbreviation irTypeAbbreviation = null;
            List list2 = CollectionsKt.emptyList();
            List list3 = collection;
            boolean bl5 = bl;
            IrClassifierSymbol irClassifierSymbol3 = irClassifierSymbol2;
            kotlinTypeMarker = new IrSimpleTypeImpl(irClassifierSymbol3, bl5, list3, list2, irTypeAbbreviation, n2, defaultConstructorMarker);
        } else if (coneTypeProjectionArray instanceof ConeFlexibleType) {
            kotlinTypeMarker = this.toIrType(((ConeFlexibleType)$this$toIrType).getUpperBound(), typeContext);
        } else if (coneTypeProjectionArray instanceof ConeCapturedType) {
            kotlinTypeMarker = ((ConeCapturedType)$this$toIrType).getLowerType();
            if (kotlinTypeMarker == null || (kotlinTypeMarker = this.toIrType((ConeKotlinType)kotlinTypeMarker, typeContext)) == null) {
                List<ConeKotlinType> list4 = ((ConeCapturedType)$this$toIrType).getConstructor().getSupertypes();
                Intrinsics.checkNotNull(list4);
                kotlinTypeMarker = this.toIrType(CollectionsKt.first(list4), typeContext);
            }
        } else if (coneTypeProjectionArray instanceof ConeDefinitelyNotNullType) {
            kotlinTypeMarker = this.toIrType(((ConeDefinitelyNotNullType)$this$toIrType).getOriginal(), typeContext.definitelyNotNull());
        } else if (coneTypeProjectionArray instanceof ConeIntersectionType) {
            kotlinTypeMarker = this.toIrType((ConeKotlinType)CollectionsKt.first((Iterable)((ConeIntersectionType)$this$toIrType).getIntersectedTypes()), typeContext);
        } else if (coneTypeProjectionArray instanceof ConeStubType) {
            kotlinTypeMarker = ConversionUtilsKt.createErrorType();
        } else if (coneTypeProjectionArray instanceof ConeIntegerLiteralType) {
            kotlinTypeMarker = ConversionUtilsKt.createErrorType();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return kotlinTypeMarker;
    }

    public static /* synthetic */ IrType toIrType$default(Fir2IrTypeConverter fir2IrTypeConverter, ConeKotlinType coneKotlinType, ConversionTypeContext conversionTypeContext, int n, Object object) {
        if ((n & 1) != 0) {
            conversionTypeContext = ConversionTypeContext.Companion.getDEFAULT$fir2ir();
        }
        return fir2IrTypeConverter.toIrType(coneKotlinType, conversionTypeContext);
    }

    private final IrTypeArgument toIrTypeArgument(ConeTypeProjection $this$toIrTypeArgument) {
        IrTypeArgument irTypeArgument;
        ConeTypeProjection coneTypeProjection = $this$toIrTypeArgument;
        if (Intrinsics.areEqual(coneTypeProjection, ConeStarProjection.INSTANCE)) {
            irTypeArgument = IrStarProjectionImpl.INSTANCE;
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionIn) {
            IrType irType = Fir2IrTypeConverter.toIrType$default(this, ((ConeKotlinTypeProjectionIn)$this$toIrTypeArgument).getType(), null, 1, null);
            irTypeArgument = IrSimpleTypeImplKt.makeTypeProjection(irType, Variance.IN_VARIANCE);
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionOut) {
            IrType irType = Fir2IrTypeConverter.toIrType$default(this, ((ConeKotlinTypeProjectionOut)$this$toIrTypeArgument).getType(), null, 1, null);
            irTypeArgument = IrSimpleTypeImplKt.makeTypeProjection(irType, Variance.OUT_VARIANCE);
        } else if (coneTypeProjection instanceof ConeKotlinType) {
            IrType irType = Fir2IrTypeConverter.toIrType$default(this, (ConeKotlinType)$this$toIrTypeArgument, null, 1, null);
            irTypeArgument = IrSimpleTypeImplKt.makeTypeProjection(irType, Variance.INVARIANT);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return irTypeArgument;
    }

    private final IrClassSymbol getArrayClassSymbol(ClassId classId) {
        Map<ClassId, ClassId> map2 = StandardClassIds.INSTANCE.getElementTypeByPrimitiveArrayType();
        boolean bl = false;
        ClassId classId2 = map2.get(classId);
        if (classId2 == null) {
            return null;
        }
        ClassId primitiveId = classId2;
        IrType irType = this.classIdToTypeMap.get(primitiveId);
        Map<IrType, IrClassSymbol> map3 = this.getIrBuiltIns().getPrimitiveArrayForType();
        boolean bl2 = false;
        IrClassSymbol irClassSymbol = map3.get(irType);
        if (irClassSymbol == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Strange primitiveId " + primitiveId + " from array: " + classId)));
        }
        return irClassSymbol;
    }

    private final IrClassSymbol getBuiltInClassSymbol(ClassId classId) {
        Map<ClassId, IrClassSymbol> map2 = this.classIdToSymbolMap;
        boolean bl = false;
        IrClassSymbol irClassSymbol = map2.get(classId);
        if (irClassSymbol == null) {
            irClassSymbol = this.getArrayClassSymbol(classId);
        }
        return irClassSymbol;
    }

    public Fir2IrTypeConverter(@NotNull Fir2IrComponents components) {
        Intrinsics.checkNotNullParameter(components, "components");
        this.components = components;
        this.classIdToSymbolMap = MapsKt.mapOf(TuplesKt.to(StandardClassIds.INSTANCE.getNothing(), this.getIrBuiltIns().getNothingClass()), TuplesKt.to(StandardClassIds.INSTANCE.getUnit(), this.getIrBuiltIns().getUnitClass()), TuplesKt.to(StandardClassIds.INSTANCE.getBoolean(), this.getIrBuiltIns().getBooleanClass()), TuplesKt.to(StandardClassIds.INSTANCE.getString(), this.getIrBuiltIns().getStringClass()), TuplesKt.to(StandardClassIds.INSTANCE.getAny(), this.getIrBuiltIns().getAnyClass()), TuplesKt.to(StandardClassIds.INSTANCE.getLong(), this.getIrBuiltIns().getLongClass()), TuplesKt.to(StandardClassIds.INSTANCE.getInt(), this.getIrBuiltIns().getIntClass()), TuplesKt.to(StandardClassIds.INSTANCE.getShort(), this.getIrBuiltIns().getShortClass()), TuplesKt.to(StandardClassIds.INSTANCE.getByte(), this.getIrBuiltIns().getByteClass()), TuplesKt.to(StandardClassIds.INSTANCE.getFloat(), this.getIrBuiltIns().getFloatClass()), TuplesKt.to(StandardClassIds.INSTANCE.getDouble(), this.getIrBuiltIns().getDoubleClass()), TuplesKt.to(StandardClassIds.INSTANCE.getChar(), this.getIrBuiltIns().getCharClass()), TuplesKt.to(StandardClassIds.INSTANCE.getArray(), this.getIrBuiltIns().getArrayClass()));
        this.classIdToTypeMap = MapsKt.mapOf(TuplesKt.to(StandardClassIds.INSTANCE.getNothing(), this.getIrBuiltIns().getNothingType()), TuplesKt.to(StandardClassIds.INSTANCE.getUnit(), this.getIrBuiltIns().getUnitType()), TuplesKt.to(StandardClassIds.INSTANCE.getBoolean(), this.getIrBuiltIns().getBooleanType()), TuplesKt.to(StandardClassIds.INSTANCE.getString(), this.getIrBuiltIns().getStringType()), TuplesKt.to(StandardClassIds.INSTANCE.getAny(), this.getIrBuiltIns().getAnyType()), TuplesKt.to(StandardClassIds.INSTANCE.getLong(), this.getIrBuiltIns().getLongType()), TuplesKt.to(StandardClassIds.INSTANCE.getInt(), this.getIrBuiltIns().getIntType()), TuplesKt.to(StandardClassIds.INSTANCE.getShort(), this.getIrBuiltIns().getShortType()), TuplesKt.to(StandardClassIds.INSTANCE.getByte(), this.getIrBuiltIns().getByteType()), TuplesKt.to(StandardClassIds.INSTANCE.getFloat(), this.getIrBuiltIns().getFloatType()), TuplesKt.to(StandardClassIds.INSTANCE.getDouble(), this.getIrBuiltIns().getDoubleType()), TuplesKt.to(StandardClassIds.INSTANCE.getChar(), this.getIrBuiltIns().getCharType()));
    }

    @Override
    @NotNull
    public Fir2IrClassifierStorage getClassifierStorage() {
        return this.components.getClassifierStorage();
    }

    @Override
    @NotNull
    public Fir2IrDeclarationStorage getDeclarationStorage() {
        return this.components.getDeclarationStorage();
    }

    @Override
    @NotNull
    public IrBuiltIns getIrBuiltIns() {
        return this.components.getIrBuiltIns();
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.components.getScopeSession();
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.components.getSession();
    }

    @Override
    @NotNull
    public Fir2IrSignatureComposer getSignatureComposer() {
        return this.components.getSignatureComposer();
    }

    @Override
    @NotNull
    public SymbolTable getSymbolTable() {
        return this.components.getSymbolTable();
    }

    @Override
    @NotNull
    public Fir2IrTypeConverter getTypeConverter() {
        return this.components.getTypeConverter();
    }
}

