/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.SpecialBridgeMethodsKt;
import org.jetbrains.kotlin.backend.common.lower.SpecialMethodWithDefaultInfo;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0012J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u0012J\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0012J\"\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u0014H\u0002J\f\u0010$\u001a\u00020\u0007*\u00020\u0012H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SpecialBridgeMethods;", "", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "SPECIAL_METHODS_SETS", "", "Lorg/jetbrains/kotlin/backend/common/lower/SpecialBridgeMethods$SpecialMethodDescription;", "SPECIAL_METHODS_WITH_DEFAULTS_MAP", "", "Lorg/jetbrains/kotlin/backend/common/lower/SpecialMethodWithDefaultInfo;", "SPECIAL_PROPERTIES_SET", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "constFalse", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "", "bridge", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "constMinusOne", "", "constNull", "", "findSpecialWithOverride", "Lkotlin/Pair;", "irFunction", "getSecondArg", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetValueImpl;", "getSpecialMethodInfo", "isBuiltInWithDifferentJvmName", "makeDescription", "classFqName", "Lorg/jetbrains/kotlin/name/FqName;", "funName", "", "arity", "toDescription", "SpecialMethodDescription", "ir.backend.common"})
public final class SpecialBridgeMethods {
    private final Map<SpecialMethodDescription, SpecialMethodWithDefaultInfo> SPECIAL_METHODS_WITH_DEFAULTS_MAP;
    private final Set<SpecialMethodDescription> SPECIAL_PROPERTIES_SET;
    private final Set<SpecialMethodDescription> SPECIAL_METHODS_SETS;
    @NotNull
    private final CommonBackendContext context;

    private final SpecialMethodDescription makeDescription(FqName classFqName, String funName, int arity) {
        Name name = Name.identifier(funName);
        Intrinsics.checkNotNullExpressionValue(name, "Name.identifier(funName)");
        return new SpecialMethodDescription(classFqName, name, arity);
    }

    static /* synthetic */ SpecialMethodDescription makeDescription$default(SpecialBridgeMethods specialBridgeMethods, FqName fqName2, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return specialBridgeMethods.makeDescription(fqName2, string2, n);
    }

    private final SpecialMethodDescription toDescription(IrSimpleFunction $this$toDescription) {
        return new SpecialMethodDescription(IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass($this$toDescription)), $this$toDescription.getName(), $this$toDescription.getValueParameters().size());
    }

    private final IrConstImpl<Boolean> constFalse(IrSimpleFunction bridge) {
        return new IrConstImpl<Boolean>(-1, -1, this.context.getIrBuiltIns().getBooleanType(), IrConstKind.Boolean.INSTANCE, false);
    }

    private final IrConstImpl constNull(IrSimpleFunction bridge) {
        return new IrConstImpl<Object>(-1, -1, this.context.getIrBuiltIns().getAnyNType(), IrConstKind.Null.INSTANCE, null);
    }

    private final IrConstImpl<Integer> constMinusOne(IrSimpleFunction bridge) {
        return new IrConstImpl<Integer>(-1, -1, this.context.getIrBuiltIns().getIntType(), IrConstKind.Int.INSTANCE, -1);
    }

    private final IrGetValueImpl getSecondArg(IrSimpleFunction bridge) {
        return new IrGetValueImpl(-1, -1, (IrValueSymbol)bridge.getValueParameters().get(1).getSymbol(), null, 8, null);
    }

    @Nullable
    public final Pair<IrSimpleFunction, SpecialMethodWithDefaultInfo> findSpecialWithOverride(@NotNull IrSimpleFunction irFunction) {
        Intrinsics.checkNotNullParameter(irFunction, "irFunction");
        Sequence<IrSimpleFunction> $this$forEach$iv = SpecialBridgeMethodsKt.allOverridden(irFunction);
        boolean $i$f$forEach = false;
        Iterator<IrSimpleFunction> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            IrSimpleFunction element$iv;
            IrSimpleFunction overridden = element$iv = iterator2.next();
            boolean bl = false;
            SpecialMethodDescription description2 = this.toDescription(overridden);
            SpecialMethodWithDefaultInfo specialMethodWithDefaultInfo = this.SPECIAL_METHODS_WITH_DEFAULTS_MAP.get(description2);
            if (specialMethodWithDefaultInfo == null) continue;
            SpecialMethodWithDefaultInfo specialMethodWithDefaultInfo2 = specialMethodWithDefaultInfo;
            boolean bl2 = false;
            boolean bl3 = false;
            SpecialMethodWithDefaultInfo it = specialMethodWithDefaultInfo2;
            boolean bl4 = false;
            return new Pair<IrSimpleFunction, SpecialMethodWithDefaultInfo>(overridden, it);
        }
        return null;
    }

    @Nullable
    public final SpecialMethodWithDefaultInfo getSpecialMethodInfo(@NotNull IrSimpleFunction irFunction) {
        Intrinsics.checkNotNullParameter(irFunction, "irFunction");
        SpecialMethodDescription description2 = this.toDescription(irFunction);
        return this.SPECIAL_METHODS_WITH_DEFAULTS_MAP.get(description2);
    }

    public final boolean isBuiltInWithDifferentJvmName(@NotNull IrSimpleFunction irFunction) {
        Intrinsics.checkNotNullParameter(irFunction, "irFunction");
        IrPropertySymbol irPropertySymbol = irFunction.getCorrespondingPropertySymbol();
        if (irPropertySymbol != null) {
            IrPropertySymbol irPropertySymbol2 = irPropertySymbol;
            boolean bl = false;
            boolean bl2 = false;
            IrPropertySymbol it = irPropertySymbol2;
            boolean bl3 = false;
            FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass(irFunction));
            if (fqName2 == null) {
                return false;
            }
            FqName classFqName = fqName2;
            String string2 = ((IrProperty)it.getOwner()).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "it.owner.name.asString()");
            return this.SPECIAL_PROPERTIES_SET.contains(SpecialBridgeMethods.makeDescription$default(this, classFqName, string2, 0, 4, null));
        }
        return this.SPECIAL_METHODS_SETS.contains(this.toDescription(irFunction));
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public SpecialBridgeMethods(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        Pair[] pairArray = new Pair[10];
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.collection;
        Intrinsics.checkNotNullExpressionValue(fqName2, "KotlinBuiltIns.FQ_NAMES.collection");
        pairArray[0] = TuplesKt.to(this.makeDescription(fqName2, "contains", 1), new SpecialMethodWithDefaultInfo(new Function1<IrSimpleFunction, IrConstImpl<Boolean>>(this){

            @NotNull
            public final IrConstImpl<Boolean> invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                return SpecialBridgeMethods.access$constFalse((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "constFalse";
            }

            public final String getSignature() {
                return "constFalse(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }
        }, 1, false, 4, null));
        FqName fqName3 = KotlinBuiltIns.FQ_NAMES.mutableCollection;
        Intrinsics.checkNotNullExpressionValue(fqName3, "KotlinBuiltIns.FQ_NAMES.mutableCollection");
        pairArray[1] = TuplesKt.to(this.makeDescription(fqName3, "remove", 1), new SpecialMethodWithDefaultInfo((Function1<? super IrSimpleFunction, ? extends IrExpression>)new Function1<IrSimpleFunction, IrConstImpl<Boolean>>(this){

            @NotNull
            public final IrConstImpl<Boolean> invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                return SpecialBridgeMethods.access$constFalse((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "constFalse";
            }

            public final String getSignature() {
                return "constFalse(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }
        }, 1, true));
        FqName fqName4 = KotlinBuiltIns.FQ_NAMES.map;
        Intrinsics.checkNotNullExpressionValue(fqName4, "KotlinBuiltIns.FQ_NAMES.map");
        pairArray[2] = TuplesKt.to(this.makeDescription(fqName4, "containsKey", 1), new SpecialMethodWithDefaultInfo(new Function1<IrSimpleFunction, IrConstImpl<Boolean>>(this){

            @NotNull
            public final IrConstImpl<Boolean> invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                return SpecialBridgeMethods.access$constFalse((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "constFalse";
            }

            public final String getSignature() {
                return "constFalse(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }
        }, 1, false, 4, null));
        FqName fqName5 = KotlinBuiltIns.FQ_NAMES.map;
        Intrinsics.checkNotNullExpressionValue(fqName5, "KotlinBuiltIns.FQ_NAMES.map");
        pairArray[3] = TuplesKt.to(this.makeDescription(fqName5, "containsValue", 1), new SpecialMethodWithDefaultInfo(new Function1<IrSimpleFunction, IrConstImpl<Boolean>>(this){

            @NotNull
            public final IrConstImpl<Boolean> invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                return SpecialBridgeMethods.access$constFalse((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "constFalse";
            }

            public final String getSignature() {
                return "constFalse(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }
        }, 1, false, 4, null));
        FqName fqName6 = KotlinBuiltIns.FQ_NAMES.mutableMap;
        Intrinsics.checkNotNullExpressionValue(fqName6, "KotlinBuiltIns.FQ_NAMES.mutableMap");
        pairArray[4] = TuplesKt.to(this.makeDescription(fqName6, "remove", 2), new SpecialMethodWithDefaultInfo(new Function1<IrSimpleFunction, IrConstImpl<Boolean>>(this){

            @NotNull
            public final IrConstImpl<Boolean> invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                return SpecialBridgeMethods.access$constFalse((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "constFalse";
            }

            public final String getSignature() {
                return "constFalse(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }
        }, 2, false, 4, null));
        FqName fqName7 = KotlinBuiltIns.FQ_NAMES.map;
        Intrinsics.checkNotNullExpressionValue(fqName7, "KotlinBuiltIns.FQ_NAMES.map");
        pairArray[5] = TuplesKt.to(this.makeDescription(fqName7, "getOrDefault", 2), new SpecialMethodWithDefaultInfo(new Function1<IrSimpleFunction, IrGetValueImpl>(this){

            @NotNull
            public final IrGetValueImpl invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                return SpecialBridgeMethods.access$getSecondArg((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "getSecondArg";
            }

            public final String getSignature() {
                return "getSecondArg(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetValueImpl;";
            }
        }, 1, false, 4, null));
        FqName fqName8 = KotlinBuiltIns.FQ_NAMES.map;
        Intrinsics.checkNotNullExpressionValue(fqName8, "KotlinBuiltIns.FQ_NAMES.map");
        pairArray[6] = TuplesKt.to(this.makeDescription(fqName8, "get", 1), new SpecialMethodWithDefaultInfo(new Function1<IrSimpleFunction, IrConstImpl>(this){

            @NotNull
            public final IrConstImpl invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                return SpecialBridgeMethods.access$constNull((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "constNull";
            }

            public final String getSignature() {
                return "constNull(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }
        }, 1, false, 4, null));
        FqName fqName9 = KotlinBuiltIns.FQ_NAMES.mutableMap;
        Intrinsics.checkNotNullExpressionValue(fqName9, "KotlinBuiltIns.FQ_NAMES.mutableMap");
        pairArray[7] = TuplesKt.to(this.makeDescription(fqName9, "remove", 1), new SpecialMethodWithDefaultInfo(new Function1<IrSimpleFunction, IrConstImpl>(this){

            @NotNull
            public final IrConstImpl invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                return SpecialBridgeMethods.access$constNull((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "constNull";
            }

            public final String getSignature() {
                return "constNull(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }
        }, 1, false, 4, null));
        FqName fqName10 = KotlinBuiltIns.FQ_NAMES.list;
        Intrinsics.checkNotNullExpressionValue(fqName10, "KotlinBuiltIns.FQ_NAMES.list");
        pairArray[8] = TuplesKt.to(this.makeDescription(fqName10, "indexOf", 1), new SpecialMethodWithDefaultInfo(new Function1<IrSimpleFunction, IrConstImpl<Integer>>(this){

            @NotNull
            public final IrConstImpl<Integer> invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                return SpecialBridgeMethods.access$constMinusOne((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "constMinusOne";
            }

            public final String getSignature() {
                return "constMinusOne(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }
        }, 1, false, 4, null));
        FqName fqName11 = KotlinBuiltIns.FQ_NAMES.list;
        Intrinsics.checkNotNullExpressionValue(fqName11, "KotlinBuiltIns.FQ_NAMES.list");
        pairArray[9] = TuplesKt.to(this.makeDescription(fqName11, "lastIndexOf", 1), new SpecialMethodWithDefaultInfo(new Function1<IrSimpleFunction, IrConstImpl<Integer>>(this){

            @NotNull
            public final IrConstImpl<Integer> invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                return SpecialBridgeMethods.access$constMinusOne((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "constMinusOne";
            }

            public final String getSignature() {
                return "constMinusOne(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }
        }, 1, false, 4, null));
        this.SPECIAL_METHODS_WITH_DEFAULTS_MAP = MapsKt.mapOf(pairArray);
        SpecialMethodDescription[] specialMethodDescriptionArray = new SpecialMethodDescription[6];
        FqName fqName12 = KotlinBuiltIns.FQ_NAMES.collection;
        Intrinsics.checkNotNullExpressionValue(fqName12, "KotlinBuiltIns.FQ_NAMES.collection");
        specialMethodDescriptionArray[0] = SpecialBridgeMethods.makeDescription$default(this, fqName12, "size", 0, 4, null);
        FqName fqName13 = KotlinBuiltIns.FQ_NAMES.map;
        Intrinsics.checkNotNullExpressionValue(fqName13, "KotlinBuiltIns.FQ_NAMES.map");
        specialMethodDescriptionArray[1] = SpecialBridgeMethods.makeDescription$default(this, fqName13, "size", 0, 4, null);
        FqName fqName14 = KotlinBuiltIns.FQ_NAMES.charSequence.toSafe();
        Intrinsics.checkNotNullExpressionValue(fqName14, "KotlinBuiltIns.FQ_NAMES.charSequence.toSafe()");
        specialMethodDescriptionArray[2] = SpecialBridgeMethods.makeDescription$default(this, fqName14, "length", 0, 4, null);
        FqName fqName15 = KotlinBuiltIns.FQ_NAMES.map;
        Intrinsics.checkNotNullExpressionValue(fqName15, "KotlinBuiltIns.FQ_NAMES.map");
        specialMethodDescriptionArray[3] = SpecialBridgeMethods.makeDescription$default(this, fqName15, "keys", 0, 4, null);
        FqName fqName16 = KotlinBuiltIns.FQ_NAMES.map;
        Intrinsics.checkNotNullExpressionValue(fqName16, "KotlinBuiltIns.FQ_NAMES.map");
        specialMethodDescriptionArray[4] = SpecialBridgeMethods.makeDescription$default(this, fqName16, "values", 0, 4, null);
        FqName fqName17 = KotlinBuiltIns.FQ_NAMES.map;
        Intrinsics.checkNotNullExpressionValue(fqName17, "KotlinBuiltIns.FQ_NAMES.map");
        specialMethodDescriptionArray[5] = SpecialBridgeMethods.makeDescription$default(this, fqName17, "entries", 0, 4, null);
        this.SPECIAL_PROPERTIES_SET = SetsKt.setOf(specialMethodDescriptionArray);
        SpecialMethodDescription[] specialMethodDescriptionArray2 = new SpecialMethodDescription[8];
        FqName fqName18 = KotlinBuiltIns.FQ_NAMES.number.toSafe();
        Intrinsics.checkNotNullExpressionValue(fqName18, "KotlinBuiltIns.FQ_NAMES.number.toSafe()");
        specialMethodDescriptionArray2[0] = SpecialBridgeMethods.makeDescription$default(this, fqName18, "toByte", 0, 4, null);
        FqName fqName19 = KotlinBuiltIns.FQ_NAMES.number.toSafe();
        Intrinsics.checkNotNullExpressionValue(fqName19, "KotlinBuiltIns.FQ_NAMES.number.toSafe()");
        specialMethodDescriptionArray2[1] = SpecialBridgeMethods.makeDescription$default(this, fqName19, "toShort", 0, 4, null);
        FqName fqName20 = KotlinBuiltIns.FQ_NAMES.number.toSafe();
        Intrinsics.checkNotNullExpressionValue(fqName20, "KotlinBuiltIns.FQ_NAMES.number.toSafe()");
        specialMethodDescriptionArray2[2] = SpecialBridgeMethods.makeDescription$default(this, fqName20, "toInt", 0, 4, null);
        FqName fqName21 = KotlinBuiltIns.FQ_NAMES.number.toSafe();
        Intrinsics.checkNotNullExpressionValue(fqName21, "KotlinBuiltIns.FQ_NAMES.number.toSafe()");
        specialMethodDescriptionArray2[3] = SpecialBridgeMethods.makeDescription$default(this, fqName21, "toLong", 0, 4, null);
        FqName fqName22 = KotlinBuiltIns.FQ_NAMES.number.toSafe();
        Intrinsics.checkNotNullExpressionValue(fqName22, "KotlinBuiltIns.FQ_NAMES.number.toSafe()");
        specialMethodDescriptionArray2[4] = SpecialBridgeMethods.makeDescription$default(this, fqName22, "toFloat", 0, 4, null);
        FqName fqName23 = KotlinBuiltIns.FQ_NAMES.number.toSafe();
        Intrinsics.checkNotNullExpressionValue(fqName23, "KotlinBuiltIns.FQ_NAMES.number.toSafe()");
        specialMethodDescriptionArray2[5] = SpecialBridgeMethods.makeDescription$default(this, fqName23, "toDouble", 0, 4, null);
        FqName fqName24 = KotlinBuiltIns.FQ_NAMES.mutableList;
        Intrinsics.checkNotNullExpressionValue(fqName24, "KotlinBuiltIns.FQ_NAMES.mutableList");
        specialMethodDescriptionArray2[6] = this.makeDescription(fqName24, "removeAt", 1);
        FqName fqName25 = KotlinBuiltIns.FQ_NAMES.charSequence.toSafe();
        Intrinsics.checkNotNullExpressionValue(fqName25, "KotlinBuiltIns.FQ_NAMES.charSequence.toSafe()");
        specialMethodDescriptionArray2[7] = this.makeDescription(fqName25, "get", 1);
        this.SPECIAL_METHODS_SETS = SetsKt.setOf(specialMethodDescriptionArray2);
    }

    public static final /* synthetic */ IrConstImpl access$constFalse(SpecialBridgeMethods $this, IrSimpleFunction bridge) {
        return $this.constFalse(bridge);
    }

    public static final /* synthetic */ IrGetValueImpl access$getSecondArg(SpecialBridgeMethods $this, IrSimpleFunction bridge) {
        return $this.getSecondArg(bridge);
    }

    public static final /* synthetic */ IrConstImpl access$constNull(SpecialBridgeMethods $this, IrSimpleFunction bridge) {
        return $this.constNull(bridge);
    }

    public static final /* synthetic */ IrConstImpl access$constMinusOne(SpecialBridgeMethods $this, IrSimpleFunction bridge) {
        return $this.constMinusOne(bridge);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SpecialBridgeMethods$SpecialMethodDescription;", "", "kotlinFqClassName", "Lorg/jetbrains/kotlin/name/FqName;", "name", "Lorg/jetbrains/kotlin/name/Name;", "arity", "", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;I)V", "getArity", "()I", "getKotlinFqClassName", "()Lorg/jetbrains/kotlin/name/FqName;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "ir.backend.common"})
    private static final class SpecialMethodDescription {
        @Nullable
        private final FqName kotlinFqClassName;
        @NotNull
        private final Name name;
        private final int arity;

        @Nullable
        public final FqName getKotlinFqClassName() {
            return this.kotlinFqClassName;
        }

        @NotNull
        public final Name getName() {
            return this.name;
        }

        public final int getArity() {
            return this.arity;
        }

        public SpecialMethodDescription(@Nullable FqName kotlinFqClassName, @NotNull Name name, int arity) {
            Intrinsics.checkNotNullParameter(name, "name");
            this.kotlinFqClassName = kotlinFqClassName;
            this.name = name;
            this.arity = arity;
        }

        @Nullable
        public final FqName component1() {
            return this.kotlinFqClassName;
        }

        @NotNull
        public final Name component2() {
            return this.name;
        }

        public final int component3() {
            return this.arity;
        }

        @NotNull
        public final SpecialMethodDescription copy(@Nullable FqName kotlinFqClassName, @NotNull Name name, int arity) {
            Intrinsics.checkNotNullParameter(name, "name");
            return new SpecialMethodDescription(kotlinFqClassName, name, arity);
        }

        public static /* synthetic */ SpecialMethodDescription copy$default(SpecialMethodDescription specialMethodDescription, FqName fqName2, Name name, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                fqName2 = specialMethodDescription.kotlinFqClassName;
            }
            if ((n2 & 2) != 0) {
                name = specialMethodDescription.name;
            }
            if ((n2 & 4) != 0) {
                n = specialMethodDescription.arity;
            }
            return specialMethodDescription.copy(fqName2, name, n);
        }

        @NotNull
        public String toString() {
            return "SpecialMethodDescription(kotlinFqClassName=" + this.kotlinFqClassName + ", name=" + this.name + ", arity=" + this.arity + ")";
        }

        public int hashCode() {
            FqName fqName2 = this.kotlinFqClassName;
            Name name = this.name;
            return ((fqName2 != null ? ((Object)fqName2).hashCode() : 0) * 31 + (name != null ? ((Object)name).hashCode() : 0)) * 31 + Integer.hashCode(this.arity);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SpecialMethodDescription)) break block3;
                    SpecialMethodDescription specialMethodDescription = (SpecialMethodDescription)object;
                    if (!Intrinsics.areEqual(this.kotlinFqClassName, specialMethodDescription.kotlinFqClassName) || !Intrinsics.areEqual(this.name, specialMethodDescription.name) || this.arity != specialMethodDescription.arity) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

