/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.AbstractBundle;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.java.parser.DeclarationParser;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileParser {
    protected static final TokenSet IMPORT_LIST_STOPPER_SET = TokenSet.orSet(ElementType.MODIFIER_BIT_SET, TokenSet.create(JavaTokenType.CLASS_KEYWORD, JavaTokenType.INTERFACE_KEYWORD, JavaTokenType.ENUM_KEYWORD, JavaTokenType.AT));
    private final JavaParser myParser;

    public FileParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            FileParser.$$$reportNull$$$0(0);
        }
        this.myParser = javaParser;
    }

    public void parse(@NotNull PsiBuilder builder) {
        if (builder == null) {
            FileParser.$$$reportNull$$$0(1);
        }
        this.parseFile(builder, FileParser::stopImportListParsing, JavaErrorMessages.INSTANCE, "expected.class.or.interface");
    }

    public void parseFile(@NotNull PsiBuilder builder, @NotNull Predicate<? super PsiBuilder> importListStopper, @NotNull AbstractBundle bundle, @NotNull String errorMessageKey) {
        if (builder == null) {
            FileParser.$$$reportNull$$$0(2);
        }
        if (importListStopper == null) {
            FileParser.$$$reportNull$$$0(3);
        }
        if (bundle == null) {
            FileParser.$$$reportNull$$$0(4);
        }
        if (errorMessageKey == null) {
            FileParser.$$$reportNull$$$0(5);
        }
        this.parsePackageStatement(builder);
        Pair<PsiBuilder.Marker, Boolean> impListInfo = this.parseImportList(builder, importListStopper);
        Boolean firstDeclarationOk = null;
        PsiBuilder.Marker firstDeclaration = null;
        PsiBuilder.Marker invalidElements = null;
        while (!builder.eof()) {
            if (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker declaration2 = this.myParser.getModuleParser().parse(builder);
            if (declaration2 == null) {
                declaration2 = this.parseInitial(builder);
            }
            if (declaration2 != null) {
                if (invalidElements != null) {
                    invalidElements.errorBefore(FileParser.error(bundle, errorMessageKey), declaration2);
                    invalidElements = null;
                }
                if (firstDeclarationOk != null || !(firstDeclarationOk = Boolean.valueOf(JavaParserUtil.exprType(declaration2) != JavaElementType.MODIFIER_LIST)).booleanValue()) continue;
                firstDeclaration = declaration2;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder.mark();
            }
            builder.advanceLexer();
            if (firstDeclarationOk != null) continue;
            firstDeclarationOk = false;
        }
        if (invalidElements != null) {
            invalidElements.error(FileParser.error(bundle, errorMessageKey));
        }
        if (((Boolean)impListInfo.second).booleanValue() && firstDeclarationOk == Boolean.TRUE) {
            ((PsiBuilder.Marker)impListInfo.first).setCustomEdgeTokenBinders(JavaParserUtil.PRECEDING_COMMENT_BINDER, null);
            firstDeclaration.setCustomEdgeTokenBinders(JavaParserUtil.SPECIAL_PRECEDING_COMMENT_BINDER, null);
        }
    }

    private static boolean stopImportListParsing(PsiBuilder b) {
        String text2;
        IElementType type2 = b.getTokenType();
        if (IMPORT_LIST_STOPPER_SET.contains(type2)) {
            return true;
        }
        return type2 == JavaTokenType.IDENTIFIER && ("open".equals(text2 = b.getTokenText()) || "module".equals(text2));
    }

    @Nullable
    protected PsiBuilder.Marker parseInitial(PsiBuilder builder) {
        return this.myParser.getDeclarationParser().parse(builder, DeclarationParser.Context.FILE);
    }

    private void parsePackageStatement(PsiBuilder builder) {
        PsiBuilder.Marker ref;
        PsiBuilder.Marker statement2 = builder.mark();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.PACKAGE_KEYWORD)) {
            PsiBuilder.Marker modList = builder.mark();
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            JavaParserUtil.done(modList, JavaElementType.MODIFIER_LIST);
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.PACKAGE_KEYWORD)) {
                statement2.rollbackTo();
                return;
            }
        }
        if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, false, false, false)) == null) {
            statement2.error(JavaErrorMessages.message("expected.class.or.interface", new Object[0]));
            return;
        }
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement2, JavaElementType.PACKAGE_STATEMENT);
    }

    @NotNull
    protected Pair<PsiBuilder.Marker, Boolean> parseImportList(PsiBuilder builder, Predicate<? super PsiBuilder> stopper) {
        PsiBuilder.Marker list2 = builder.mark();
        boolean isEmpty2 = true;
        PsiBuilder.Marker invalidElements = null;
        while (!builder.eof() && !stopper.test(builder)) {
            if (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker statement2 = this.parseImportStatement(builder);
            if (statement2 != null) {
                isEmpty2 = false;
                if (invalidElements == null) continue;
                invalidElements.errorBefore(JavaErrorMessages.message("unexpected.token", new Object[0]), statement2);
                invalidElements = null;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder.mark();
            }
            builder.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.rollbackTo();
        }
        if (isEmpty2) {
            PsiBuilder.Marker precede = list2.precede();
            list2.rollbackTo();
            list2 = precede;
        }
        JavaParserUtil.done(list2, JavaElementType.IMPORT_LIST);
        Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(list2, isEmpty2);
        if (pair == null) {
            FileParser.$$$reportNull$$$0(6);
        }
        return pair;
    }

    @Nullable
    protected PsiBuilder.Marker parseImportStatement(PsiBuilder builder) {
        if (builder.getTokenType() != JavaTokenType.IMPORT_KEYWORD) {
            return null;
        }
        PsiBuilder.Marker statement2 = builder.mark();
        builder.advanceLexer();
        boolean isStatic = PsiBuilderUtil.expect(builder, JavaTokenType.STATIC_KEYWORD);
        IElementType type2 = isStatic ? JavaElementType.IMPORT_STATIC_STATEMENT : JavaElementType.IMPORT_STATEMENT;
        boolean isOk = this.myParser.getReferenceParser().parseImportCodeReference(builder, isStatic);
        if (isOk) {
            JavaParserUtil.semicolon(builder);
        }
        JavaParserUtil.done(statement2, type2);
        return statement2;
    }

    @NotNull
    private static String error(@NotNull AbstractBundle bundle, @NotNull String errorMessageKey) {
        if (bundle == null) {
            FileParser.$$$reportNull$$$0(7);
        }
        if (errorMessageKey == null) {
            FileParser.$$$reportNull$$$0(8);
        }
        String string2 = bundle.getMessage(errorMessageKey, new Object[0]);
        if (string2 == null) {
            FileParser.$$$reportNull$$$0(9);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importListStopper";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessageKey";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/FileParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/FileParser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseImportList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseFile";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

