/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage;

import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupRemoteDescriptors;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.EnumValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RegexpValidationRule;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B7\u0012\u001a\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b\u0018\u00010\u0006\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0007R\"\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/storage/GlobalRulesHolder;", "", "globalRules", "Lcom/intellij/internal/statistic/eventLog/connection/metadata/EventGroupRemoteDescriptors$GroupRemoteRule;", "(Lcom/intellij/internal/statistic/eventLog/connection/metadata/EventGroupRemoteDescriptors$GroupRemoteRule;)V", "myGlobalEnums", "", "", "", "myGlobalRegexps", "(Ljava/util/Map;Ljava/util/Map;)V", "myGlobalEnumsCache", "", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/EnumValidationRule;", "myGlobalRegexpsCache", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/RegexpValidationRule;", "getEnumValidationRules", "enumRef", "getRegexpValidationRules", "regexpRef", "intellij.platform.statistics"})
public final class GlobalRulesHolder {
    private final Map<String, RegexpValidationRule> myGlobalRegexpsCache;
    private final Map<String, EnumValidationRule> myGlobalEnumsCache;
    private final Map<String, Set<String>> myGlobalEnums;
    private final Map<String, String> myGlobalRegexps;

    @Nullable
    public final EnumValidationRule getEnumValidationRules(@NotNull String enumRef) {
        Set<String> globalEnum;
        Intrinsics.checkNotNullParameter((Object)enumRef, (String)"enumRef");
        EnumValidationRule cachedValue = this.myGlobalEnumsCache.get(enumRef);
        if (cachedValue != null) {
            return cachedValue;
        }
        Map<String, Set<String>> map = this.myGlobalEnums;
        Set<String> set = globalEnum = map != null ? map.get(enumRef) : null;
        if (globalEnum != null) {
            EnumValidationRule rule = new EnumValidationRule((Collection<String>)globalEnum);
            this.myGlobalEnumsCache.put(enumRef, rule);
            return rule;
        }
        return null;
    }

    @Nullable
    public final RegexpValidationRule getRegexpValidationRules(@NotNull String regexpRef) {
        String globalRegexp;
        Intrinsics.checkNotNullParameter((Object)regexpRef, (String)"regexpRef");
        RegexpValidationRule cachedValue = this.myGlobalRegexpsCache.get(regexpRef);
        if (cachedValue != null) {
            return cachedValue;
        }
        Map<String, String> map = this.myGlobalRegexps;
        String string = globalRegexp = map != null ? map.get(regexpRef) : null;
        if (globalRegexp != null) {
            RegexpValidationRule rule = new RegexpValidationRule(globalRegexp);
            this.myGlobalRegexpsCache.put(regexpRef, rule);
            return rule;
        }
        return null;
    }

    public GlobalRulesHolder(@Nullable Map<String, ? extends Set<String>> myGlobalEnums, @Nullable Map<String, String> myGlobalRegexps) {
        this.myGlobalEnums = myGlobalEnums;
        this.myGlobalRegexps = myGlobalRegexps;
        this.myGlobalRegexpsCache = new HashMap();
        this.myGlobalEnumsCache = new HashMap();
    }

    public GlobalRulesHolder(@Nullable EventGroupRemoteDescriptors.GroupRemoteRule globalRules) {
        EventGroupRemoteDescriptors.GroupRemoteRule groupRemoteRule = globalRules;
        EventGroupRemoteDescriptors.GroupRemoteRule groupRemoteRule2 = globalRules;
        this(groupRemoteRule != null ? groupRemoteRule.enums : null, groupRemoteRule2 != null ? groupRemoteRule2.regexps : null);
    }
}

