/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogChangeProcessor
extends ChangeViewDiffRequestProcessor {
    @NotNull
    private final VcsLogChangesBrowser myBrowser;

    VcsLogChangeProcessor(@NotNull Project project, @NotNull VcsLogChangesBrowser browser2, boolean isInEditor, @NotNull Disposable disposable) {
        if (project == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(0);
        }
        if (browser2 == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(2);
        }
        super(project, isInEditor ? "Default" : "VcsLogView");
        this.myBrowser = browser2;
        this.myContentPanel.setBorder(IdeBorderFactory.createBorder((int)2));
        Disposer.register((Disposable)disposable, (Disposable)this);
        this.myBrowser.addListener(() -> this.updatePreviewLater(), (Disposable)this);
        this.myBrowser.getViewer().addSelectionListener(this::updatePreviewLater, (Disposable)this);
    }

    protected boolean shouldAddToolbarBottomBorder(@NotNull FrameDiffTool.ToolbarComponents toolbarComponents) {
        if (toolbarComponents == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(3);
        }
        return false;
    }

    @NotNull
    public Wrapper getToolbarWrapper() {
        Wrapper wrapper = this.myToolbarWrapper;
        if (wrapper == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(4);
        }
        return wrapper;
    }

    @Override
    @NotNull
    public Stream<ChangeViewDiffRequestProcessor.Wrapper> getSelectedChanges() {
        boolean hasSelection = this.myBrowser.getViewer().getSelectionModel().getSelectionCount() != 0;
        return this.wrap(hasSelection ? VcsTreeModelData.selected((JTree)((Object)this.myBrowser.getViewer())) : VcsTreeModelData.all((JTree)((Object)this.myBrowser.getViewer())));
    }

    @Override
    @NotNull
    public Stream<ChangeViewDiffRequestProcessor.Wrapper> getAllChanges() {
        return this.wrap(VcsTreeModelData.all((JTree)((Object)this.myBrowser.getViewer())));
    }

    @NotNull
    private Stream<ChangeViewDiffRequestProcessor.Wrapper> wrap(@NotNull VcsTreeModelData modelData) {
        if (modelData == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(5);
        }
        Stream<ChangeViewDiffRequestProcessor.Wrapper> stream = modelData.userObjectsStream(Change.class).map(x$0 -> new MyChangeWrapper((Change)x$0));
        if (stream == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(6);
        }
        return stream;
    }

    @Override
    protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
        ChangesTree tree;
        DefaultMutableTreeNode root;
        DefaultMutableTreeNode objectNode;
        TreePath path2;
        if (change == null) {
            VcsLogChangeProcessor.$$$reportNull$$$0(7);
        }
        TreePath treePath = path2 = (objectNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)(root = (DefaultMutableTreeNode)(tree = this.myBrowser.getViewer()).getModel().getRoot()), (Object)change.getUserObject())) != null ? TreeUtil.getPathFromRoot((TreeNode)objectNode) : null;
        if (path2 != null) {
            TreeUtil.selectPath((JTree)((Object)tree), (TreePath)path2, (boolean)false);
        }
    }

    private void updatePreviewLater() {
        ApplicationManager.getApplication().invokeLater(() -> this.updatePreview(this.getComponent().isShowing()));
    }

    public void updatePreview(boolean state) {
        this.updatePreview(state, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbarComponents";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/VcsLogChangeProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/VcsLogChangeProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarWrapper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddToolbarBottomBorder";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyChangeWrapper
    extends ChangeViewDiffRequestProcessor.ChangeWrapper {
        MyChangeWrapper(Change change) {
            if (change == null) {
                MyChangeWrapper.$$$reportNull$$$0(0);
            }
            super(change);
        }

        @Override
        @Nullable
        public DiffRequestProducer createProducer(@Nullable Project project) {
            return VcsLogChangeProcessor.this.myBrowser.getDiffRequestProducer(this.change, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/vcs/log/ui/frame/VcsLogChangeProcessor$MyChangeWrapper", "<init>"));
        }
    }
}

