/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.table.column.VcsLogColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnUtilKt;
import com.intellij.vcs.log.ui.table.column.VcsLogCustomColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogDefaultColumnKt;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleLogColumnsActionGroup
extends ActionGroup
implements DumbAware {
    public ToggleLogColumnsActionGroup() {
        super(VcsLogBundle.message((String)"action.title.select.columns.to.see", (Object[])new Object[0]), VcsLogBundle.message((String)"action.description.select.columns.to.see", (Object[])new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleLogColumnsActionGroup.$$$reportNull$$$0(0);
        }
        super.update(e);
        this.setPopup(ToggleLogColumnsActionGroup.isPopup(e));
        e.getPresentation().setEnabledAndVisible(ToggleLogColumnsActionGroup.isEnabledAndVisible(e));
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        ArrayList<Object> actions = new ArrayList<Object>();
        if (e != null && !ToggleLogColumnsActionGroup.isPopup(e)) {
            actions.add(Separator.create((String)VcsLogBundle.message((String)"action.title.select.columns.to.see", (Object[])new Object[0])));
        }
        for (VcsLogColumn vcsLogColumn : VcsLogDefaultColumnKt.getDefaultDynamicColumns()) {
            actions.add((Object)new ToggleColumnAction(vcsLogColumn));
        }
        for (VcsLogColumn vcsLogColumn : ContainerUtil.filter((Collection)VcsLogCustomColumn.KEY.getExtensionList(), it -> it.isDynamic())) {
            actions.add((Object)new ToggleColumnAction(vcsLogColumn));
        }
        AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            ToggleLogColumnsActionGroup.$$$reportNull$$$0(1);
        }
        return anActionArray;
    }

    private static boolean isPopup(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleLogColumnsActionGroup.$$$reportNull$$$0(2);
        }
        return e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI) == null;
    }

    private static boolean isEnabledAndVisible(@NotNull AnActionEvent e) {
        VcsLogUiProperties properties;
        if (e == null) {
            ToggleLogColumnsActionGroup.$$$reportNull$$$0(3);
        }
        return (properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES)) != null && VcsLogColumnUtilKt.supportsColumnsToggling(properties);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/actions/ToggleLogColumnsActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/actions/ToggleLogColumnsActionGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPopup";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledAndVisible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ToggleColumnAction
    extends ToggleAction
    implements DumbAware {
        private final VcsLogColumn<?> myColumn;

        private ToggleColumnAction(@NotNull VcsLogColumn<?> column) {
            if (column == null) {
                ToggleColumnAction.$$$reportNull$$$0(0);
            }
            super(() -> column.getLocalizedName());
            this.myColumn = column;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            VcsLogUiProperties properties;
            if (e == null) {
                ToggleColumnAction.$$$reportNull$$$0(1);
            }
            if ((properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES)) != null) {
                return VcsLogColumnUtilKt.isVisible(this.myColumn, properties);
            }
            return false;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleColumnAction.$$$reportNull$$$0(2);
            }
            VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
            VcsLogUiProperties properties = (VcsLogUiProperties)e.getRequiredData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
            assert (VcsLogColumnUtilKt.supportsColumnsToggling(properties));
            if (state) {
                VcsLogColumnUtilKt.addColumn(properties, this.myColumn);
            } else {
                VcsLogColumnUtilKt.removeColumn(properties, this.myColumn);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleColumnAction.$$$reportNull$$$0(3);
            }
            super.update(e);
            e.getPresentation().setEnabledAndVisible(ToggleLogColumnsActionGroup.isEnabledAndVisible(e));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/actions/ToggleLogColumnsActionGroup$ToggleColumnAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

