/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.icons.AllIcons;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.commit.CommitCheckFailure;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0006\u0010\u0012\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u000eJ\b\u0010\u0017\u001a\u00020\u000eH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/vcs/commit/FailuresPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "()V", "description", "Ljavax/swing/JEditorPane;", "Lorg/jetbrains/annotations/NotNull;", "failures", "", "", "Lcom/intellij/vcs/commit/CommitCheckFailure;", "iconLabel", "Lcom/intellij/ui/components/JBLabel;", "nextFailureId", "addFailure", "", "failure", "buildDescription", "Lcom/intellij/openapi/util/text/HtmlChunk;", "endProgress", "showDetails", "event", "Ljavax/swing/event/HyperlinkEvent;", "startProgress", "update", "intellij.platform.vcs.impl"})
final class FailuresPanel
extends BorderLayoutPanel {
    private int nextFailureId;
    private final Map<Integer, CommitCheckFailure> failures;
    private final JBLabel iconLabel;
    private final JEditorPane description;

    public final void showDetails(@NotNull HyperlinkEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED) ^ true) {
            return;
        }
        String string = event.getDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.description");
        String string2 = string;
        boolean bl = false;
        CommitCheckFailure commitCheckFailure = this.failures.get(Integer.parseInt(string2));
        if (commitCheckFailure == null) {
            return;
        }
        CommitCheckFailure failure = commitCheckFailure;
        failure.getDetailsViewer().invoke();
    }

    public final void startProgress() {
        this.setVisible(false);
        this.iconLabel.setIcon((Icon)null);
        this.failures.clear();
        this.update();
    }

    public final void addFailure(@NotNull CommitCheckFailure failure) {
        Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
        this.setVisible(true);
        this.iconLabel.setIcon((Icon)new AnimatedIcon.Default());
        int n = this.nextFailureId;
        this.nextFailureId = n + 1;
        this.failures.put(n, failure);
        this.update();
    }

    public final void endProgress() {
        Map<Integer, CommitCheckFailure> map2 = this.failures;
        boolean bl = false;
        this.setVisible(!map2.isEmpty());
        if (this.isVisible()) {
            this.iconLabel.setIcon(AllIcons.General.Warning);
        }
    }

    private final void update() {
        SwingHelper.setHtml((JEditorPane)this.description, (String)this.buildDescription().toString(), null);
    }

    /*
     * WARNING - void declaration
     */
    private final HtmlChunk buildDescription() {
        void $this$mapTo$iv$iv;
        if (this.failures.isEmpty()) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"HtmlChunk.empty()");
            return htmlChunk;
        }
        Map<Integer, CommitCheckFailure> $this$map$iv = this.failures;
        boolean $i$f$map = false;
        Map<Integer, CommitCheckFailure> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var7_6 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_6.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            HtmlChunk.Element element = HtmlChunk.link((String)String.valueOf(((Number)it.getKey()).intValue()), (String)((CommitCheckFailure)it.getValue()).getText());
            collection.add(element);
        }
        String string = NlsMessages.formatNarrowAndList((Collection)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatNarrowAndList(fail\u2026ring(), it.value.text) })");
        String failuresLinks = string;
        HtmlChunk htmlChunk = HtmlChunk.raw((String)VcsBundle.message((String)"label.commit.checks.failed", (Object[])new Object[]{failuresLinks}));
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"HtmlChunk.raw(message(\"l\u2026.failed\", failuresLinks))");
        return htmlChunk;
    }

    public FailuresPanel() {
        boolean bl = false;
        this.failures = new LinkedHashMap();
        this.iconLabel = new JBLabel();
        JEditorPane jEditorPane = SwingHelper.createHtmlViewer((boolean)true, null, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)jEditorPane, (String)"createHtmlViewer(true, null, null, null)");
        this.description = jEditorPane;
        this.addToLeft((Component)this.iconLabel);
        this.addToCenter(this.description);
        this.description.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
        this.description.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public final void hyperlinkUpdate(HyperlinkEvent it) {
                HyperlinkEvent hyperlinkEvent = it;
                Intrinsics.checkNotNullExpressionValue((Object)hyperlinkEvent, (String)"it");
                this.showDetails(hyperlinkEvent);
            }
        });
        this.setOpaque(false);
        this.setVisible(false);
    }
}

