/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.StringKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/statistics/VcsUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroupId", "", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "getVersion", "", "intellij.platform.vcs.impl"})
public final class VcsUsagesCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "vcs.configuration";
    }

    public int getVersion() {
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Object metric;
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        HashSet<Object> set = new HashSet<Object>();
        ProjectLevelVcsManagerEx vcsManager2 = ProjectLevelVcsManagerEx.getInstanceEx(project);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
        ChangeListManager clm = changeListManager;
        String string = project.getBasePath();
        if (string != null) {
            String string2 = string;
            int n = 0;
            boolean bl = false;
            String it = string2;
            boolean bl2 = false;
            virtualFile = VcsUtil.getVirtualFile((String)it);
        } else {
            virtualFile = null;
        }
        VirtualFile projectBaseDir = virtualFile;
        ProjectLevelVcsManagerEx projectLevelVcsManagerEx = vcsManager2;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)projectLevelVcsManagerEx), (String)"vcsManager");
        for (AbstractVcs vcs : projectLevelVcsManagerEx.getAllActiveVcss()) {
            PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(vcs.getClass());
            metric = MetricEventFactoryKt.newMetric((String)"active.vcs");
            metric.getData().addPluginInfo(pluginInfo);
            FeatureUsageData featureUsageData = metric.getData();
            AbstractVcs abstractVcs = vcs;
            Intrinsics.checkNotNullExpressionValue((Object)abstractVcs, (String)"vcs");
            String string3 = abstractVcs.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"vcs.name");
            featureUsageData.addData("vcs", string3);
            set.add(metric);
        }
        Iterator iterator = vcsManager2.getDirectoryMappings().iterator();
        while (iterator.hasNext()) {
            PluginInfo pluginInfo;
            AbstractVcs vcs;
            VcsDirectoryMapping mapping;
            VcsDirectoryMapping vcsDirectoryMapping = mapping = (VcsDirectoryMapping)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)vcsDirectoryMapping, (String)"mapping");
            String vcsName = StringKt.nullize((String)vcsDirectoryMapping.getVcs(), (boolean)true);
            AbstractVcs abstractVcs = vcs = vcsManager2.findVcsByName(vcsName);
            if (abstractVcs != null) {
                metric = abstractVcs;
                boolean bl = false;
                boolean bl3 = false;
                Object it = metric;
                boolean bl4 = false;
                pluginInfo = PluginInfoDetectorKt.getPluginInfo(it.getClass());
            } else {
                pluginInfo = null;
            }
            PluginInfo pluginInfo2 = pluginInfo;
            metric = MetricEventFactoryKt.newMetric((String)"mapping");
            metric.getData().addPluginInfo(pluginInfo2);
            FeatureUsageData featureUsageData = metric.getData();
            String string4 = vcsName;
            if (string4 == null) {
                string4 = "None";
            }
            featureUsageData.addData("vcs", string4);
            metric.getData().addData("is_project_mapping", mapping.isDefaultMapping());
            if (!mapping.isDefaultMapping()) {
                metric.getData().addData("is_base_dir", projectBaseDir != null && Intrinsics.areEqual((Object)projectBaseDir, (Object)VcsUtil.getVirtualFile((String)mapping.getDirectory())));
            }
            set.add(metric);
        }
        AbstractVcs defaultVcs = vcsManager2.findVcsByName(vcsManager2.haveDefaultMapping());
        if (defaultVcs != null) {
            Object $this$filterTo$iv$iv;
            int n;
            void $this$mapTo$iv$iv;
            VcsDirectoryMapping it;
            Iterable $this$filterTo$iv$iv2;
            PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(defaultVcs.getClass());
            List list = vcsManager2.getDirectoryMappings();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"vcsManager.directoryMappings");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            metric = $this$filter$iv;
            VcsRoot[] destination$iv$iv = (VcsRoot[])new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (VcsDirectoryMapping)element$iv$iv;
                boolean bl = false;
                VcsDirectoryMapping vcsDirectoryMapping = it;
                Intrinsics.checkNotNullExpressionValue((Object)vcsDirectoryMapping, (String)"it");
                if (!Intrinsics.areEqual((Object)vcsDirectoryMapping.getVcs(), (Object)defaultVcs.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (VcsDirectoryMapping)element$iv$iv;
                boolean bl = false;
                VcsDirectoryMapping vcsDirectoryMapping = it;
                Intrinsics.checkNotNullExpressionValue((Object)vcsDirectoryMapping, (String)"it");
                String string5 = vcsDirectoryMapping.getDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it.directory");
                CharSequence charSequence = string5;
                boolean bl5 = false;
                if (!(charSequence.length() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (VcsDirectoryMapping)item$iv$iv;
                VcsRoot[] vcsRootArray = destination$iv$iv;
                n = 0;
                VcsDirectoryMapping vcsDirectoryMapping = it;
                Intrinsics.checkNotNullExpressionValue((Object)vcsDirectoryMapping, (String)"it");
                VirtualFile virtualFile2 = VcsUtil.getVirtualFile((String)vcsDirectoryMapping.getDirectory());
                vcsRootArray.add(virtualFile2);
            }
            Set explicitRoots = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            VcsRoot[] vcsRootArray = vcsManager2.getAllVcsRoots();
            Intrinsics.checkNotNullExpressionValue((Object)vcsRootArray, (String)"vcsManager.allVcsRoots");
            Object $this$filter$iv2 = vcsRootArray;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            Iterator iterator2 = $this$filterTo$iv$iv;
            int it2 = ((void)iterator2).length;
            for (n = 0; n < it2; ++n) {
                void element$iv$iv;
                void it3 = element$iv$iv = iterator2[n];
                boolean bl = false;
                void v18 = it3;
                Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"it");
                if (!Intrinsics.areEqual((Object)v18.getVcs(), (Object)defaultVcs)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            $i$f$filter2 = false;
            $this$filterTo$iv$iv = $this$filter$iv2;
            destination$iv$iv2 = new ArrayList();
            $i$f$filterTo2 = false;
            iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                VcsRoot it4 = (VcsRoot)element$iv$iv;
                boolean bl = false;
                VcsRoot vcsRoot = it4;
                Intrinsics.checkNotNullExpressionValue((Object)vcsRoot, (String)"it");
                if (!(!explicitRoots.contains(vcsRoot.getPath()))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List projectMappedRoots = (List)destination$iv$iv2;
            for (VcsRoot vcsRoot : projectMappedRoots) {
                MetricEvent metric2 = MetricEventFactoryKt.newMetric((String)"project.mapped.root");
                metric2.getData().addPluginInfo(pluginInfo);
                FeatureUsageData featureUsageData = metric2.getData();
                String string6 = defaultVcs.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"defaultVcs.name");
                featureUsageData.addData("vcs", string6);
                FeatureUsageData featureUsageData2 = metric2.getData();
                VcsRoot vcsRoot2 = vcsRoot;
                Intrinsics.checkNotNullExpressionValue((Object)vcsRoot2, (String)"vcsRoot");
                featureUsageData2.addData("is_base_dir", Intrinsics.areEqual((Object)vcsRoot2.getPath(), (Object)projectBaseDir));
                set.add(metric2);
            }
        }
        set.add(MetricEventFactoryKt.newCounterMetric((String)"mapped.roots", (int)vcsManager2.getAllVcsRoots().length));
        set.add(MetricEventFactoryKt.newCounterMetric((String)"changelists", (int)clm.getChangeListsNumber()));
        set.add(MetricEventFactoryKt.newCounterMetric((String)"unversioned.files", (int)clm.getUnversionedFilesPaths().size()));
        set.add(MetricEventFactoryKt.newCounterMetric((String)"ignored.files", (int)clm.getIgnoredFilePaths().size()));
        return set;
    }
}

