/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsRootError;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.roots.VcsRootErrorsFinder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsRootProblemNotifier {
    private static final Logger LOG = Logger.getInstance(VcsRootProblemNotifier.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsConfiguration mySettings;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final ProjectFileIndex myProjectFileIndex;
    @NotNull
    private final Set<String> myReportedUnregisteredRoots;
    @Nullable
    private Notification myNotification;
    @NotNull
    private final Object NOTIFICATION_LOCK;
    @NotNull
    private final Function<VcsRootError, String> ROOT_TO_PRESENTABLE;

    public static VcsRootProblemNotifier createInstance(@NotNull Project project) {
        if (project == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(0);
        }
        return new VcsRootProblemNotifier(project);
    }

    private VcsRootProblemNotifier(@NotNull Project project) {
        if (project == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(1);
        }
        this.NOTIFICATION_LOCK = new Object();
        this.ROOT_TO_PRESENTABLE = rootError -> this.getPresentableMapping(rootError.getMapping());
        this.myProject = project;
        this.mySettings = VcsConfiguration.getInstance((Project)this.myProject);
        this.myChangeListManager = ChangeListManager.getInstance((Project)project);
        this.myProjectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myReportedUnregisteredRoots = new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescanAndNotifyIfNeeded() {
        NotificationAction[] notificationActions;
        String description;
        String title2;
        Collection<VcsRootError> errors = this.scan();
        if (errors.isEmpty()) {
            Object object = this.NOTIFICATION_LOCK;
            synchronized (object) {
                this.expireNotification();
            }
            return;
        }
        LOG.debug("Following errors detected: " + errors);
        List<VcsRootError> importantUnregisteredRoots = this.getImportantUnregisteredMappings(errors);
        Collection<VcsRootError> invalidRoots = VcsRootProblemNotifier.getInvalidRoots(errors);
        if (Registry.is((String)"vcs.root.auto.add") && !this.areThereExplicitlyIgnoredRoots(errors)) {
            VcsRootError rootError2;
            if (invalidRoots.isEmpty() && importantUnregisteredRoots.isEmpty()) {
                return;
            }
            LOG.info("Auto-registered following mappings: " + importantUnregisteredRoots);
            this.addMappings(importantUnregisteredRoots);
            if (invalidRoots.isEmpty() && importantUnregisteredRoots.size() == 1 && FileUtil.pathsEqual((String)(rootError2 = Objects.requireNonNull((VcsRootError)ContainerUtil.getFirstItem(importantUnregisteredRoots))).getMapping().getDirectory(), (String)this.myProject.getBasePath())) {
                return;
            }
            if (invalidRoots.isEmpty() && !Registry.is((String)"vcs.root.auto.add.nofity")) {
                return;
            }
            title2 = VcsRootProblemNotifier.makeTitle(importantUnregisteredRoots, invalidRoots, true);
            description = this.makeDescription(importantUnregisteredRoots, invalidRoots);
            notificationActions = new NotificationAction[]{this.getConfigureNotificationAction()};
        } else {
            List unregRootPaths = ContainerUtil.map(importantUnregisteredRoots, rootError -> rootError.getMapping().getDirectory());
            if (invalidRoots.isEmpty() && (importantUnregisteredRoots.isEmpty() || this.myReportedUnregisteredRoots.containsAll(unregRootPaths))) {
                return;
            }
            this.myReportedUnregisteredRoots.addAll(unregRootPaths);
            title2 = VcsRootProblemNotifier.makeTitle(importantUnregisteredRoots, invalidRoots, false);
            description = this.makeDescription(importantUnregisteredRoots, invalidRoots);
            NotificationAction enableIntegration = NotificationAction.create((Supplier)VcsBundle.messagePointer((String)"action.NotificationAction.VcsRootProblemNotifier.text.enable.integration", (Object[])new Object[0]), (event, notification) -> this.addMappings(importantUnregisteredRoots));
            NotificationAction ignoreAction = NotificationAction.create((Supplier)VcsBundle.messagePointer((String)"action.NotificationAction.VcsRootProblemNotifier.text.ignore", (Object[])new Object[0]), (event, notification) -> {
                this.mySettings.addIgnoredUnregisteredRoots((Collection)ContainerUtil.map((Collection)importantUnregisteredRoots, rootError -> rootError.getMapping().getDirectory()));
                notification.expire();
            });
            notificationActions = new NotificationAction[]{enableIntegration, this.getConfigureNotificationAction(), ignoreAction};
        }
        Object object = this.NOTIFICATION_LOCK;
        synchronized (object) {
            this.expireNotification();
            VcsNotifier notifier = VcsNotifier.getInstance(this.myProject);
            this.myNotification = invalidRoots.isEmpty() ? notifier.notifyMinorInfo("vcs.roots.registered", title2, description, notificationActions) : notifier.notifyError("vcs.roots.invalid", title2, description, this.getConfigureNotificationAction());
        }
    }

    @NotNull
    private NotificationAction getConfigureNotificationAction() {
        NotificationAction notificationAction = NotificationAction.create((Supplier)VcsBundle.messagePointer((String)"action.NotificationAction.VcsRootProblemNotifier.text.configure", (Object[])new Object[0]), (event, notification) -> {
            if (!this.myProject.isDisposed()) {
                ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, ActionsBundle.message((String)"group.VcsGroup.text", (Object[])new Object[0]));
                BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myProject, () -> {
                    Collection<VcsRootError> errorsAfterPossibleFix = new VcsRootProblemNotifier(this.myProject).scan();
                    if (errorsAfterPossibleFix.isEmpty() && !notification.isExpired()) {
                        notification.expire();
                    }
                });
            }
        });
        if (notificationAction == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(2);
        }
        return notificationAction;
    }

    private void addMappings(Collection<? extends VcsRootError> importantUnregisteredRoots) {
        List mappings = this.myVcsManager.getDirectoryMappings();
        for (VcsRootError vcsRootError : importantUnregisteredRoots) {
            mappings = VcsUtil.addMapping((List)mappings, (VcsDirectoryMapping)vcsRootError.getMapping());
        }
        this.myVcsManager.setDirectoryMappings(mappings);
    }

    private boolean isUnderOrAboveProjectDir(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(3);
        }
        String projectDir = Objects.requireNonNull(this.myProject.getBasePath());
        return mapping.isDefaultMapping() || FileUtil.isAncestor((String)projectDir, (String)mapping.getDirectory(), (boolean)false) || FileUtil.isAncestor((String)mapping.getDirectory(), (String)projectDir, (boolean)false);
    }

    private boolean isIgnoredOrExcludedPath(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(4);
        }
        if (mapping.isDefaultMapping()) {
            return false;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(mapping.getDirectory());
        return file != null && (this.myChangeListManager.isIgnoredFile(file) || (Boolean)ReadAction.compute(() -> this.myProjectFileIndex.isExcluded(file)) != false);
    }

    private boolean isExplicitlyIgnoredPath(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(5);
        }
        if (mapping.isDefaultMapping()) {
            return false;
        }
        return this.mySettings.isIgnoredUnregisteredRoot(mapping.getDirectory());
    }

    private void expireNotification() {
        if (this.myNotification != null) {
            Notification notification = this.myNotification;
            ApplicationManager.getApplication().invokeLater(() -> ((Notification)notification).expire());
            this.myNotification = null;
        }
    }

    @NotNull
    private Collection<VcsRootError> scan() {
        Collection<VcsRootError> collection = new VcsRootErrorsFinder(this.myProject).find();
        if (collection == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    @NlsContexts.NotificationContent
    private String makeDescription(@NotNull Collection<? extends VcsRootError> unregisteredRoots, @NotNull Collection<? extends VcsRootError> invalidRoots) {
        if (unregisteredRoots == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(7);
        }
        if (invalidRoots == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(8);
        }
        @Nls StringBuilder description = new StringBuilder();
        if (!invalidRoots.isEmpty()) {
            if (invalidRoots.size() == 1) {
                VcsRootError rootError = invalidRoots.iterator().next();
                String vcsName = rootError.getMapping().getVcs();
                description.append(this.getInvalidRootDescriptionItem(rootError, vcsName));
            } else {
                description.append(VcsBundle.message((String)"roots.the.following.directories.are.registered.as.vcs.roots.but.they.are.not", (Object[])new Object[0])).append("<br/>").append(this.joinRootsForPresentation(invalidRoots));
            }
            description.append("<br/>");
        }
        if (!unregisteredRoots.isEmpty()) {
            if (unregisteredRoots.size() == 1) {
                VcsRootError unregisteredRoot = unregisteredRoots.iterator().next();
                description.append((String)this.ROOT_TO_PRESENTABLE.fun((Object)unregisteredRoot));
            } else {
                description.append(this.joinRootsForPresentation(unregisteredRoots));
            }
        }
        String string = description.toString();
        if (string == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(9);
        }
        return string;
    }

    @VisibleForTesting
    @NlsContexts.NotificationContent
    @NotNull
    String getInvalidRootDescriptionItem(@NotNull VcsRootError rootError, @NotNull String vcsName) {
        if (rootError == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(10);
        }
        if (vcsName == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(11);
        }
        String string = VcsBundle.message((String)"roots.notification.content.directory.registered.as.root.but.no.repositories.were.found.there", (Object[])new Object[]{this.ROOT_TO_PRESENTABLE.fun((Object)rootError), vcsName});
        if (string == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private String joinRootsForPresentation(@NotNull Collection<? extends VcsRootError> errors) {
        if (errors == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(13);
        }
        List sortedRoots = ContainerUtil.sorted(errors, (root1, root2) -> {
            if (root1.getMapping().isDefaultMapping()) {
                return -1;
            }
            if (root2.getMapping().isDefaultMapping()) {
                return 1;
            }
            return root1.getMapping().getDirectory().compareTo(root2.getMapping().getDirectory());
        });
        String string = StringUtil.join((Collection)sortedRoots, this.ROOT_TO_PRESENTABLE, (String)"<br/>");
        if (string == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    @NlsContexts.NotificationTitle
    private static String makeTitle(@NotNull Collection<? extends VcsRootError> unregisteredRoots, @NotNull Collection<? extends VcsRootError> invalidRoots, boolean rootsAlreadyAdded) {
        String title2;
        if (unregisteredRoots == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(15);
        }
        if (invalidRoots == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(16);
        }
        if (unregisteredRoots.isEmpty()) {
            title2 = VcsBundle.message((String)"roots.notification.title.invalid.vcs.root.choice.mapping.mappings", (Object[])new Object[]{invalidRoots.size()});
        } else if (invalidRoots.isEmpty()) {
            String vcs = VcsRootProblemNotifier.getVcsName(unregisteredRoots);
            title2 = rootsAlreadyAdded ? VcsBundle.message((String)"roots.notification.title.vcs.name.integration.enabled", (Object[])new Object[]{vcs}) : VcsBundle.message((String)"notification.title.vcs.name.repository.repositories.found", (Object[])new Object[]{vcs, unregisteredRoots.size()});
        } else {
            title2 = VcsBundle.message((String)"roots.notification.title.vcs.root.configuration.problems", (Object[])new Object[0]);
        }
        String string = title2;
        if (string == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static String getVcsName(Collection<? extends VcsRootError> roots) {
        String result2 = null;
        for (VcsRootError vcsRootError : roots) {
            String vcsName = vcsRootError.getMapping().getVcs();
            if (result2 == null) {
                result2 = vcsName;
                continue;
            }
            if (result2.equals(vcsName)) continue;
            return VcsBundle.message((String)"vcs.generic.name", (Object[])new Object[0]);
        }
        return result2;
    }

    @NotNull
    private List<VcsRootError> getImportantUnregisteredMappings(@NotNull Collection<? extends VcsRootError> errors) {
        if (errors == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(18);
        }
        List list = ContainerUtil.filter(errors, error -> {
            VcsDirectoryMapping mapping = error.getMapping();
            return error.getType() == VcsRootError.Type.UNREGISTERED_ROOT && this.isUnderOrAboveProjectDir(mapping) && !this.isIgnoredOrExcludedPath(mapping) && !this.isExplicitlyIgnoredPath(mapping);
        });
        if (list == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(19);
        }
        return list;
    }

    private boolean areThereExplicitlyIgnoredRoots(Collection<? extends VcsRootError> allErrors) {
        return ContainerUtil.exists(allErrors, it -> it.getType() == VcsRootError.Type.UNREGISTERED_ROOT && this.isExplicitlyIgnoredPath(it.getMapping()));
    }

    @NotNull
    private static Collection<VcsRootError> getInvalidRoots(@NotNull Collection<? extends VcsRootError> errors) {
        if (errors == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(20);
        }
        List list = ContainerUtil.filter(errors, error -> error.getType() == VcsRootError.Type.EXTRA_MAPPING);
        if (list == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(21);
        }
        return list;
    }

    @VisibleForTesting
    @NotNull
    String getPresentableMapping(@NotNull VcsDirectoryMapping directoryMapping) {
        if (directoryMapping == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(22);
        }
        if (directoryMapping.isDefaultMapping()) {
            String string = directoryMapping.toString();
            if (string == null) {
                VcsRootProblemNotifier.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = this.getPresentableMapping(directoryMapping.getDirectory());
        if (string == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(24);
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    String getPresentableMapping(@NotNull String mapping) {
        String relativePath;
        if (mapping == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(25);
        }
        String presentablePath = null;
        String projectDir = this.myProject.getBasePath();
        if (projectDir != null && FileUtil.isAncestor((String)projectDir, (String)mapping, (boolean)true) && (relativePath = FileUtil.getRelativePath((String)projectDir, (String)mapping, (char)'/')) != null) {
            presentablePath = FileUtil.toSystemDependentName((String)VcsBundle.message((String)"label.relative.project.path.presentation", (Object[])new Object[]{relativePath}));
        }
        if (presentablePath == null) {
            presentablePath = FileUtil.getLocationRelativeToUserHome((String)FileUtil.toSystemDependentName((String)mapping));
        }
        String string = StringUtil.escapeXmlEntities(presentablePath);
        if (string == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unregisteredRoots";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidRoots";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootError";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsName";
                break;
            }
            case 13: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigureNotificationAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "scan";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "makeDescription";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidRootDescriptionItem";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "joinRootsForPresentation";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "makeTitle";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportantUnregisteredMappings";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidRoots";
                break;
            }
            case 23: 
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnderOrAboveProjectDir";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredOrExcludedPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isExplicitlyIgnoredPath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "makeDescription";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidRootDescriptionItem";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "joinRootsForPresentation";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "makeTitle";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getImportantUnregisteredMappings";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidRoots";
                break;
            }
            case 22: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

