/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.codeInsight.CodeSmellInfo;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkin.CodeAnalysisBeforeCheckinHandlerKt;
import com.intellij.openapi.vcs.checkin.CodeAnalysisBeforeCheckinShowOnlyNew;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0001B\u001b\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0002\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\f\u001a\u00020\rH\u0014J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/checkin/FindNewCodeSmellsTask;", "Lcom/intellij/openapi/progress/Task$WithResult;", "", "Lcom/intellij/codeInsight/CodeSmellInfo;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "project", "Lcom/intellij/openapi/project/Project;", "files", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "compute", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "find", "intellij.platform.vcs.impl"})
final class FindNewCodeSmellsTask
extends Task.WithResult<List<? extends CodeSmellInfo>, Exception> {
    private final List<VirtualFile> files;

    @NotNull
    public final List<CodeSmellInfo> find() {
        List list;
        this.queue();
        try {
            List list2 = (List)this.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"result");
            list = list2;
        }
        catch (ProcessCanceledException e) {
            CodeAnalysisBeforeCheckinHandlerKt.access$getLOG$p().info("Code analysis canceled", (Throwable)e);
            throw (Throwable)e;
        }
        catch (Exception e) {
            CodeAnalysisBeforeCheckinHandlerKt.access$getLOG$p().error((Throwable)e);
            ExceptionUtil.rethrowUnchecked((Throwable)e);
            throw (Throwable)new RuntimeException(e);
        }
        return list;
    }

    @NotNull
    protected List<CodeSmellInfo> compute(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.setIndeterminate(true);
        Project project = this.myProject;
        Intrinsics.checkNotNull((Object)project);
        List<CodeSmellInfo> codeSmells2 = CodeAnalysisBeforeCheckinShowOnlyNew.runAnalysis(project, this.files, indicator);
        indicator.setText(VcsBundle.message((String)"before.checkin.waiting.for.smart.mode", (Object[])new Object[0]));
        DumbService.getInstance((Project)this.myProject).waitForSmartMode();
        return codeSmells2;
    }

    public FindNewCodeSmellsTask(@NotNull Project project, @NotNull List<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        super(project, VcsBundle.message((String)"checking.code.smells.progress.title", (Object[])new Object[0]), true);
        this.files = files;
    }
}

