/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesViewRefresher;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.VcsActionUsagesCollectorKt;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RefreshAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            RefreshAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        RefreshAction.doRefresh(project);
    }

    public static void doRefresh(Project project) {
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        RefreshAction.invokeCustomRefreshes(project);
        VirtualFileManager.getInstance().asyncRefresh(() -> {
            if (!project.isDisposed()) {
                RefreshAction.performRefreshAndTrackChanges(project);
            }
        });
    }

    private static void invokeCustomRefreshes(@NotNull Project project) {
        ChangesViewRefresher[] extensions;
        if (project == null) {
            RefreshAction.$$$reportNull$$$0(1);
        }
        for (ChangesViewRefresher refresher : extensions = (ChangesViewRefresher[])ChangesViewRefresher.EP_NAME.getExtensions((AreaInstance)project)) {
            refresher.refresh(project);
        }
    }

    private static void performRefreshAndTrackChanges(Project project) {
        ChangeListManagerEx changeListManager = ChangeListManagerEx.getInstanceEx(project);
        Collection changesBeforeUpdate = changeListManager.getAllChanges();
        List unversionedBefore = changeListManager.getUnversionedFilesPaths();
        boolean wasUpdatingBefore = changeListManager.isInUpdate();
        VcsDirtyScopeManager.getInstance((Project)project).markEverythingDirty();
        changeListManager.invokeAfterUpdate(() -> {
            Collection changesAfterUpdate = changeListManager.getAllChanges();
            List unversionedAfter = changeListManager.getUnversionedFilesPaths();
            VcsActionUsagesCollectorKt.logRefreshActionPerformed(changesBeforeUpdate, changesAfterUpdate, unversionedBefore, unversionedAfter, wasUpdatingBefore);
        }, InvokeAfterUpdateMode.SILENT, VcsBundle.message((String)"changes.progress.title.refresh.action", (Object[])new Object[0]), ModalityState.current());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/RefreshAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeCustomRefreshes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

