/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.maven.polyglot;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.impldep.org.apache.maven.model.Model;
import org.gradle.internal.impldep.org.apache.maven.model.io.ModelParseException;
import org.gradle.internal.impldep.org.apache.maven.model.io.ModelReader;
import org.gradle.internal.impldep.org.apache.maven.model.io.ModelWriter;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Component;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Requirement;
import org.gradle.internal.impldep.org.codehaus.plexus.logging.Logger;
import org.gradle.internal.impldep.org.sonatype.maven.polyglot.PolyglotModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=PolyglotModelTranslator.class)
public class PolyglotModelTranslator {
    @Requirement
    protected Logger log;
    @Requirement
    private PolyglotModelManager manager;

    public void translate(File input, File output) throws IOException, ModelParseException {
        assert (input != null);
        assert (output != null);
        HashMap<String, String> inputOptions = new HashMap<String, String>();
        inputOptions.put("org.gradle.internal.impldep.org.apache.maven.model.building.location", input.getPath());
        HashMap<String, String> outputOptions = new HashMap<String, String>();
        outputOptions.put("org.gradle.internal.impldep.org.apache.maven.model.building.location", output.getPath());
        this.translate(input, inputOptions, output, outputOptions);
    }

    public void translate(File input, Map<String, ?> inputOptions, File output, Map<String, ?> outputOptions) throws IOException, ModelParseException {
        assert (input != null);
        assert (output != null);
        ModelReader reader = this.manager.getReaderFor(inputOptions);
        Model model = reader.read(input, inputOptions);
        ModelWriter writer = this.manager.getWriterFor(outputOptions);
        writer.write(output, outputOptions, model);
    }

    public void translate(URL input, URL output) throws IOException, ModelParseException {
        assert (input != null);
        assert (output != null);
        HashMap<String, String> inputOptions = new HashMap<String, String>();
        inputOptions.put("org.gradle.internal.impldep.org.apache.maven.model.building.location", input.toExternalForm());
        HashMap<String, String> outputOptions = new HashMap<String, String>();
        outputOptions.put("org.gradle.internal.impldep.org.apache.maven.model.building.location", output.toExternalForm());
        this.translate(input, inputOptions, output, outputOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translate(URL input, Map<String, ?> inputOptions, URL output, Map<String, ?> outputOptions) throws IOException, ModelParseException {
        OutputStream out;
        assert (input != null);
        assert (output != null);
        if (output.getProtocol().equals("file")) {
            File file = new File(output.getPath());
            out = new BufferedOutputStream(new FileOutputStream(file));
        } else {
            out = output.openConnection().getOutputStream();
        }
        try {
            this.translate(input.openStream(), inputOptions, out, outputOptions);
        }
        finally {
            out.flush();
        }
    }

    public void translate(InputStream input, Map<String, ?> inputOptions, OutputStream output, Map<String, ?> outputOptions) throws IOException, ModelParseException {
        assert (input != null);
        assert (output != null);
        ModelReader reader = this.manager.getReaderFor(inputOptions);
        Model model = reader.read(input, inputOptions);
        ModelWriter writer = this.manager.getWriterFor(outputOptions);
        writer.write(output, outputOptions, model);
    }

    public void translate(Reader input, Map<String, ?> inputOptions, Writer output, Map<String, ?> outputOptions) throws IOException, ModelParseException {
        assert (input != null);
        assert (output != null);
        ModelReader reader = this.manager.getReaderFor(inputOptions);
        Model model = reader.read(input, inputOptions);
        ModelWriter writer = this.manager.getWriterFor(outputOptions);
        writer.write(output, outputOptions, model);
    }
}

