/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.aether.collection;

import org.gradle.internal.impldep.org.sonatype.aether.RepositoryException;
import org.gradle.internal.impldep.org.sonatype.aether.collection.CollectRequest;
import org.gradle.internal.impldep.org.sonatype.aether.collection.CollectResult;

public class DependencyCollectionException
extends RepositoryException {
    private final CollectResult result;

    public DependencyCollectionException(CollectResult result) {
        super("Failed to collect dependencies for " + DependencyCollectionException.getSource(result), DependencyCollectionException.getCause(result));
        this.result = result;
    }

    public CollectResult getResult() {
        return this.result;
    }

    private static String getSource(CollectResult result) {
        if (result == null) {
            return "";
        }
        CollectRequest request = result.getRequest();
        if (request.getRoot() != null) {
            return request.getRoot().toString();
        }
        return request.getDependencies().toString();
    }

    private static Throwable getCause(CollectResult result) {
        Throwable cause = null;
        if (result != null && !result.getExceptions().isEmpty()) {
            cause = result.getExceptions().get(0);
        }
        return cause;
    }
}

