/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce;

import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.io.OutputStreamFactory;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKey;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PGPContentVerifier;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcaPGPContentVerifierBuilderProvider
implements PGPContentVerifierBuilderProvider {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JcaPGPContentVerifierBuilderProvider setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        return this;
    }

    public JcaPGPContentVerifierBuilderProvider setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        return this;
    }

    public PGPContentVerifierBuilder get(int n, int n2) throws PGPException {
        return new JcaPGPContentVerifierBuilder(n, n2);
    }

    private class JcaPGPContentVerifierBuilder
    implements PGPContentVerifierBuilder {
        private int hashAlgorithm;
        private int keyAlgorithm;

        public JcaPGPContentVerifierBuilder(int n, int n2) {
            this.keyAlgorithm = n;
            this.hashAlgorithm = n2;
        }

        public PGPContentVerifier build(final PGPPublicKey pGPPublicKey) throws PGPException {
            final Signature signature = JcaPGPContentVerifierBuilderProvider.this.helper.createSignature(this.keyAlgorithm, this.hashAlgorithm);
            try {
                signature.initVerify(JcaPGPContentVerifierBuilderProvider.this.keyConverter.getPublicKey(pGPPublicKey));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new PGPException("invalid key.", invalidKeyException);
            }
            return new PGPContentVerifier(){

                public int getHashAlgorithm() {
                    return JcaPGPContentVerifierBuilder.this.hashAlgorithm;
                }

                public int getKeyAlgorithm() {
                    return JcaPGPContentVerifierBuilder.this.keyAlgorithm;
                }

                public long getKeyID() {
                    return pGPPublicKey.getKeyID();
                }

                public boolean verify(byte[] byArray) {
                    try {
                        return signature.verify(byArray);
                    }
                    catch (SignatureException signatureException) {
                        throw new PGPRuntimeOperationException("unable to verify signature: " + signatureException.getMessage(), signatureException);
                    }
                }

                public OutputStream getOutputStream() {
                    return OutputStreamFactory.createStream(signature);
                }
            };
        }
    }
}

