/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.model.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.impldep.org.apache.maven.lifecycle.LifeCyclePluginAnalyzer;
import org.gradle.internal.impldep.org.apache.maven.model.Build;
import org.gradle.internal.impldep.org.apache.maven.model.Model;
import org.gradle.internal.impldep.org.apache.maven.model.Plugin;
import org.gradle.internal.impldep.org.apache.maven.model.PluginContainer;
import org.gradle.internal.impldep.org.apache.maven.model.PluginExecution;
import org.gradle.internal.impldep.org.apache.maven.model.PluginManagement;
import org.gradle.internal.impldep.org.apache.maven.model.building.ModelBuildingRequest;
import org.gradle.internal.impldep.org.apache.maven.model.building.ModelProblem;
import org.gradle.internal.impldep.org.apache.maven.model.building.ModelProblemCollector;
import org.gradle.internal.impldep.org.apache.maven.model.merge.MavenModelMerger;
import org.gradle.internal.impldep.org.apache.maven.model.plugin.LifecycleBindingsInjector;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Component;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Requirement;

@Component(role=LifecycleBindingsInjector.class)
public class DefaultLifecycleBindingsInjector
implements LifecycleBindingsInjector {
    private LifecycleBindingsMerger merger = new LifecycleBindingsMerger();
    @Requirement
    private LifeCyclePluginAnalyzer lifecycle;

    public void injectLifecycleBindings(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        String packaging = model.getPackaging();
        Set<Plugin> defaultPlugins = this.lifecycle.getPluginsBoundByDefaultToAllLifecycles(packaging);
        if (defaultPlugins == null) {
            problems.add(ModelProblem.Severity.ERROR, "Unknown packaging: " + packaging, model.getLocation("packaging"), null);
        } else if (!defaultPlugins.isEmpty()) {
            Model lifecycleModel = new Model();
            lifecycleModel.setBuild(new Build());
            lifecycleModel.getBuild().getPlugins().addAll(defaultPlugins);
            this.merger.merge(model, lifecycleModel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LifecycleBindingsMerger
    extends MavenModelMerger {
        private static final String PLUGIN_MANAGEMENT = "plugin-management";

        private LifecycleBindingsMerger() {
        }

        public void merge(Model target, Model source) {
            if (target.getBuild() == null) {
                target.setBuild(new Build());
            }
            Map<Object, Object> context = Collections.singletonMap(PLUGIN_MANAGEMENT, target.getBuild().getPluginManagement());
            this.mergePluginContainer_Plugins(target.getBuild(), source.getBuild(), false, context);
        }

        @Override
        protected void mergePluginContainer_Plugins(PluginContainer target, PluginContainer source, boolean sourceDominant, Map<Object, Object> context) {
            List<Plugin> src = source.getPlugins();
            if (!src.isEmpty()) {
                PluginManagement pluginMgmt;
                List<Plugin> tgt = target.getPlugins();
                LinkedHashMap<Object, Plugin> merged = new LinkedHashMap<Object, Plugin>((src.size() + tgt.size()) * 2);
                for (Plugin element : tgt) {
                    Object key = this.getPluginKey(element);
                    merged.put(key, element);
                }
                LinkedHashMap<Object, Plugin> unmanaged = new LinkedHashMap<Object, Plugin>();
                for (Plugin element : src) {
                    Object key = this.getPluginKey(element);
                    Plugin existing = (Plugin)merged.get(key);
                    if (existing != null) {
                        this.mergePlugin(existing, element, sourceDominant, context);
                        continue;
                    }
                    merged.put(key, element);
                    unmanaged.put(key, element);
                }
                if (!unmanaged.isEmpty() && (pluginMgmt = (PluginManagement)context.get(PLUGIN_MANAGEMENT)) != null) {
                    for (Plugin managedPlugin : pluginMgmt.getPlugins()) {
                        Object key = this.getPluginKey(managedPlugin);
                        Plugin unmanagedPlugin = (Plugin)unmanaged.get(key);
                        if (unmanagedPlugin == null) continue;
                        Plugin plugin = managedPlugin.clone();
                        this.mergePlugin(plugin, unmanagedPlugin, sourceDominant, Collections.<Object, Object>emptyMap());
                        merged.put(key, plugin);
                    }
                }
                ArrayList<Plugin> result = new ArrayList<Plugin>(merged.values());
                target.setPlugins(result);
            }
        }

        @Override
        protected void mergePluginExecution(PluginExecution target, PluginExecution source, boolean sourceDominant, Map<Object, Object> context) {
            super.mergePluginExecution(target, source, sourceDominant, context);
            target.setPriority(Math.min(target.getPriority(), source.getPriority()));
        }
    }
}

