/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.speller.lists;

import com.intellij.grazie.speller.utils.Distances;
import com.intellij.grazie.speller.utils.UtilsKt;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\bf\u0018\u0000 \r2\u00020\u0001:\u0004\f\r\u000e\u000fJ\u0011\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u00a6\u0002J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\u0007\u001a\u00020\u0005H&J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\u0010"}, d2={"Lcom/intellij/grazie/speller/lists/WordList;", "", "contains", "", "word", "", "isAlien", "prefix", "Lkotlin/sequences/Sequence;", "suggest", "distance", "", "Aggregated", "Companion", "Default", "Empty", "spellchecker"})
public interface WordList {
    public static final Companion Companion = com.intellij.grazie.speller.lists.WordList$Companion.$$INSTANCE;

    public boolean contains(@NotNull String var1);

    public boolean isAlien(@NotNull String var1);

    @NotNull
    public Sequence<String> suggest(@NotNull String var1, int var2);

    @NotNull
    public Sequence<String> prefix(@NotNull String var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/grazie/speller/lists/WordList$Aggregated;", "Lcom/intellij/grazie/speller/lists/WordList;", "lists", "", "([Lcom/intellij/grazie/speller/lists/WordList;)V", "", "(Ljava/util/Set;)V", "getLists", "()Ljava/util/Set;", "contains", "", "word", "", "isAlien", "prefix", "Lkotlin/sequences/Sequence;", "suggest", "distance", "", "spellchecker"})
    public static class Aggregated
    implements WordList {
        @NotNull
        private final Set<WordList> lists;

        @NotNull
        protected final Set<WordList> getLists() {
            return this.lists;
        }

        @Override
        @NotNull
        public Sequence<String> suggest(@NotNull String word, int distance) {
            Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
            return SequencesKt.flatMap((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)this.lists), (Function1)((Function1)new Function1<WordList, Boolean>(word){
                final /* synthetic */ String $word;

                public final boolean invoke(@NotNull WordList it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return it.isAlien(this.$word);
                }
                {
                    this.$word = string;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<WordList, Sequence<? extends String>>(word, distance){
                final /* synthetic */ String $word;
                final /* synthetic */ int $distance;

                @NotNull
                public final Sequence<String> invoke(@NotNull WordList it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return it.suggest(this.$word, this.$distance);
                }
                {
                    this.$word = string;
                    this.$distance = n;
                    super(1);
                }
            }));
        }

        @Override
        @NotNull
        public Sequence<String> prefix(@NotNull String prefix2) {
            Intrinsics.checkParameterIsNotNull((Object)prefix2, (String)"prefix");
            return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.lists), (Function1)((Function1)new Function1<WordList, Sequence<? extends String>>(prefix2){
                final /* synthetic */ String $prefix;

                @NotNull
                public final Sequence<String> invoke(@NotNull WordList it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return it.prefix(this.$prefix);
                }
                {
                    this.$prefix = string;
                    super(1);
                }
            }));
        }

        @Override
        public boolean contains(@NotNull String word) {
            boolean bl;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
                Iterable $this$any$iv = this.lists;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        WordList it = (WordList)element$iv;
                        boolean bl2 = false;
                        if (!it.contains(word)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public boolean isAlien(@NotNull String word) {
            boolean bl;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
                Iterable $this$all$iv = this.lists;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        WordList it = (WordList)element$iv;
                        boolean bl2 = false;
                        if (it.isAlien(word)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public Aggregated(@NotNull Set<? extends WordList> lists) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkParameterIsNotNull(lists, (String)"lists");
            Iterable iterable = lists;
            Aggregated aggregated = this;
            boolean $i$f$filter = false;
            void var4_5 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                WordList it = (WordList)element$iv$iv;
                boolean bl = false;
                if (!(!(it instanceof Empty))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            aggregated.lists = CollectionsKt.toSet((Iterable)list);
        }

        public Aggregated(WordList ... lists) {
            Intrinsics.checkParameterIsNotNull((Object)lists, (String)"lists");
            this(ArraysKt.toSet((Object[])lists));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0096\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/grazie/speller/lists/WordList$Default;", "Lcom/intellij/grazie/speller/lists/WordList;", "words", "", "", "(Ljava/util/Set;)V", "letters", "Lgnu/trove/THashSet;", "", "kotlin.jvm.PlatformType", "getWords", "()Lgnu/trove/THashSet;", "contains", "", "word", "isAlien", "prefix", "Lkotlin/sequences/Sequence;", "suggest", "distance", "", "spellchecker"})
    public static class Default
    implements WordList {
        @NotNull
        private final THashSet<String> words;
        private final THashSet<Character> letters;

        @NotNull
        protected final THashSet<String> getWords() {
            return this.words;
        }

        @Override
        @NotNull
        public Sequence<String> suggest(@NotNull String word, int distance) {
            Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
            return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)this.words)), (Function1)((Function1)new Function1<String, Boolean>(distance, word){
                final /* synthetic */ int $distance;
                final /* synthetic */ String $word;

                public final boolean invoke(String it) {
                    return Distances.INSTANCE.getLevenshtein().distance(it, this.$word, this.$distance + 1) <= (double)this.$distance;
                }
                {
                    this.$distance = n;
                    this.$word = string;
                    super(1);
                }
            }));
        }

        @Override
        @NotNull
        public Sequence<String> prefix(@NotNull String prefix2) {
            Intrinsics.checkParameterIsNotNull((Object)prefix2, (String)"prefix");
            return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)this.words)), (Function1)((Function1)new Function1<String, Boolean>(prefix2){
                final /* synthetic */ String $prefix;

                public final boolean invoke(String it) {
                    String string = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                    return StringsKt.startsWith$default((String)string, (String)this.$prefix, (boolean)false, (int)2, null);
                }
                {
                    this.$prefix = string;
                    super(1);
                }
            }));
        }

        @Override
        public boolean contains(@NotNull String word) {
            Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
            return this.words.contains((Object)word);
        }

        @Override
        public boolean isAlien(@NotNull String word) {
            boolean bl;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
                CharSequence $this$all$iv = word;
                boolean $i$f$all = false;
                CharSequence charSequence = $this$all$iv;
                for (int i = 0; i < charSequence.length(); ++i) {
                    char element$iv;
                    char it = element$iv = charSequence.charAt(i);
                    boolean bl2 = false;
                    if (!this.letters.contains((Object)Character.valueOf(it))) continue;
                    bl = false;
                    break block1;
                }
                bl = true;
            }
            return bl;
        }

        public Default(@NotNull Set<String> words) {
            Intrinsics.checkParameterIsNotNull(words, (String)"words");
            this.words = new THashSet((Collection)words);
            this.letters = new THashSet((Collection)UtilsKt.letters((Iterable<String>)words));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/grazie/speller/lists/WordList$Empty;", "Lcom/intellij/grazie/speller/lists/WordList;", "()V", "contains", "", "word", "", "isAlien", "prefix", "Lkotlin/sequences/Sequence;", "suggest", "distance", "", "spellchecker"})
    public static class Empty
    implements WordList {
        @Override
        public boolean contains(@NotNull String word) {
            Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
            return false;
        }

        @Override
        @NotNull
        public Sequence<String> suggest(@NotNull String word, int distance) {
            Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
            return SequencesKt.emptySequence();
        }

        @Override
        @NotNull
        public Sequence<String> prefix(@NotNull String prefix2) {
            Intrinsics.checkParameterIsNotNull((Object)prefix2, (String)"prefix");
            return SequencesKt.emptySequence();
        }

        @Override
        public boolean isAlien(@NotNull String word) {
            Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
            return true;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/grazie/speller/lists/WordList$Companion;", "", "()V", "empty", "Lcom/intellij/grazie/speller/lists/WordList;", "getEmpty", "()Lcom/intellij/grazie/speller/lists/WordList;", "spellchecker"})
    public static final class Companion {
        @NotNull
        private static final WordList empty;
        static final /* synthetic */ Companion $$INSTANCE;

        @NotNull
        public final WordList getEmpty() {
            return empty;
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            empty = new Empty();
        }
    }
}

