/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.byteCodeViewer;

import com.intellij.byteCodeViewer.ByteCodeViewerComponent;
import com.intellij.byteCodeViewer.ClassSearcher;
import com.intellij.byteCodeViewer.JavaByteCodeViewerBundle;
import com.intellij.codeInsight.documentation.DockablePopupManager;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.content.Content;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.util.Printer;
import org.jetbrains.org.objectweb.asm.util.Textifier;
import org.jetbrains.org.objectweb.asm.util.TraceClassVisitor;

public final class ByteCodeViewerManager
extends DockablePopupManager<ByteCodeViewerComponent> {
    private static final ExtensionPointName<ClassSearcher> CLASS_SEARCHER_EP = ExtensionPointName.create((String)"ByteCodeViewer.classSearcher");
    private static final Logger LOG = Logger.getInstance(ByteCodeViewerManager.class);
    @NonNls
    private static final String TOOLWINDOW_ID = "Byte Code Viewer";
    @NonNls
    private static final String SHOW_BYTECODE_IN_TOOL_WINDOW = "BYTE_CODE_TOOL_WINDOW";
    @NonNls
    private static final String BYTECODE_AUTO_UPDATE_ENABLED = "BYTE_CODE_AUTO_UPDATE_ENABLED";

    public static ByteCodeViewerManager getInstance(Project project) {
        return (ByteCodeViewerManager)((Object)ServiceManager.getService((Project)project, ByteCodeViewerManager.class));
    }

    public ByteCodeViewerManager(Project project) {
        super(project);
    }

    public String getShowInToolWindowProperty() {
        return SHOW_BYTECODE_IN_TOOL_WINDOW;
    }

    public String getAutoUpdateEnabledProperty() {
        return BYTECODE_AUTO_UPDATE_ENABLED;
    }

    protected String getToolwindowId() {
        return TOOLWINDOW_ID;
    }

    protected String getAutoUpdateTitle() {
        return JavaByteCodeViewerBundle.message("show.bytecode.for.current.element.action.name", new Object[0]);
    }

    protected String getAutoUpdateDescription() {
        return JavaByteCodeViewerBundle.message("show.bytecode.for.current.element.action.description", new Object[0]);
    }

    protected String getRestorePopupDescription() {
        return JavaByteCodeViewerBundle.message("show.bytecode.restore.popup.action.description", new Object[0]);
    }

    protected ByteCodeViewerComponent createComponent() {
        return new ByteCodeViewerComponent(this.myProject);
    }

    @Nullable
    protected String getTitle(PsiElement element) {
        PsiClass aClass = ByteCodeViewerManager.getContainingClass(element);
        if (aClass == null) {
            return null;
        }
        return SymbolPresentationUtil.getSymbolPresentableText((PsiElement)aClass);
    }

    private void updateByteCode(PsiElement element, ByteCodeViewerComponent component, Content content) {
        this.updateByteCode(element, component, content, ByteCodeViewerManager.getByteCode(element));
    }

    private void updateByteCode(PsiElement element, ByteCodeViewerComponent component, Content content, String byteCode) {
        if (!StringUtil.isEmpty((String)byteCode)) {
            component.setText(byteCode, element);
        } else {
            PsiClass presentableElement = ByteCodeViewerManager.getContainingClass(element);
            if (presentableElement == null) {
                presentableElement = element.getContainingFile();
                if (presentableElement == null && element instanceof PsiNamedElement) {
                    presentableElement = element;
                }
                if (presentableElement == null) {
                    component.setText(JavaByteCodeViewerBundle.message("no.bytecode.found", new Object[0]));
                    return;
                }
            }
            component.setText(JavaByteCodeViewerBundle.message("no.bytecode.found.for", SymbolPresentationUtil.getSymbolPresentableText((PsiElement)presentableElement)));
        }
        content.setDisplayName(this.getTitle(element));
    }

    protected void doUpdateComponent(@NotNull PsiElement element, PsiElement originalElement, ByteCodeViewerComponent component) {
        Content content;
        if (element == null) {
            ByteCodeViewerManager.$$$reportNull$$$0(0);
        }
        if ((content = this.myToolWindow.getContentManager().getSelectedContent()) != null) {
            this.updateByteCode(element, component, content);
        }
    }

    protected void doUpdateComponent(Editor editor, PsiFile psiFile) {
        Content content = this.myToolWindow.getContentManager().getSelectedContent();
        if (content == null) {
            return;
        }
        ByteCodeViewerComponent component = (ByteCodeViewerComponent)content.getComponent();
        PsiElement element = psiFile.findElementAt(editor.getCaretModel().getOffset());
        if (element != null) {
            this.updateByteCode(element, component, content);
        }
    }

    protected void doUpdateComponent(@NotNull PsiElement element) {
        if (element == null) {
            ByteCodeViewerManager.$$$reportNull$$$0(1);
        }
        this.doUpdateComponent(element, ByteCodeViewerManager.getByteCode(element));
    }

    protected void doUpdateComponent(@NotNull PsiElement element, String newText) {
        Content content;
        if (element == null) {
            ByteCodeViewerManager.$$$reportNull$$$0(2);
        }
        if ((content = this.myToolWindow.getContentManager().getSelectedContent()) != null) {
            this.updateByteCode(element, (ByteCodeViewerComponent)content.getComponent(), content, newText);
        }
    }

    @Nullable
    public static String getByteCode(@NotNull PsiElement psiElement) {
        block9: {
            PsiClass containingClass;
            if (psiElement == null) {
                ByteCodeViewerManager.$$$reportNull$$$0(3);
            }
            if ((containingClass = ByteCodeViewerManager.getContainingClass(psiElement)) != null) {
                try {
                    byte[] bytes = ByteCodeViewerManager.loadClassFileBytes(containingClass);
                    if (bytes == null) break block9;
                    StringWriter writer = new StringWriter();
                    try (PrintWriter printWriter = new PrintWriter(writer);){
                        new ClassReader(bytes).accept((ClassVisitor)new TraceClassVisitor(null, (Printer)new Textifier(), printWriter), 0);
                    }
                    return writer.toString();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        return null;
    }

    private static byte[] loadClassFileBytes(PsiClass aClass) throws IOException {
        String jvmClassName = ByteCodeViewerManager.getJVMClassName(aClass);
        if (jvmClassName != null) {
            PsiClass fileClass = aClass;
            while (PsiUtil.isLocalOrAnonymousClass((PsiClass)fileClass)) {
                PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)fileClass, PsiClass.class);
                if (containingClass == null) continue;
                fileClass = containingClass;
            }
            VirtualFile file = fileClass.getOriginalElement().getContainingFile().getVirtualFile();
            if (file != null) {
                ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)aClass.getProject());
                if (FileTypeRegistry.getInstance().isFileOfType(file, StdFileTypes.CLASS)) {
                    String classFileName = StringUtil.getShortName((String)jvmClassName) + ".class";
                    if (index.isInLibraryClasses(file)) {
                        VirtualFile classFile = file.getParent().findChild(classFileName);
                        if (classFile != null) {
                            return classFile.contentsToByteArray(false);
                        }
                    } else {
                        File classFile = new File(file.getParent().getPath(), classFileName);
                        if (classFile.isFile()) {
                            return FileUtil.loadFileBytes((File)classFile);
                        }
                    }
                } else {
                    CompilerModuleExtension extension;
                    Module module = index.getModuleForFile(file);
                    if (module != null && (extension = CompilerModuleExtension.getInstance((Module)module)) != null) {
                        VirtualFile classRoot;
                        boolean inTests = index.isInTestSourceContent(file);
                        VirtualFile virtualFile = classRoot = inTests ? extension.getCompilerOutputPathForTests() : extension.getCompilerOutputPath();
                        if (classRoot != null) {
                            String relativePath = jvmClassName.replace('.', '/') + ".class";
                            File classFile = new File(classRoot.getPath(), relativePath);
                            if (classFile.exists()) {
                                return FileUtil.loadFileBytes((File)classFile);
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    private static String getJVMClassName(PsiClass aClass) {
        if (!(aClass instanceof PsiAnonymousClass)) {
            return ClassUtil.getJVMClassName((PsiClass)aClass);
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
        if (containingClass != null) {
            return ByteCodeViewerManager.getJVMClassName(containingClass) + JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)aClass));
        }
        return null;
    }

    @Nullable
    public static PsiClass getContainingClass(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            ByteCodeViewerManager.$$$reportNull$$$0(4);
        }
        for (ClassSearcher searcher : (ClassSearcher[])CLASS_SEARCHER_EP.getExtensions()) {
            PsiClass aClass = searcher.findClass(psiElement);
            if (aClass == null) continue;
            return aClass;
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
        while (containingClass instanceof PsiTypeParameter) {
            containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class);
        }
        if (containingClass == null) {
            PsiFile containingFile = psiElement.getContainingFile();
            if (containingFile instanceof PsiClassOwner) {
                PsiClass[] classes = ((PsiClassOwner)containingFile).getClasses();
                if (classes.length == 1) {
                    return classes[0];
                }
                TextRange textRange = psiElement.getTextRange();
                if (textRange != null) {
                    for (PsiClass aClass : classes) {
                        TextRange classRange;
                        PsiElement navigationElement = aClass.getNavigationElement();
                        TextRange textRange2 = classRange = navigationElement != null ? navigationElement.getTextRange() : null;
                        if (classRange == null || !classRange.contains(textRange)) continue;
                        return aClass;
                    }
                }
            }
            return null;
        }
        return containingClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/byteCodeViewer/ByteCodeViewerManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doUpdateComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getByteCode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getContainingClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

