/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.shell;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.shell.GroovyShellCodeFragment;

public class GroovyShellLanguageConsoleView
extends LanguageConsoleImpl {
    public GroovyShellLanguageConsoleView(Project project, String name) {
        super(new LanguageConsoleImpl.Helper(project, (VirtualFile)new LightVirtualFile(name, (Language)GroovyLanguage.INSTANCE, (CharSequence)"")){

            @NotNull
            public PsiFile getFile() {
                return new GroovyShellCodeFragment(this.project, (LightVirtualFile)this.virtualFile);
            }
        });
    }

    protected void processCode() {
        GroovyShellCodeFragment groovyFile = this.getGroovyFile();
        for (GrTopStatement statement : groovyFile.getTopStatements()) {
            if (statement instanceof GrImportStatement) {
                groovyFile.addImportsFromString(GroovyShellLanguageConsoleView.importToString((GrImportStatement)statement));
                continue;
            }
            if (statement instanceof GrMethod) {
                groovyFile.addVariable(((GrMethod)statement).getName(), this.generateClosure((GrMethod)statement));
                continue;
            }
            if (statement instanceof GrAssignmentExpression) {
                GrAssignmentExpression assignment = (GrAssignmentExpression)statement;
                GrExpression left = assignment.getLValue();
                if (!(left instanceof GrReferenceExpression) || ((GrReferenceExpression)left).isQualified()) continue;
                groovyFile.addVariable(((GrReferenceExpression)left).getReferenceName(), assignment.getRValue());
                continue;
            }
            if (!(statement instanceof GrTypeDefinition)) continue;
            groovyFile.addTypeDefinition(this.prepareTypeDefinition((GrTypeDefinition)statement));
        }
        PsiType scriptType = groovyFile.getInferredScriptReturnType();
        if (scriptType != null) {
            groovyFile.addVariable("_", scriptType);
        }
    }

    @NotNull
    public GroovyShellCodeFragment getGroovyFile() {
        GroovyShellCodeFragment groovyShellCodeFragment = (GroovyShellCodeFragment)this.getFile();
        if (groovyShellCodeFragment == null) {
            GroovyShellLanguageConsoleView.$$$reportNull$$$0(0);
        }
        return groovyShellCodeFragment;
    }

    @NotNull
    private GrTypeDefinition prepareTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
        if (typeDefinition == null) {
            GroovyShellLanguageConsoleView.$$$reportNull$$$0(1);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        GroovyFile file = factory.createGroovyFile("", false, (PsiElement)this.getFile());
        GrTypeDefinition grTypeDefinition = (GrTypeDefinition)file.add(typeDefinition);
        if (grTypeDefinition == null) {
            GroovyShellLanguageConsoleView.$$$reportNull$$$0(2);
        }
        return grTypeDefinition;
    }

    @NotNull
    private GrClosableBlock generateClosure(@NotNull GrMethod method) {
        GrParameter[] parameters2;
        if (method == null) {
            GroovyShellLanguageConsoleView.$$$reportNull$$$0(3);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        for (GrParameter parameter : parameters2 = method.getParameters()) {
            buffer.append(parameter.getText());
            buffer.append(',');
        }
        if (parameters2.length > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        buffer.append("->}");
        GrClosableBlock grClosableBlock = factory.createClosureFromText(buffer.toString(), (PsiElement)this.getFile());
        if (grClosableBlock == null) {
            GroovyShellLanguageConsoleView.$$$reportNull$$$0(4);
        }
        return grClosableBlock;
    }

    @Nullable
    private static String importToString(@NotNull GrImportStatement anImport) {
        String qname;
        if (anImport == null) {
            GroovyShellLanguageConsoleView.$$$reportNull$$$0(5);
        }
        if ((qname = anImport.getImportFqn()) == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(qname);
        if (!anImport.isOnDemand()) {
            String importedName = anImport.getImportedName();
            buffer.append(":").append(importedName);
        }
        return buffer.toString();
    }

    @NotNull
    protected String addToHistoryInner(@NotNull TextRange textRange, @NotNull EditorEx editor, boolean erase2, boolean preserveMarkup) {
        String result2;
        if (textRange == null) {
            GroovyShellLanguageConsoleView.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            GroovyShellLanguageConsoleView.$$$reportNull$$$0(7);
        }
        if ("purge variables".equals((result2 = super.addToHistoryInner(textRange, editor, erase2, preserveMarkup)).trim())) {
            this.clearVariables();
        } else if ("purge classes".equals(result2.trim())) {
            this.clearClasses();
        } else if ("purge imports".equals(result2.trim())) {
            this.clearImports();
        } else if ("purge all".equals(result2.trim())) {
            this.clearVariables();
            this.clearClasses();
            this.clearImports();
        } else {
            this.processCode();
        }
        String string = result2;
        if (string == null) {
            GroovyShellLanguageConsoleView.$$$reportNull$$$0(8);
        }
        return string;
    }

    private void clearVariables() {
        this.getGroovyFile().clearVariables();
    }

    private void clearClasses() {
        this.getGroovyFile().clearClasses();
    }

    private void clearImports() {
        this.getGroovyFile().clearImports();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/shell/GroovyShellLanguageConsoleView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDefinition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anImport";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroovyFile";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/shell/GroovyShellLanguageConsoleView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTypeDefinition";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateClosure";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addToHistoryInner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "prepareTypeDefinition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateClosure";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "importToString";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addToHistoryInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

