/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterInfo;

public class GrChangeInfoImpl
implements JavaChangeInfo {
    private GrMethod method;
    private final String newName;
    @Nullable
    private final CanonicalTypes.Type returnType;
    private final String visibilityModifier;
    private final List<? extends GrParameterInfo> parameters;
    private final boolean myAreParametersChanged;
    private final boolean myIsParameterTypesChanged;
    private final boolean myIsParameterNamesChanged;
    private final boolean myIsNameChanged;
    private final boolean myIsVisibilityChanged;
    private final boolean myIsReturnTypeChanged;
    private final boolean myIsRetainVarargs;
    private final boolean myIsArrayToVarargs;
    private final boolean myIsObtainVarargs;
    private final boolean myWasVarargs;
    private final String myOldName;
    private final PsiIdentifier myNewNameIdentifier;
    private final PsiExpression[] defaultValues;
    private final boolean myDelegate;
    private final ThrownExceptionInfo[] myThrownExceptions;
    private final boolean myExceptionSetChanged;
    private final boolean myExceptionSetOrOrderChanged;
    private final String[] myOldParameterNames;
    private final String[] myOldParameterTypes;

    public GrChangeInfoImpl(@NotNull GrMethod method, @Nullable String visibilityModifier, @Nullable CanonicalTypes.Type returnType2, String newName, List<? extends GrParameterInfo> parameters2, ThrownExceptionInfo @Nullable [] exceptions, boolean generateDelegate) {
        if (method == null) {
            GrChangeInfoImpl.$$$reportNull$$$0(0);
        }
        this.method = method;
        this.visibilityModifier = visibilityModifier == null ? VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList()) : visibilityModifier;
        this.returnType = returnType2;
        this.parameters = parameters2;
        this.newName = newName;
        this.myDelegate = generateDelegate;
        this.myOldName = method.getName();
        this.myIsNameChanged = !method.getName().equals(newName);
        this.myIsVisibilityChanged = visibilityModifier != null && !method.hasModifierProperty(visibilityModifier);
        boolean isReturnTypeChanged = false;
        if (!method.isConstructor()) {
            PsiType oldReturnType = null;
            if (method.getReturnTypeElementGroovy() != null) {
                oldReturnType = method.getReturnType();
            }
            try {
                PsiType newReturnType;
                PsiType psiType = newReturnType = returnType2 == null ? null : returnType2.getType((PsiElement)method);
                if (!Objects.equals(oldReturnType, newReturnType)) {
                    isReturnTypeChanged = true;
                }
            }
            catch (IncorrectOperationException e) {
                isReturnTypeChanged = true;
            }
        }
        this.myIsReturnTypeChanged = isReturnTypeChanged;
        GrParameter[] params = method.getParameters();
        int oldParameterCount = this.method.getParameters().length;
        this.myOldParameterNames = new String[oldParameterCount];
        this.myOldParameterTypes = new String[oldParameterCount];
        for (int i = 0; i < oldParameterCount; ++i) {
            GrParameter param = params[i];
            this.myOldParameterNames[i] = param.getName();
            this.myOldParameterTypes[i] = param.getType().getCanonicalText();
        }
        boolean isParameterNamesChanged = false;
        boolean isParameterTypesChanged = false;
        boolean areParametersChanged = false;
        if (oldParameterCount != this.parameters.size()) {
            areParametersChanged = true;
        } else {
            int parametersSize = parameters2.size();
            for (int i = 0; i < parametersSize; ++i) {
                GrParameterInfo parameter = parameters2.get(i);
                if (parameter.getOldIndex() != i) {
                    areParametersChanged = true;
                    break;
                }
                if (!params[i].getName().equals(parameter.getName())) {
                    isParameterNamesChanged = true;
                }
                try {
                    PsiType type2 = parameter.createType(method);
                    PsiType oldType = params[i].getType();
                    if (oldType.equals(type2)) continue;
                    isParameterTypesChanged = true;
                    continue;
                }
                catch (IncorrectOperationException e) {
                    isParameterTypesChanged = true;
                }
            }
        }
        this.myIsParameterNamesChanged = isParameterNamesChanged;
        this.myIsParameterTypesChanged = isParameterTypesChanged;
        this.myAreParametersChanged = areParametersChanged;
        this.myWasVarargs = method.isVarArgs();
        if (parameters2.isEmpty()) {
            this.myIsObtainVarargs = false;
            this.myIsRetainVarargs = false;
            this.myIsArrayToVarargs = false;
        } else {
            PsiType oldTypeForVararg;
            GrParameterInfo lastNewParam = parameters2.get(parameters2.size() - 1);
            this.myIsObtainVarargs = lastNewParam.isVarargType();
            boolean bl = this.myIsRetainVarargs = lastNewParam.getOldIndex() >= 0 && this.myIsObtainVarargs;
            this.myIsArrayToVarargs = this.myIsRetainVarargs ? (oldTypeForVararg = params[lastNewParam.getOldIndex()].getType()) instanceof PsiArrayType && !(oldTypeForVararg instanceof PsiEllipsisType) : false;
        }
        this.myNewNameIdentifier = this.myIsNameChanged ? (StringUtil.isJavaIdentifier((String)newName) ? JavaPsiFacade.getElementFactory((Project)this.getMethod().getProject()).createIdentifier(newName) : this.getMethod().getNameIdentifier()) : null;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
        this.defaultValues = new PsiExpression[parameters2.size()];
        for (int i = 0; i < parameters2.size(); ++i) {
            JavaParameterInfo info = parameters2.get(i);
            if (info.getOldIndex() >= 0 || info.isVarargType() || info.getDefaultValue() == null) continue;
            try {
                this.defaultValues[i] = factory.createExpressionFromText(info.getDefaultValue(), (PsiElement)method);
                continue;
            }
            catch (IncorrectOperationException e) {
                // empty catch block
            }
        }
        this.myThrownExceptions = exceptions;
        if (exceptions == null) {
            this.myExceptionSetChanged = false;
            this.myExceptionSetOrOrderChanged = false;
        } else {
            PsiClassType[] thrownTypes = method.getThrowsList().getReferencedTypes();
            if (thrownTypes.length != this.myThrownExceptions.length) {
                this.myExceptionSetChanged = true;
                this.myExceptionSetOrOrderChanged = true;
            } else {
                boolean exceptionSetChanged = false;
                boolean exceptionSetOrOrderChanged = false;
                for (int i = 0; i < this.myThrownExceptions.length; ++i) {
                    ThrownExceptionInfo info = this.myThrownExceptions[i];
                    if (info.getOldIndex() < 0 || !thrownTypes[info.getOldIndex()].equals((Object)info.createType((PsiElement)method, method.getManager()))) {
                        exceptionSetChanged = true;
                        exceptionSetOrOrderChanged = true;
                        break;
                    }
                    if (info.getOldIndex() == i) continue;
                    exceptionSetOrOrderChanged = true;
                }
                this.myExceptionSetChanged = exceptionSetChanged;
                this.myExceptionSetOrOrderChanged = exceptionSetOrOrderChanged;
            }
        }
    }

    public JavaParameterInfo @NotNull [] getNewParameters() {
        JavaParameterInfo[] javaParameterInfoArray = this.parameters.toArray(new GrParameterInfo[0]);
        if (javaParameterInfoArray == null) {
            GrChangeInfoImpl.$$$reportNull$$$0(1);
        }
        return javaParameterInfoArray;
    }

    @NotNull
    public String getNewVisibility() {
        String string = this.visibilityModifier;
        if (string == null) {
            GrChangeInfoImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isParameterSetOrOrderChanged() {
        return this.myAreParametersChanged;
    }

    public boolean isParameterTypesChanged() {
        return this.myIsParameterTypesChanged;
    }

    public boolean isParameterNamesChanged() {
        return this.myIsParameterNamesChanged;
    }

    public boolean isGenerateDelegate() {
        return this.myDelegate;
    }

    public boolean isNameChanged() {
        return this.myIsNameChanged;
    }

    public boolean isVisibilityChanged() {
        return this.myIsVisibilityChanged;
    }

    public boolean isExceptionSetChanged() {
        return this.myExceptionSetChanged;
    }

    public boolean isExceptionSetOrOrderChanged() {
        return this.myExceptionSetOrOrderChanged;
    }

    @NotNull
    public GrMethod getMethod() {
        GrMethod grMethod = this.method;
        if (grMethod == null) {
            GrChangeInfoImpl.$$$reportNull$$$0(3);
        }
        return grMethod;
    }

    public boolean isReturnTypeChanged() {
        return this.myIsReturnTypeChanged;
    }

    public CanonicalTypes.Type getNewReturnType() {
        return this.returnType;
    }

    public String getNewName() {
        return this.newName;
    }

    public Language getLanguage() {
        return GroovyLanguage.INSTANCE;
    }

    public String @NotNull [] getOldParameterNames() {
        if (this.myOldParameterNames == null) {
            GrChangeInfoImpl.$$$reportNull$$$0(4);
        }
        return this.myOldParameterNames;
    }

    public String @NotNull [] getOldParameterTypes() {
        if (this.myOldParameterTypes == null) {
            GrChangeInfoImpl.$$$reportNull$$$0(5);
        }
        return this.myOldParameterTypes;
    }

    public ThrownExceptionInfo[] getNewExceptions() {
        return this.myThrownExceptions;
    }

    public boolean isRetainsVarargs() {
        return this.myIsRetainVarargs;
    }

    public boolean isObtainsVarags() {
        return this.myIsObtainVarargs;
    }

    public boolean isArrayToVarargs() {
        return this.myIsArrayToVarargs;
    }

    public PsiIdentifier getNewNameIdentifier() {
        return this.myNewNameIdentifier;
    }

    public String getOldName() {
        return this.myOldName;
    }

    public boolean wasVararg() {
        return this.myWasVarargs;
    }

    public boolean[] toRemoveParm() {
        return new boolean[0];
    }

    public PsiExpression getValue(int i, PsiCallExpression callExpression) {
        if (this.defaultValues[i] != null) {
            return this.defaultValues[i];
        }
        PsiElement valueAtCallSite = this.parameters.get(i).getActualValue((PsiElement)callExpression, PsiSubstitutor.EMPTY);
        return valueAtCallSite instanceof PsiExpression ? (PsiExpression)valueAtCallSite : null;
    }

    public void updateMethod(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            GrChangeInfoImpl.$$$reportNull$$$0(6);
        }
        if (psiMethod instanceof GrMethod) {
            this.method = (GrMethod)psiMethod;
        }
    }

    @NotNull
    public Collection<PsiMethod> getMethodsToPropagateParameters() {
        List<PsiMethod> list = Collections.emptyList();
        if (list == null) {
            GrChangeInfoImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/changeSignature/GrChangeInfoImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/changeSignature/GrChangeInfoImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewVisibility";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethod";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldParameterNames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldParameterTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsToPropagateParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

