/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.imports;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyFileImports;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImports;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyNamedImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.StarImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.impl.CacheKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassProcessor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J(\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010'\u001a\u00020\u0003H\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u000f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\b\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/imports/RegularImport;", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/GroovyNamedImport;", "classFqn", "", "(Ljava/lang/String;)V", "name", "(Ljava/lang/String;Ljava/lang/String;)V", "getClassFqn", "()Ljava/lang/String;", "fullyQualifiedName", "getFullyQualifiedName", "isAliased", "", "()Z", "getName", "shortName", "getShortName", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "isUnnecessary", "imports", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/GroovyFileImports;", "processDeclarations", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "place", "Lcom/intellij/psi/PsiElement;", "file", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;", "resolveImport", "Lcom/intellij/psi/PsiClass;", "toString", "intellij.groovy.psi"})
public final class RegularImport
implements GroovyNamedImport {
    private final boolean isAliased;
    @NotNull
    private final String classFqn;
    @NotNull
    private final String name;

    @Override
    public boolean isAliased() {
        return this.isAliased;
    }

    @Override
    @NotNull
    public String getShortName() {
        String string = StringUtil.getShortName((String)this.classFqn);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortName(classFqn)");
        return string;
    }

    @Override
    @NotNull
    public String getFullyQualifiedName() {
        return this.classFqn;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PsiClass resolveImport(@NotNull GroovyFileBase file) {
        void $this$resolve$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GroovyFileBase groovyFileBase = file;
        GroovyImport import$iv = this;
        boolean $i$f$resolve = false;
        ConcurrentMap cache$iv = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)$this$resolve$iv), (CachedValueProvider)CacheKt.resolve.cache.1.INSTANCE);
        return (PsiClass)cache$iv.computeIfAbsent(import$iv, new Function<RegularImport, T>(file){
            final /* synthetic */ GroovyFileBase $file$inlined;
            {
                this.$file$inlined = groovyFileBase;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object apply(GroovyImport it) {
                GroovyImport groovyImport = it;
                Intrinsics.checkNotNullExpressionValue((Object)groovyImport, (String)"it");
                RegularImport $this$resolve = (RegularImport)groovyImport;
                boolean bl = false;
                String string = this.$file$inlined.getPackageName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.packageName");
                CharSequence charSequence = string;
                boolean bl2 = false;
                return charSequence.length() == 0 || StringsKt.contains$default((CharSequence)$this$resolve.getClassFqn(), (char)'.', (boolean)false, (int)2, null) ? JavaPsiFacade.getInstance((Project)this.$file$inlined.getProject()).findClass($this$resolve.getClassFqn(), this.$file$inlined.getResolveScope()) : null;
            }
        });
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, @NotNull GroovyFileBase file) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (ResolveUtilKt.isNonAnnotationResolve(processor)) {
            return true;
        }
        if (!ResolveUtilKt.shouldProcessClasses(processor)) {
            return true;
        }
        if (!ResolveUtilKt.checkName(processor, this.getName(), state)) {
            return true;
        }
        PsiClass psiClass = this.resolveImport(file);
        if (psiClass == null) {
            return true;
        }
        PsiClass clazz = psiClass;
        return processor.execute((PsiElement)clazz, state.put(GroovyImports.getImportedNameKey(), (Object)this.getName()));
    }

    @Override
    public boolean isUnnecessary(@NotNull GroovyFileImports imports2) {
        Intrinsics.checkNotNullParameter((Object)imports2, (String)"imports");
        if (this.isAliased()) {
            return false;
        }
        GroovyFileBase file = imports2.getFile();
        ClassProcessor processor = new ClassProcessor(this.getName(), file, null, false, 12, null);
        ResolveState resolveState = ResolveState.initial();
        Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"ResolveState.initial()");
        ResolveState state = resolveState;
        if (!imports2.processStaticImports(processor, state, file)) {
            return false;
        }
        String string = StringUtil.getPackageName((String)this.classFqn);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.getPackageName(classFqn)");
        StarImport starImport = new StarImport(string);
        if (Intrinsics.areEqual((Object)starImport.getPackageFqn(), (Object)file.getPackageName())) {
            return true;
        }
        if (!ResolveUtilKt.processClassesInFile(file, processor, state)) {
            return false;
        }
        if (!ResolveUtilKt.processClassesInPackage$default(file, processor, state, null, 4, null)) {
            return false;
        }
        if (imports2.getStarImports().contains(starImport)) {
            return true;
        }
        if (!imports2.processAllStarImports(processor, state, file)) {
            return false;
        }
        List results = processor.getResults();
        boolean bl = results.isEmpty();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Processor returned true, but there are " + results.size() + " results: " + results;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return GroovyImports.getDefaultRegularImportsSet().contains((Object)this) || GroovyImports.getDefaultStarImportsSet().contains((Object)starImport);
    }

    @NonNls
    @NotNull
    public String toString() {
        return "import " + this.classFqn + " as " + this.getName();
    }

    @NotNull
    public final String getClassFqn() {
        return this.classFqn;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public RegularImport(@NotNull String classFqn, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)classFqn, (String)"classFqn");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.classFqn = classFqn;
        this.name = name;
        this.isAliased = Intrinsics.areEqual((Object)this.getShortName(), (Object)this.getName()) ^ true;
    }

    public RegularImport(@NotNull String classFqn) {
        Intrinsics.checkNotNullParameter((Object)classFqn, (String)"classFqn");
        String string = StringUtil.getShortName((String)classFqn);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.getShortName(classFqn)");
        this(classFqn, string);
    }

    @NotNull
    public final String component1() {
        return this.classFqn;
    }

    @NotNull
    public final String component2() {
        return this.getName();
    }

    @NotNull
    public final RegularImport copy(@NotNull String classFqn, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)classFqn, (String)"classFqn");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new RegularImport(classFqn, name);
    }

    public static /* synthetic */ RegularImport copy$default(RegularImport regularImport, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = regularImport.classFqn;
        }
        if ((n & 2) != 0) {
            string2 = regularImport.getName();
        }
        return regularImport.copy(string, string2);
    }

    public int hashCode() {
        String string = this.classFqn;
        String string2 = this.getName();
        return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof RegularImport)) break block3;
                RegularImport regularImport = (RegularImport)object;
                if (!Intrinsics.areEqual((Object)this.classFqn, (Object)regularImport.classFqn) || !Intrinsics.areEqual((Object)this.getName(), (Object)regularImport.getName())) break block3;
            }
            return true;
        }
        return false;
    }
}

