/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;

public final class GrClassReferenceType
extends PsiClassType {
    @NotNull
    private final GrCodeReferenceElement myReferenceElement;

    public GrClassReferenceType(@NotNull GrCodeReferenceElement referenceElement) {
        if (referenceElement == null) {
            GrClassReferenceType.$$$reportNull$$$0(0);
        }
        this(referenceElement, LanguageLevel.JDK_1_5);
    }

    private GrClassReferenceType(@NotNull GrCodeReferenceElement referenceElement, @NotNull LanguageLevel languageLevel) {
        if (referenceElement == null) {
            GrClassReferenceType.$$$reportNull$$$0(1);
        }
        if (languageLevel == null) {
            GrClassReferenceType.$$$reportNull$$$0(2);
        }
        super(languageLevel);
        this.myReferenceElement = referenceElement;
    }

    @Nullable
    public PsiClass resolve() {
        return this.resolveGenerics().getElement();
    }

    @Nullable
    public String getClassName() {
        PsiClass resolved = this.resolve();
        if (resolved != null) {
            return resolved.getName();
        }
        return this.myReferenceElement.getReferenceName();
    }

    public int getParameterCount() {
        GrTypeArgumentList typeArgumentList = this.myReferenceElement.getTypeArgumentList();
        return typeArgumentList == null ? 0 : typeArgumentList.getTypeArgumentCount();
    }

    public PsiType @NotNull [] getParameters() {
        PsiType[] psiTypeArray = this.myReferenceElement.getTypeArguments();
        if (psiTypeArray == null) {
            GrClassReferenceType.$$$reportNull$$$0(3);
        }
        return psiTypeArray;
    }

    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        final GroovyResolveResult resolveResult2 = this.myReferenceElement.advancedResolve();
        return new PsiClassType.ClassResolveResult(){

            public PsiClass getElement() {
                PsiElement resolved = resolveResult2.getElement();
                return resolved instanceof PsiClass ? (PsiClass)resolved : null;
            }

            @NotNull
            public PsiSubstitutor getSubstitutor() {
                PsiSubstitutor psiSubstitutor = resolveResult2.getSubstitutor();
                if (psiSubstitutor == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiSubstitutor;
            }

            public boolean isPackagePrefixPackageReference() {
                return false;
            }

            public boolean isAccessible() {
                return resolveResult2.isAccessible();
            }

            public boolean isStaticsScopeCorrect() {
                return resolveResult2.isStaticsOK();
            }

            @Nullable
            public PsiElement getCurrentFileResolveScope() {
                return resolveResult2.getCurrentFileResolveContext();
            }

            public boolean isValidResult() {
                return this.isStaticsScopeCorrect() && this.isAccessible();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType$1", "getSubstitutor"));
            }
        };
    }

    @NotNull
    public PsiClassType rawType() {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myReferenceElement.getProject());
        PsiClass clazz = this.resolve();
        if (clazz != null) {
            PsiClassType psiClassType = factory.createType(clazz, factory.createRawSubstitutor((PsiTypeParameterListOwner)clazz), this.getLanguageLevel());
            if (psiClassType == null) {
                GrClassReferenceType.$$$reportNull$$$0(4);
            }
            return psiClassType;
        }
        String qName = StringUtil.notNullize((String)this.myReferenceElement.getQualifiedReferenceName());
        PsiClassType psiClassType = factory.createTypeByFQClassName(qName, this.myReferenceElement.getResolveScope());
        if (psiClassType == null) {
            GrClassReferenceType.$$$reportNull$$$0(5);
        }
        return psiClassType;
    }

    @NotNull
    public String getPresentableText() {
        String string = PsiNameHelper.getPresentableText((String)this.myReferenceElement.getReferenceName(), (PsiAnnotation[])PsiAnnotation.EMPTY_ARRAY, (PsiType[])this.myReferenceElement.getTypeArguments());
        if (string == null) {
            GrClassReferenceType.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myReferenceElement.getCanonicalText();
        if (string == null) {
            GrClassReferenceType.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isValid() {
        return this.myReferenceElement.isValid();
    }

    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            GrClassReferenceType.$$$reportNull$$$0(8);
        }
        return text.endsWith(this.getPresentableText()) && text.equals(this.getCanonicalText());
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myReferenceElement.getResolveScope();
        if (globalSearchScope == null) {
            GrClassReferenceType.$$$reportNull$$$0(9);
        }
        return globalSearchScope;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevel;
        if (languageLevel == null) {
            GrClassReferenceType.$$$reportNull$$$0(10);
        }
        return languageLevel;
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            GrClassReferenceType.$$$reportNull$$$0(11);
        }
        return new GrClassReferenceType(this.myReferenceElement, languageLevel);
    }

    @NotNull
    public GrCodeReferenceElement getReference() {
        GrCodeReferenceElement grCodeReferenceElement = this.myReferenceElement;
        if (grCodeReferenceElement == null) {
            GrClassReferenceType.$$$reportNull$$$0(12);
        }
        return grCodeReferenceElement;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GrClassReferenceType && this.myReferenceElement.equals(((GrClassReferenceType)((Object)obj)).myReferenceElement)) {
            return true;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        String name = this.myReferenceElement.getReferenceName();
        return name == null ? 0 : name.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "rawType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

