/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J \u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/conversions/RemoveParenthesesFromMethodCallIntention;", "Lorg/jetbrains/plugins/groovy/intentions/base/Intention;", "()V", "getElementPredicate", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "isStopElement", "", "element", "Lcom/intellij/psi/PsiElement;", "processIntention", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "Predicate", "intellij.groovy"})
public final class RemoveParenthesesFromMethodCallIntention
extends Intention {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return Predicate.INSTANCE;
    }

    @Override
    protected boolean isStopElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return super.isStopElement(element) || element instanceof GrStatementOwner;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        String newText = RemoveParenthesesFromMethodCallIntention.Companion.removeParentheses((GrMethodCallExpression)element);
        GrStatement grStatement = GroovyPsiElementFactory.getInstance(project).createStatementFromText(newText);
        Intrinsics.checkNotNullExpressionValue((Object)grStatement, (String)"GroovyPsiElementFactory.\u2026tatementFromText(newText)");
        GrStatement statement = grStatement;
        element.replace((PsiElement)statement);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/conversions/RemoveParenthesesFromMethodCallIntention$Predicate;", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "()V", "checkArguments", "", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrMethodCallExpression;", "checkParseableWithoutParentheses", "checkPosition", "satisfiedBy", "element", "Lcom/intellij/psi/PsiElement;", "intellij.groovy"})
    private static final class Predicate
    implements PsiElementPredicate {
        public static final Predicate INSTANCE;

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement psiElement = element;
            if (!(psiElement instanceof GrMethodCallExpression)) {
                psiElement = null;
            }
            GrMethodCallExpression grMethodCallExpression = (GrMethodCallExpression)psiElement;
            if (grMethodCallExpression == null) {
                return false;
            }
            GrMethodCallExpression call = grMethodCallExpression;
            return this.checkArguments(call) && this.checkPosition(call) && this.checkParseableWithoutParentheses(call);
        }

        private final boolean checkArguments(GrMethodCallExpression call) {
            GrArgumentList grArgumentList = call.getArgumentList();
            Intrinsics.checkNotNullExpressionValue((Object)grArgumentList, (String)"call.argumentList");
            GrArgumentList argumentList = grArgumentList;
            Object[] arguments2 = argumentList.getAllArguments();
            if (call.hasClosureArguments()) {
                Intrinsics.checkNotNullExpressionValue((Object)arguments2, (String)"arguments");
                Object[] objectArray = arguments2;
                boolean bl = false;
                return objectArray.length == 0;
            }
            Intrinsics.checkNotNullExpressionValue((Object)arguments2, (String)"arguments");
            Object[] objectArray = arguments2;
            boolean bl = false;
            if (objectArray.length == 0) {
                return false;
            }
            if (ArraysKt.first((Object[])arguments2) instanceof GrClosableBlock) {
                return arguments2.length == 1;
            }
            return true;
        }

        private final boolean checkPosition(GrMethodCallExpression call) {
            if (PsiUtil.isExpressionStatement(call)) {
                return true;
            }
            PsiElement parent2 = call.getParent();
            if (parent2 instanceof GrVariable && ((GrVariable)parent2).getInitializerGroovy() == call) {
                return true;
            }
            return parent2 instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent2).getRValue() == call;
        }

        private final boolean checkParseableWithoutParentheses(GrMethodCallExpression call) {
            String newText = Companion.removeParentheses(call);
            try {
                GroovyPsiElementFactory.getInstance(call.getProject()).createStatementFromText(newText);
            }
            catch (IncorrectOperationException e) {
                return false;
            }
            return true;
        }

        private Predicate() {
        }

        static {
            Predicate predicate2;
            INSTANCE = predicate2 = new Predicate();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/conversions/RemoveParenthesesFromMethodCallIntention$Companion;", "", "()V", "removeParentheses", "", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrMethodCallExpression;", "replaceWithSpace", "", "Lcom/intellij/lang/ASTNode;", "intellij.groovy"})
    public static final class Companion {
        private final String removeParentheses(GrMethodCallExpression call) {
            PsiElement psiElement;
            PsiElement psiElement2 = call.copy();
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression");
            }
            GrMethodCallExpression copy = (GrMethodCallExpression)psiElement2;
            GrArgumentList grArgumentList = copy.getArgumentList();
            boolean bl = false;
            boolean bl2 = false;
            GrArgumentList $this$apply = grArgumentList;
            boolean bl3 = false;
            PsiElement psiElement3 = $this$apply.getLeftParen();
            if (psiElement3 != null && (psiElement3 = psiElement3.getNode()) != null) {
                Companion.replaceWithSpace((ASTNode)psiElement3);
            }
            if ((psiElement = $this$apply.getRightParen()) != null && (psiElement = psiElement.getNode()) != null) {
                Companion.replaceWithSpace((ASTNode)psiElement);
            }
            String string = copy.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"copy.text");
            return string;
        }

        private final void replaceWithSpace(ASTNode $this$replaceWithSpace) {
            ASTNode parent2 = $this$replaceWithSpace.getTreeParent();
            parent2.addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", $this$replaceWithSpace);
            parent2.removeChild($this$replaceWithSpace);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

