/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.translate.util;

import com.thaiopensource.relaxng.translate.util.AbstractParam;
import com.thaiopensource.relaxng.translate.util.InvalidParamValueException;
import com.thaiopensource.relaxng.translate.util.ParamProcessor;

public abstract class IntegerParam
extends AbstractParam {
    private final int minValue;
    private final int maxValue;

    public IntegerParam(int n, int n2) {
        this.minValue = n;
        this.maxValue = n2;
    }

    public IntegerParam() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public void set(String string) throws InvalidParamValueException {
        try {
            int n = Integer.parseInt(string);
            if (n < this.minValue || n > this.maxValue) {
                throw new ParamProcessor.LocalizedInvalidValueException("out_of_range_integer");
            }
            this.setInteger(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParamProcessor.LocalizedInvalidValueException("not_an_integer");
        }
    }

    protected abstract void setInteger(int var1) throws InvalidParamValueException;
}

