/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.eclipse.model;

import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.AbstractEclipseClasspathReader;
import org.jetbrains.idea.eclipse.ConversionException;
import org.jetbrains.idea.eclipse.EPathCommonUtil;
import org.jetbrains.idea.eclipse.EclipseModuleManager;
import org.jetbrains.idea.eclipse.EclipseProjectFinder;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaDependencyExtension;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaLibraryType;
import org.jetbrains.jps.model.java.JpsJavaModuleExtension;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryReference;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependenciesList;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsSdkDependency;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;
import org.jetbrains.jps.model.serialization.library.JpsLibraryTableSerializer;

class JpsEclipseClasspathReader
extends AbstractEclipseClasspathReader<JpsModule> {
    private static final Logger LOG = Logger.getInstance(JpsEclipseClasspathReader.class);
    private final Map<String, String> myLibLevels;

    JpsEclipseClasspathReader(String rootPath, @Nullable List<String> currentRoots, @Nullable Set<String> moduleNames, Map<String, String> levels) {
        super(rootPath, currentRoots, moduleNames);
        this.myLibLevels = levels;
    }

    protected String prepareValidUrlInsideJar(String url) {
        String jarSeparator = "!/";
        int localPathEndIdx = url.indexOf("!/");
        if (localPathEndIdx > -1) {
            return url.substring(0, localPathEndIdx + "!/".length());
        }
        return url;
    }

    protected void addNamedLibrary(JpsModule rootModel, Collection<? super String> unknownLibraries, boolean exported, String name, boolean applicationLevel) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("loading " + rootModel.getName() + ": adding " + (applicationLevel ? "application" : "project") + " library '" + name + "'");
        }
        JpsElementFactory factory = JpsElementFactory.getInstance();
        String level = this.myLibLevels.get(name);
        JpsLibraryReference libraryReference = level != null ? factory.createLibraryReference(name, JpsLibraryTableSerializer.createLibraryTableReference((String)level)) : factory.createLibraryReference(name, factory.createGlobalReference());
        JpsLibraryDependency dependency = rootModel.getDependenciesList().addLibraryDependency(libraryReference);
        JpsEclipseClasspathReader.setLibraryEntryExported((JpsDependencyElement)dependency, exported);
    }

    protected void addInvalidModuleEntry(JpsModule rootModel, boolean exported, String moduleName) {
        JpsElementFactory elementFactory = JpsElementFactory.getInstance();
        JpsDependenciesList dependenciesList = rootModel.getDependenciesList();
        JpsModuleDependency dependency = dependenciesList.addModuleDependency(elementFactory.createModuleReference(moduleName));
        JpsJavaDependencyExtension extension = JpsEclipseClasspathReader.getService().getOrCreateDependencyExtension((JpsDependencyElement)dependency);
        extension.setExported(exported);
    }

    protected void setUpModuleJdk(JpsModule rootModel, Collection<? super String> unknownJdks, EclipseModuleManager eclipseModuleManager, String jdkName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("loading " + rootModel.getName() + ": set module jdk " + jdkName);
        }
        rootModel.getDependenciesList().addSdkDependency((JpsSdkType)JpsJavaSdkType.INSTANCE);
    }

    protected void addSourceFolder(JpsModule rootModel, String srcUrl, boolean testFolder) {
        rootModel.addSourceRoot(srcUrl, (JpsModuleSourceRootType)(testFolder ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE));
    }

    protected void addSourceFolderToCurrentContentRoot(JpsModule rootModel, String srcUrl, boolean testFolder) {
        rootModel.addSourceRoot(srcUrl, (JpsModuleSourceRootType)(testFolder ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE));
    }

    protected void addJUnitDefaultLib(JpsModule rootModel, String junitName, ExpandMacroToPathMap macroMap) {
        FilenameFilter junitFilter;
        @NonNls String ideaHome = macroMap.substitute("$APPLICATION_HOME_DIR$", SystemInfo.isFileSystemCaseSensitive);
        File[] junitJars = new File(ideaHome, "lib").listFiles(junitFilter = (dir, name) -> name.startsWith("junit"));
        if (junitJars == null || junitJars.length == 0) {
            junitJars = new File(new File(ideaHome, "community"), "lib").listFiles(junitFilter);
        }
        if (junitJars != null && junitJars.length > 0) {
            boolean isJUnit4 = junitName.contains("4");
            File junitJar = null;
            for (File jar : junitJars) {
                boolean isCurrentJarV4 = jar.getName().contains("4");
                if ((!isCurrentJarV4 || !isJUnit4) && (isCurrentJarV4 || isJUnit4)) continue;
                junitJar = jar;
                break;
            }
            if (junitJar != null) {
                JpsLibrary jpsLibrary = rootModel.addModuleLibrary(junitName, (JpsLibraryType)JpsJavaLibraryType.INSTANCE);
                jpsLibrary.addRoot(JpsEclipseClasspathReader.pathToUrl((String)junitJar.getPath()), JpsOrderRootType.COMPILED);
                JpsDependenciesList dependenciesList = rootModel.getDependenciesList();
                dependenciesList.addLibraryDependency(jpsLibrary);
            }
        }
    }

    protected void addModuleLibrary(JpsModule rootModel, Element element, boolean exported, String libName, String url, String srcUrl, String nativeRoot, ExpandMacroToPathMap macroMap) {
        JpsLibrary jpsLibrary = rootModel.addModuleLibrary(libName, (JpsLibraryType)JpsJavaLibraryType.INSTANCE);
        JpsDependenciesList dependenciesList = rootModel.getDependenciesList();
        JpsLibraryDependency dependency = dependenciesList.addLibraryDependency(jpsLibrary);
        String linked = this.expandLinkedResourcesPath(url = StringUtil.trimStart((String)url, (String)"file://"), macroMap);
        url = linked != null ? JpsEclipseClasspathReader.pathToUrl((String)linked) : this.expandEclipsePath2Url(rootModel, url);
        LOG.debug("loading " + rootModel.getName() + ": adding module library " + libName + ": " + url);
        jpsLibrary.addRoot(url, JpsOrderRootType.COMPILED);
        JpsEclipseClasspathReader.setLibraryEntryExported((JpsDependencyElement)dependency, exported);
    }

    protected String expandEclipsePath2Url(JpsModule rootModel, String path) {
        String url = null;
        if (new File(path).exists()) {
            url = JpsEclipseClasspathReader.pathToUrl((String)path);
        } else {
            String relativePath = new File(this.myRootPath, path).getPath();
            File file = new File(relativePath);
            if (file.exists()) {
                url = JpsEclipseClasspathReader.pathToUrl((String)relativePath);
            } else if (path.startsWith("/")) {
                String moduleName = EPathCommonUtil.getRelativeModuleName((String)path);
                String relativeToRootPath = EPathCommonUtil.getRelativeToModulePath((String)path);
                url = EPathCommonUtil.expandEclipseRelative2ContentRoots((List)this.myCurrentRoots, (String)moduleName, (String)relativeToRootPath);
            }
        }
        if (url == null) {
            url = JpsEclipseClasspathReader.pathToUrl((String)path);
        }
        return this.prepareValidUrlInsideJar(url);
    }

    protected Set<String> getDefinedCons() {
        return Collections.emptySet();
    }

    protected int rearrange(JpsModule rootModel) {
        return 0;
    }

    public void readClasspath(JpsModule model, String testPattern, Element classpathElement, JpsMacroExpander expander) throws IOException {
        LOG.debug("start loading classpath for " + model.getName());
        HashSet libs = new HashSet();
        for (Object o : classpathElement.getChildren("classpathentry")) {
            try {
                this.readClasspathEntry(model, new ArrayList(), new ArrayList(), new HashSet(), testPattern, (Element)o, 0, null, expander.getExpandMacroMap(), libs);
            }
            catch (ConversionException e) {
                throw new IOException(e);
            }
        }
        boolean foundSdkDependency = false;
        JpsDependenciesList dependenciesList = model.getDependenciesList();
        for (JpsDependencyElement element : dependenciesList.getDependencies()) {
            if (!(element instanceof JpsSdkDependency)) continue;
            foundSdkDependency = true;
            break;
        }
        if (!foundSdkDependency) {
            dependenciesList.addSdkDependency((JpsSdkType)JpsJavaSdkType.INSTANCE);
        }
        if (LOG.isDebugEnabled()) {
            String name = model.getName();
            LOG.debug("finished loading classpath for " + name + " (" + dependenciesList.getDependencies().size() + " items):");
            for (JpsDependencyElement element : dependenciesList.getDependencies()) {
                LOG.debug(" [" + name + "]:" + element.toString());
            }
        }
    }

    @Nullable
    private String expandLinkedResourcesPath(String path, ExpandMacroToPathMap expander) {
        EclipseProjectFinder.LinkedResource linkedResource = EclipseProjectFinder.findLinkedResource((String)this.myRootPath, (String)path);
        if (linkedResource != null) {
            if (linkedResource.containsPathVariable()) {
                String toPathVariableFormat = JpsEclipseClasspathReader.getVariableRelatedPath((String)linkedResource.getVariableName(), (String)linkedResource.getRelativeToVariablePath());
                return expander.substitute(toPathVariableFormat, SystemInfo.isFileSystemCaseSensitive);
            }
            return linkedResource.getLocation();
        }
        return null;
    }

    public void setupOutput(JpsModule rootModel, String path) {
        JpsJavaModuleExtension extension = JpsEclipseClasspathReader.getService().getOrCreateModuleExtension(rootModel);
        String outputUrl = JpsEclipseClasspathReader.pathToUrl((String)path);
        extension.setOutputUrl(outputUrl);
        extension.setTestOutputUrl(outputUrl);
        rootModel.getDependenciesList().addModuleSourceDependency();
    }

    private static void setLibraryEntryExported(JpsDependencyElement dependency, boolean exported) {
        JpsJavaDependencyExtension extension = JpsEclipseClasspathReader.getService().getOrCreateDependencyExtension(dependency);
        extension.setExported(exported);
    }

    private static JpsJavaExtensionService getService() {
        return JpsJavaExtensionService.getInstance();
    }
}

