/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.lw.FontDescriptor;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.FontEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.FontRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.awt.Font;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroFontProperty
extends IntrospectedProperty<FontDescriptor> {
    private final FontRenderer myFontRenderer = new FontRenderer();
    private FontEditor myFontEditor;
    @NonNls
    private static final String CLIENT_PROPERTY_KEY_PREFIX = "IntroFontProperty_";

    public IntroFontProperty(String name, Method readMethod, Method writeMethod, boolean storeAsClient) {
        super(name, readMethod, writeMethod, storeAsClient);
    }

    @Override
    public void write(@NotNull FontDescriptor value, XmlWriter writer) {
        if (value == null) {
            IntroFontProperty.$$$reportNull$$$0(0);
        }
        writer.writeFontDescriptor(value);
    }

    @Override
    @NotNull
    public PropertyRenderer<FontDescriptor> getRenderer() {
        FontRenderer fontRenderer = this.myFontRenderer;
        if (fontRenderer == null) {
            IntroFontProperty.$$$reportNull$$$0(1);
        }
        return fontRenderer;
    }

    @Override
    @Nullable
    public PropertyEditor<FontDescriptor> getEditor() {
        if (this.myFontEditor == null) {
            this.myFontEditor = new FontEditor(this.getName());
        }
        return this.myFontEditor;
    }

    @Override
    public FontDescriptor getValue(RadComponent component) {
        FontDescriptor fontDescriptor = (FontDescriptor)component.getDelegee().getClientProperty(CLIENT_PROPERTY_KEY_PREFIX + this.getName());
        if (fontDescriptor == null) {
            return new FontDescriptor(null, -1, -1);
        }
        return fontDescriptor;
    }

    @Override
    protected void setValueImpl(RadComponent component, FontDescriptor value) throws Exception {
        component.getDelegee().putClientProperty(CLIENT_PROPERTY_KEY_PREFIX + this.getName(), value);
        if (value != null) {
            if (!component.isLoadingProperties()) {
                this.invokeSetter(component, this.getDefaultValue(component.getDelegee()));
            }
            Font defaultFont = (Font)this.invokeGetter(component);
            Font resolvedFont = value.getResolvedFont(defaultFont);
            this.invokeSetter(component, resolvedFont);
        }
    }

    @Override
    public void resetValue(RadComponent component) throws Exception {
        super.resetValue(component);
        component.getDelegee().putClientProperty(CLIENT_PROPERTY_KEY_PREFIX + this.getName(), null);
    }

    @NlsSafe
    public static String descriptorToString(FontDescriptor value) {
        String result;
        if (value == null) {
            return "";
        }
        if (value.getSwingFont() != null) {
            return value.getSwingFont();
        }
        StringBuilder builder = new StringBuilder();
        if (value.getFontName() != null) {
            builder.append(value.getFontName());
        }
        if (value.getFontSize() >= 0) {
            builder.append(' ').append(value.getFontSize()).append(" pt");
        }
        if (value.getFontStyle() >= 0) {
            if (value.getFontStyle() == 0) {
                builder.append(' ').append(UIDesignerBundle.message("font.chooser.regular", new Object[0]));
            } else {
                if ((value.getFontStyle() & 1) != 0) {
                    builder.append(' ').append(UIDesignerBundle.message("font.chooser.bold", new Object[0]));
                }
                if ((value.getFontStyle() & 2) != 0) {
                    builder.append(" ").append(UIDesignerBundle.message("font.chooser.italic", new Object[0]));
                }
            }
        }
        if ((result = builder.toString().trim()).length() > 0) {
            return result;
        }
        return UIDesignerBundle.message("font.default", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/propertyInspector/properties/IntroFontProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/propertyInspector/properties/IntroFontProperty";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

