/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomGoal;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;
import org.jetbrains.kotlin.idea.maven.KotlinMavenBundle;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.inspections.KotlinMavenPluginPhaseInspectionKt;
import org.jetbrains.kotlin.idea.platform.IdePlatformKindToolingKt;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006\f\r\u000e\u000f\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "()V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "getStaticDescription", "", "AddExecutionLocalFix", "AddJavaExecutionsLocalFix", "Companion", "ConfigurePluginExecutionLocalFix", "FixAddStdlibLocalFix", "FixExecutionPhaseLocalFix", "kotlin.maven"})
public final class KotlinMavenPluginPhaseInspection
extends DomElementsInspection<MavenDomProjectModel> {
    private static final List<MavenId> JVM_STDLIB_IDS;
    private static final MavenId JS_STDLIB_MAVEN_ID;
    public static final Companion Companion;

    @NotNull
    public String getStaticDescription() {
        return KotlinMavenBundle.message("inspection.description", new Object[0]);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void checkFileElement(@Nullable DomFileElement<MavenDomProjectModel> domFileElement, @Nullable DomElementAnnotationHolder holder) {
        if (domFileElement == null || holder == null) {
            return;
        }
        v0 = domFileElement.getModule();
        if (v0 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"domFileElement.module ?: return");
        module = v0;
        manager = MavenProjectsManager.getInstance((Project)module.getProject());
        v1 = manager.findProject(module);
        if (v1 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"manager.findProject(module) ?: return");
        mavenProject = v1;
        v2 = domFileElement.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"domFileElement.file");
        v3 = PomFile.Companion.forFileOrNull(v2);
        if (v3 == null) {
            return;
        }
        pom = v3;
        hasJavaFiles = KotlinMavenPluginPhaseInspectionKt.hasJavaFiles(module);
        v4 = mavenProject.getPlugins();
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"mavenProject.plugins");
        $this$filter$iv = v4;
        $i$f$filter = false;
        var11_12 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (MavenPlugin)element$iv$iv;
            $i$a$-filter-KotlinMavenPluginPhaseInspection$checkFileElement$executions$1 = false;
            v5 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it");
            if (!KotlinMavenPluginPhaseInspectionKt.access$isKotlinMavenPlugin(v5)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (MavenPlugin)element$iv$iv;
            $i$a$-flatMap-KotlinMavenPluginPhaseInspection$checkFileElement$executions$2 = false;
            v6 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"it");
            list$iv$iv = v6.getExecutions();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        executions = (List)destination$iv$iv;
        $i$f$flatMap = executions;
        destination$iv = new HashSet<E>();
        $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            it = (MavenPlugin.Execution)element$iv;
            $i$a$-flatMapTo-KotlinMavenPluginPhaseInspection$checkFileElement$allGoalsSet$1 = false;
            v7 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"it");
            list$iv = v7.getGoals();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        allGoalsSet = (Set)destination$iv;
        hasJvmExecution = allGoalsSet.contains("compile") != false || allGoalsSet.contains("test-compile") != false;
        hasJsExecution = allGoalsSet.contains("js") != false || allGoalsSet.contains("test-js") != false;
        pomKotlinPlugins = pom.findKotlinPlugins();
        for (MavenDomPlugin kotlinPlugin : pomKotlinPlugins) {
            block39: {
                if (!allGoalsSet.contains("compile") && !allGoalsSet.contains("js")) {
                    if (hasJavaFiles) {
                        v8 = new AddExecutionLocalFix[1];
                        v9 = v8;
                        v10 = domFileElement.getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"domFileElement.file");
                        v11 = kotlinPlugin;
                        Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"kotlinPlugin");
                        v8[0] = new AddExecutionLocalFix(v10, module, v11, "compile");
                    } else {
                        v12 = new AddExecutionLocalFix[2];
                        v13 = domFileElement.getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"domFileElement.file");
                        v14 = kotlinPlugin;
                        Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"kotlinPlugin");
                        v12[0] = new AddExecutionLocalFix(v13, module, v14, "compile");
                        v9 = v12;
                        v15 = domFileElement.getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"domFileElement.file");
                        v12[1] = new AddExecutionLocalFix(v15, module, kotlinPlugin, "js");
                    }
                    fixes = v9;
                    v16 = fixes;
                    holder.createProblem(kotlinPlugin.getArtifactId().createStableCopy(), HighlightSeverity.WARNING, KotlinMavenBundle.message("inspection.no.executions", new Object[0]), Arrays.copyOf(v16, v16.length));
                    continue;
                }
                if (!hasJavaFiles) break block39;
                v17 = kotlinPlugin;
                Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"kotlinPlugin");
                $this$forEach$iv = KotlinMavenPluginPhaseInspectionKt.access$notAtPhase(pom.findExecutions(v17, new String[]{"compile"}), "process-sources");
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    block35: {
                        badExecution = (MavenDomPluginExecution)element$iv;
                        $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$1 = false;
                        javacPlugin /* !! */  = mavenProject.findPlugin("org.apache.maven.plugins", "maven-compiler-plugin");
                        v18 = pom.getDomModel().getBuild();
                        Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"pom.domModel.build");
                        v19 = v18.getPlugins();
                        Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"pom.domModel.build.plugins");
                        v20 = v19.getPlugins();
                        Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"pom.domModel.build.plugins.plugins");
                        $this$firstOrNull$iv = v20;
                        $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            it = (MavenDomPlugin)element$iv;
                            $i$a$-firstOrNull-KotlinMavenPluginPhaseInspection$checkFileElement$1$existingJavac$1 = false;
                            v21 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)v21, (String)"it");
                            v22 = v21.getGroupId();
                            Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"it.groupId");
                            if (!Intrinsics.areEqual((Object)v22.getStringValue(), (Object)"org.apache.maven.plugins")) ** GOTO lbl-1000
                            v23 = it.getArtifactId();
                            Intrinsics.checkNotNullExpressionValue((Object)v23, (String)"it.artifactId");
                            if (Intrinsics.areEqual((Object)v23.getStringValue(), (Object)"maven-compiler-plugin")) {
                                v24 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v24 = false;
                            }
                            if (!v24) continue;
                            v25 = element$iv;
                            break block35;
                        }
                        v25 = null;
                    }
                    if ((existingJavac /* !! */  = (MavenDomPlugin)v25) != null && pom.isPluginAfter(existingJavac /* !! */ , kotlinPlugin) && !pom.isExecutionEnabled(javacPlugin /* !! */ , "default-compile") && !pom.isExecutionEnabled(javacPlugin /* !! */ , "default-testCompile") && !pom.isPluginExecutionMissing(javacPlugin /* !! */ , "default-compile", "compile") && !pom.isPluginExecutionMissing(javacPlugin /* !! */ , "default-testCompile", "testCompile")) continue;
                    v26 = badExecution.getPhase().createStableCopy();
                    v27 = KotlinMavenBundle.message("inspection.should.run.before.javac", new Object[0]);
                    v28 = new LocalQuickFix[2];
                    v28[0] = new FixExecutionPhaseLocalFix(badExecution, "process-sources");
                    v29 = domFileElement.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)v29, (String)"domFileElement.file");
                    v28[1] = new AddJavaExecutionsLocalFix(module, v29, kotlinPlugin);
                    holder.createProblem(v26, HighlightSeverity.WARNING, v27, v28);
                }
                $this$forEach$iv = pom.findExecutions(kotlinPlugin, new String[]{"js", "test-js"});
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    block36: {
                        badExecution = (MavenDomPluginExecution)element$iv;
                        $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$2 = false;
                        v30 = badExecution;
                        Intrinsics.checkNotNullExpressionValue((Object)v30, (String)"badExecution");
                        v31 = v30.getGoals();
                        Intrinsics.checkNotNullExpressionValue((Object)v31, (String)"badExecution.goals");
                        v32 = v31.getGoals();
                        Intrinsics.checkNotNullExpressionValue((Object)v32, (String)"badExecution.goals.goals");
                        javacPlugin /* !! */  = v32;
                        $this$firstOrNull$iv = holder;
                        $i$f$first = false;
                        for (T element$iv : $this$first$iv) {
                            it = (MavenDomGoal)element$iv;
                            $i$a$-first-KotlinMavenPluginPhaseInspection$checkFileElement$2$1 = false;
                            v33 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)v33, (String)"it");
                            if (!KotlinMavenPluginPhaseInspectionKt.access$isJsGoal((MavenDomGoal)v33)) continue;
                            break block36;
                        }
                        throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    existingJavac /* !! */  = element$iv;
                    $this$firstOrNull$iv.createProblem(((MavenDomGoal)existingJavac /* !! */ ).createStableCopy(), HighlightSeverity.WARNING, KotlinMavenBundle.message("inspection.javascript.in.java.module", new Object[0]));
                }
            }
            if (hasJvmExecution && PomFile.findDependencies$default(pom, KotlinMavenPluginPhaseInspection.JVM_STDLIB_IDS, null, 2, null).isEmpty()) {
                Intrinsics.checkNotNullExpressionValue((Object)mavenProject.findDependencies("org.jetbrains.kotlin", "kotlin-stdlib"), (String)"mavenProject.findDepende\u2026ROUP_ID, MAVEN_STDLIB_ID)");
                if (stdlibDependencies.isEmpty()) {
                    v34 = kotlinPlugin;
                    Intrinsics.checkNotNullExpressionValue((Object)v34, (String)"kotlinPlugin");
                    v35 = v34.getArtifactId().createStableCopy();
                    v36 = KotlinMavenBundle.message("inspection.jvm.no.stdlib.dependency", new Object[]{"kotlin-stdlib"});
                    v37 = new LocalQuickFix[1];
                    v38 = domFileElement.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)v38, (String)"domFileElement.file");
                    v39 = kotlinPlugin.getVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)v39, (String)"kotlinPlugin.version");
                    v37[0] = new FixAddStdlibLocalFix(v38, "kotlin-stdlib", v39.getRawText());
                    holder.createProblem(v35, HighlightSeverity.WARNING, v36, v37);
                }
            }
            if (!hasJsExecution || !PomFile.findDependencies$default(pom, KotlinMavenPluginPhaseInspection.JVM_STDLIB_IDS, null, 2, null).isEmpty()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)mavenProject.findDependencies("org.jetbrains.kotlin", "kotlin-stdlib-js"), (String)"mavenProject.findDepende\u2026P_ID, MAVEN_JS_STDLIB_ID)");
            if (!jsDependencies.isEmpty()) continue;
            v40 = kotlinPlugin;
            Intrinsics.checkNotNullExpressionValue((Object)v40, (String)"kotlinPlugin");
            v41 = v40.getArtifactId().createStableCopy();
            v42 = KotlinMavenBundle.message("inspection.javascript.no.stdlib.dependency", new Object[]{"kotlin-stdlib-js"});
            v43 = new LocalQuickFix[1];
            v44 = domFileElement.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)v44, (String)"domFileElement.file");
            v45 = kotlinPlugin.getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)v45, (String)"kotlinPlugin.version");
            v43[0] = new FixAddStdlibLocalFix(v44, "kotlin-stdlib-js", v45.getRawText());
            holder.createProblem(v41, HighlightSeverity.WARNING, v42, v43);
        }
        jvmStdlibDependencies = PomFile.findDependencies$default(pom, KotlinMavenPluginPhaseInspection.JVM_STDLIB_IDS, null, 2, null);
        if (!hasJvmExecution) {
            element$iv = jvmStdlibDependencies;
            jsDependencies = false;
            if (element$iv.isEmpty() == false) {
                $this$forEach$iv = jvmStdlibDependencies;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    dep = (MavenDomDependency)element$iv;
                    $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$3 = false;
                    v46 = dep.getArtifactId().createStableCopy();
                    v47 = new Object[1];
                    v48 = dep.getArtifactId();
                    Intrinsics.checkNotNullExpressionValue((Object)v48, (String)"dep.artifactId");
                    v47[0] = v48;
                    v49 = KotlinMavenBundle.message("inspection.configured.no.execution", v47);
                    v50 = new LocalQuickFix[1];
                    v51 = domFileElement.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)v51, (String)"domFileElement.file");
                    v52 = dep.getVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)v52, (String)"dep.version");
                    v50[0] = new ConfigurePluginExecutionLocalFix(module, v51, "compile", v52.getRawText());
                    holder.createProblem(v46, HighlightSeverity.WARNING, v49, v50);
                }
            }
        }
        stdlibJsDependencies = PomFile.findDependencies$default(pom, KotlinMavenPluginPhaseInspection.JS_STDLIB_MAVEN_ID, null, 2, null);
        if (!hasJsExecution) {
            $i$f$forEach = stdlibJsDependencies;
            $i$f$forEach = false;
            if ($i$f$forEach.isEmpty() == false) {
                $this$forEach$iv = stdlibJsDependencies;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    dep = (MavenDomDependency)element$iv;
                    $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$4 = false;
                    v53 = dep.getArtifactId().createStableCopy();
                    v54 = new Object[1];
                    v55 = dep.getArtifactId();
                    Intrinsics.checkNotNullExpressionValue((Object)v55, (String)"dep.artifactId");
                    v54[0] = v55;
                    v56 = KotlinMavenBundle.message("inspection.configured.no.execution", v54);
                    v57 = new LocalQuickFix[1];
                    v58 = domFileElement.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)v58, (String)"domFileElement.file");
                    v59 = dep.getVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)v59, (String)"dep.version");
                    v57[0] = new ConfigurePluginExecutionLocalFix(module, v58, "js", v59.getRawText());
                    holder.createProblem(v53, HighlightSeverity.WARNING, v56, v57);
                }
            }
        }
        $this$filter$iv = pom.findKotlinExecutions();
        $i$f$filter = false;
        element$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block38: {
                block37: {
                    it = (MavenDomPluginExecution)element$iv$iv;
                    $i$a$-filter-KotlinMavenPluginPhaseInspection$checkFileElement$5 = false;
                    v60 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v60, (String)"it");
                    v61 = v60.getGoals();
                    Intrinsics.checkNotNullExpressionValue((Object)v61, (String)"it.goals");
                    v62 = v61.getGoals();
                    Intrinsics.checkNotNullExpressionValue((Object)v62, (String)"it.goals.goals");
                    $this$any$iv = v62;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v63 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            goal = (MavenDomGoal)element$iv;
                            $i$a$-any-KotlinMavenPluginPhaseInspection$checkFileElement$5$1 = false;
                            v64 = goal;
                            Intrinsics.checkNotNullExpressionValue((Object)v64, (String)"goal");
                            if (!(Intrinsics.areEqual((Object)v64.getRawText(), (Object)"compile") != false || Intrinsics.areEqual((Object)goal.getRawText(), (Object)"js") != false)) continue;
                            v63 = true;
                            break block37;
                        }
                        v63 = false;
                    }
                }
                if (!v63) ** GOTO lbl-1000
                v65 = it.getGoals();
                Intrinsics.checkNotNullExpressionValue((Object)v65, (String)"it.goals");
                v66 = v65.getGoals();
                Intrinsics.checkNotNullExpressionValue((Object)v66, (String)"it.goals.goals");
                $this$any$iv = v66;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v67 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        goal = (MavenDomGoal)element$iv;
                        $i$a$-any-KotlinMavenPluginPhaseInspection$checkFileElement$5$2 = false;
                        v68 = goal;
                        Intrinsics.checkNotNullExpressionValue((Object)v68, (String)"goal");
                        if (!(Intrinsics.areEqual((Object)v68.getRawText(), (Object)"test-compile") != false || Intrinsics.areEqual((Object)goal.getRawText(), (Object)"test-js") != false)) continue;
                        v67 = true;
                        break block38;
                    }
                    v67 = false;
                }
            }
            if (v67) {
                v69 = true;
            } else lbl-1000:
            // 2 sources

            {
                v69 = false;
            }
            if (!v69) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            badExecution = (MavenDomPluginExecution)element$iv;
            $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$6 = false;
            v70 = badExecution;
            Intrinsics.checkNotNullExpressionValue((Object)v70, (String)"badExecution");
            holder.createProblem(v70.getGoals().createStableCopy(), HighlightSeverity.WEAK_WARNING, KotlinMavenBundle.message("inspection.same.execution.compile.test", new Object[0]));
        }
    }

    public KotlinMavenPluginPhaseInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Iterable $this$map$iv = IdePlatformKindToolingKt.getTooling((IdePlatformKind)((IdePlatformKind)JvmIdePlatformKind.INSTANCE)).getMavenLibraryIds();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            MavenId mavenId = new MavenId("org.jetbrains.kotlin", (String)it, null);
            collection.add(mavenId);
        }
        JVM_STDLIB_IDS = (List)var3_3;
        JS_STDLIB_MAVEN_ID = new MavenId("org.jetbrains.kotlin", "kotlin-stdlib-js", null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$AddExecutionLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "file", "Lcom/intellij/psi/xml/XmlFile;", "module", "Lcom/intellij/openapi/module/Module;", "kotlinPlugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "goal", "", "(Lcom/intellij/psi/xml/XmlFile;Lcom/intellij/openapi/module/Module;Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;Ljava/lang/String;)V", "getGoal", "()Ljava/lang/String;", "getKotlinPlugin", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "getModule", "()Lcom/intellij/openapi/module/Module;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.maven"})
    private static final class AddExecutionLocalFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<XmlFile> pointer;
        @NotNull
        private final Module module;
        @NotNull
        private final MavenDomPlugin kotlinPlugin;
        @NotNull
        private final String goal;

        @NotNull
        public String getName() {
            return KotlinMavenBundle.message("fix.add.execution.name", this.goal);
        }

        @NotNull
        public String getFamilyName() {
            return KotlinMavenBundle.message("fix.add.execution.family", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                XmlFile xmlFile = (XmlFile)this.pointer.getElement();
                if (xmlFile == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"pointer.element ?: return");
                XmlFile file = xmlFile;
                PomFile pomFile = PomFile.Companion.forFileOrNull(file);
                if (pomFile == null) break block1;
                pomFile.addKotlinExecution(this.module, this.kotlinPlugin, this.goal, PomFile.Companion.getPhase(KotlinMavenPluginPhaseInspectionKt.hasJavaFiles(this.module), false), false, CollectionsKt.listOf((Object)this.goal));
            }
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final MavenDomPlugin getKotlinPlugin() {
            return this.kotlinPlugin;
        }

        @NotNull
        public final String getGoal() {
            return this.goal;
        }

        public AddExecutionLocalFix(@NotNull XmlFile file, @NotNull Module module, @NotNull MavenDomPlugin kotlinPlugin, @NotNull String goal) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)kotlinPlugin, (String)"kotlinPlugin");
            Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
            this.module = module;
            this.kotlinPlugin = kotlinPlugin;
            this.goal = goal;
            this.pointer = PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)file));
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$FixExecutionPhaseLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "execution", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPluginExecution;", "newPhase", "", "(Lorg/jetbrains/idea/maven/dom/model/MavenDomPluginExecution;Ljava/lang/String;)V", "getExecution", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomPluginExecution;", "getNewPhase", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.maven"})
    private static final class FixExecutionPhaseLocalFix
    implements LocalQuickFix {
        @NotNull
        private final MavenDomPluginExecution execution;
        @NotNull
        private final String newPhase;

        @NotNull
        public String getName() {
            return KotlinMavenBundle.message("fix.execution.phase.name", this.newPhase);
        }

        @NotNull
        public String getFamilyName() {
            return KotlinMavenBundle.message("fix.execution.phase.family", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            GenericDomValue genericDomValue = this.execution.getPhase();
            Intrinsics.checkNotNullExpressionValue((Object)genericDomValue, (String)"execution.phase");
            genericDomValue.setValue((Object)this.newPhase);
        }

        @NotNull
        public final MavenDomPluginExecution getExecution() {
            return this.execution;
        }

        @NotNull
        public final String getNewPhase() {
            return this.newPhase;
        }

        public FixExecutionPhaseLocalFix(@NotNull MavenDomPluginExecution execution, @NotNull String newPhase) {
            Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
            Intrinsics.checkNotNullParameter((Object)newPhase, (String)"newPhase");
            this.execution = execution;
            this.newPhase = newPhase;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$AddJavaExecutionsLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/xml/XmlFile;", "kotlinPlugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/xml/XmlFile;Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;)V", "getKotlinPlugin", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "getModule", "()Lcom/intellij/openapi/module/Module;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.maven"})
    private static final class AddJavaExecutionsLocalFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<XmlFile> pointer;
        @NotNull
        private final Module module;
        @NotNull
        private final MavenDomPlugin kotlinPlugin;

        @NotNull
        public String getName() {
            return KotlinMavenBundle.message("fix.add.java.executions.name", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                XmlFile xmlFile = (XmlFile)this.pointer.getElement();
                if (xmlFile == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"pointer.element ?: return");
                XmlFile file = xmlFile;
                PomFile pomFile = PomFile.Companion.forFileOrNull(file);
                if (pomFile == null) break block1;
                pomFile.addJavacExecutions(this.module, this.kotlinPlugin);
            }
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final MavenDomPlugin getKotlinPlugin() {
            return this.kotlinPlugin;
        }

        public AddJavaExecutionsLocalFix(@NotNull Module module, @NotNull XmlFile file, @NotNull MavenDomPlugin kotlinPlugin) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)kotlinPlugin, (String)"kotlinPlugin");
            this.module = module;
            this.kotlinPlugin = kotlinPlugin;
            this.pointer = PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)file));
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$FixAddStdlibLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "pomFile", "Lcom/intellij/psi/xml/XmlFile;", "id", "", "version", "(Lcom/intellij/psi/xml/XmlFile;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getVersion", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.maven"})
    private static final class FixAddStdlibLocalFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<XmlFile> pointer;
        @NotNull
        private final String id;
        @Nullable
        private final String version;

        @NotNull
        public String getName() {
            return KotlinMavenBundle.message("fix.add.stdlib.name", this.id);
        }

        @NotNull
        public String getFamilyName() {
            return KotlinMavenBundle.message("fix.add.stdlib.family", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                XmlFile xmlFile = (XmlFile)this.pointer.getElement();
                if (xmlFile == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"pointer.element ?: return");
                XmlFile file = xmlFile;
                PomFile pomFile = PomFile.Companion.forFileOrNull(file);
                if (pomFile == null) break block1;
                PomFile.addDependency$default(pomFile, new MavenId("org.jetbrains.kotlin", this.id, this.version), MavenArtifactScope.COMPILE, null, false, null, 28, null);
            }
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        public FixAddStdlibLocalFix(@NotNull XmlFile pomFile, @NotNull String id, @Nullable String version) {
            Intrinsics.checkNotNullParameter((Object)pomFile, (String)"pomFile");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
            this.version = version;
            this.pointer = PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)pomFile));
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$ConfigurePluginExecutionLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "module", "Lcom/intellij/openapi/module/Module;", "xmlFile", "Lcom/intellij/psi/xml/XmlFile;", "goal", "", "version", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/xml/XmlFile;Ljava/lang/String;Ljava/lang/String;)V", "getGoal", "()Ljava/lang/String;", "getModule", "()Lcom/intellij/openapi/module/Module;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getVersion", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.maven"})
    private static final class ConfigurePluginExecutionLocalFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<XmlFile> pointer;
        @NotNull
        private final Module module;
        @NotNull
        private final String goal;
        @Nullable
        private final String version;

        @NotNull
        public String getName() {
            return KotlinMavenBundle.message("fix.configure.plugin.execution.name", this.goal);
        }

        @NotNull
        public String getFamilyName() {
            return KotlinMavenBundle.message("fix.configure.plugin.execution.family", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                XmlFile xmlFile = (XmlFile)this.pointer.getElement();
                if (xmlFile == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"pointer.element ?: return");
                XmlFile file = xmlFile;
                PomFile pomFile = PomFile.Companion.forFileOrNull(file);
                if (pomFile == null) break block1;
                PomFile pomFile2 = pomFile;
                boolean bl = false;
                boolean bl2 = false;
                PomFile pom = pomFile2;
                boolean bl3 = false;
                MavenDomPlugin plugin = pom.addKotlinPlugin(this.version);
                pom.addKotlinExecution(this.module, plugin, "compile", PomFile.Companion.getPhase(KotlinMavenPluginPhaseInspectionKt.hasJavaFiles(this.module), false), false, CollectionsKt.listOf((Object)this.goal));
            }
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final String getGoal() {
            return this.goal;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        public ConfigurePluginExecutionLocalFix(@NotNull Module module, @NotNull XmlFile xmlFile, @NotNull String goal, @Nullable String version) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
            Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
            this.module = module;
            this.goal = goal;
            this.version = version;
            this.pointer = PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)xmlFile));
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$Companion;", "", "()V", "JS_STDLIB_MAVEN_ID", "Lorg/jetbrains/idea/maven/model/MavenId;", "JVM_STDLIB_IDS", "", "kotlin.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

