/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.editor.PropertyStructureViewElement;
import com.intellij.lang.properties.structureView.PropertiesPrefixGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupByWordPrefixes
implements Grouper,
Sorter {
    private static final Logger LOG = Logger.getInstance(GroupByWordPrefixes.class);
    @NonNls
    public static final String ID = "GROUP_BY_PREFIXES";
    private String mySeparator;

    public GroupByWordPrefixes(String separator) {
        this.mySeparator = separator;
    }

    public void setSeparator(String separator) {
        this.mySeparator = separator;
    }

    public String getSeparator() {
        return this.mySeparator;
    }

    @NotNull
    public Collection<Group> group(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<TreeElement> children) {
        int parentPrefixLength;
        String parentPrefix;
        if (parent == null) {
            GroupByWordPrefixes.$$$reportNull$$$0(0);
        }
        if (children == null) {
            GroupByWordPrefixes.$$$reportNull$$$0(1);
        }
        ArrayList<Key> keys = new ArrayList<Key>();
        if (parent.getValue() instanceof PropertiesPrefixGroup) {
            parentPrefix = ((PropertiesPrefixGroup)parent.getValue()).getPrefix();
            parentPrefixLength = StringUtil.split((String)parentPrefix, (String)this.mySeparator).size();
        } else {
            parentPrefix = "";
            parentPrefixLength = 0;
        }
        for (TreeElement element : children) {
            boolean expected;
            String text = GroupByWordPrefixes.getPropertyUnescapedKey(element);
            if (text == null) continue;
            boolean bl = expected = text.startsWith(parentPrefix) || text.startsWith(this.mySeparator);
            if (!expected) {
                LOG.error("unexpected text: " + text + "; parentPrefix=" + parentPrefix + "; mySeparator=" + this.mySeparator);
            }
            List words = StringUtil.split((String)text, (String)this.mySeparator);
            keys.add(new Key(words, element));
        }
        keys.sort((k1, k2) -> {
            List<String> o1 = k1.words;
            List<String> o2 = k2.words;
            for (int i = 0; i < Math.max(o1.size(), o2.size()); ++i) {
                String s2;
                if (i == o1.size()) {
                    return 1;
                }
                if (i == o2.size()) {
                    return -1;
                }
                String s1 = o1.get(i);
                int res = s1.compareTo(s2 = o2.get(i));
                if (res == 0) continue;
                return res;
            }
            return 0;
        });
        ArrayList<Group> groups = new ArrayList<Group>();
        int groupStart = 0;
        for (int i = 0; i <= keys.size(); ++i) {
            if (!GroupByWordPrefixes.isEndOfGroup(i, keys, parentPrefixLength)) continue;
            List firstKey = groupStart == keys.size() ? Collections.emptyList() : ((Key)keys.get((int)groupStart)).words;
            SmartList groupChildren = new SmartList();
            groupChildren.add(((Key)keys.get((int)groupStart)).node);
            int prefixLen = firstKey.size();
            for (int j = groupStart + 1; j < i; ++j) {
                List<String> prevKey = ((Key)keys.get((int)(j - 1))).words;
                List<String> nextKey = ((Key)keys.get((int)j)).words;
                for (int k = parentPrefixLength; k < prefixLen; ++k) {
                    String wordInPrevKey;
                    String word = k < nextKey.size() ? nextKey.get(k) : null;
                    String string = wordInPrevKey = k < prevKey.size() ? prevKey.get(k) : null;
                    if (Comparing.strEqual((String)word, (String)wordInPrevKey)) continue;
                    prefixLen = k;
                    break;
                }
                groupChildren.add(((Key)keys.get((int)j)).node);
            }
            String[] strings = firstKey.subList(0, prefixLen).toArray(new String[prefixLen]);
            String prefix = StringUtil.join((String[])strings, (String)this.mySeparator);
            String presentableName = prefix.substring(parentPrefix.length());
            presentableName = StringUtil.trimStart((String)presentableName, (String)this.mySeparator);
            if (i - groupStart > 1) {
                groups.add(new PropertiesPrefixGroup((Collection<TreeElement>)groupChildren, prefix, presentableName, this.mySeparator));
            } else if (groupStart != keys.size()) {
                TreeElement node = ((Key)keys.get((int)groupStart)).node;
                ((PropertyStructureViewElement)node).setPresentableName(presentableName);
            }
            groupStart = i;
        }
        ArrayList<Group> arrayList = groups;
        if (arrayList == null) {
            GroupByWordPrefixes.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static boolean isEndOfGroup(int i, List<Key> keys, int parentPrefixLength) {
        if (i == keys.size()) {
            return true;
        }
        if (i == 0) {
            return false;
        }
        List<String> words = keys.get((int)i).words;
        List<String> prevWords = keys.get((int)(i - 1)).words;
        if (prevWords.size() == parentPrefixLength) {
            return true;
        }
        if (words.size() == parentPrefixLength) {
            return true;
        }
        return !Comparing.strEqual((String)words.get(parentPrefixLength), (String)prevWords.get(parentPrefixLength));
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(PropertiesBundle.message("structure.view.group.by.prefixes.action.name", new Object[0]), PropertiesBundle.message("structure.view.group.by.prefixes.action.description", new Object[0]), AllIcons.Actions.GroupByPrefix);
    }

    @NotNull
    public String getName() {
        return ID;
    }

    @NotNull
    public Comparator getComparator() {
        Comparator comparator = Sorter.ALPHA_SORTER.getComparator();
        if (comparator == null) {
            GroupByWordPrefixes.$$$reportNull$$$0(3);
        }
        return comparator;
    }

    public boolean isVisible() {
        return true;
    }

    @Nullable
    static String getPropertyUnescapedKey(@NotNull TreeElement element) {
        if (element == null) {
            GroupByWordPrefixes.$$$reportNull$$$0(4);
        }
        if (!(element instanceof StructureViewTreeElement)) {
            return null;
        }
        Object value = ((StructureViewTreeElement)element).getValue();
        if (!(value instanceof IProperty)) {
            return null;
        }
        return ((IProperty)value).getUnescapedKey();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/structureView/GroupByWordPrefixes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/structureView/GroupByWordPrefixes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "group";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "group";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyUnescapedKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Key {
        final List<String> words;
        final TreeElement node;

        Key(List<String> words, TreeElement node) {
            this.words = words;
            this.node = node;
        }

        public String toString() {
            return "Key{words=" + this.words + ", node=" + this.node + "}";
        }
    }
}

