/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.languagetool.rules.ConfusionString;
import org.languagetool.rules.ScoredConfusionSet;

public class ScoredConfusionSetLoader {
    private static final String CHARSET = "utf-8";

    private ScoredConfusionSetLoader() {
    }

    public static List<ScoredConfusionSet> loadConfusionSet(InputStream stream) throws IOException {
        ArrayList<ScoredConfusionSet> list = new ArrayList<ScoredConfusionSet>();
        try (InputStreamReader reader = new InputStreamReader(stream, CHARSET);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                if (ScoredConfusionSetLoader.ignoreLine(line)) continue;
                String[] parts = ScoredConfusionSetLoader.splitLine(line);
                List<ConfusionString> confusionStrings = ScoredConfusionSetLoader.getConfusionStrings(parts);
                list.add(ScoredConfusionSetLoader.toScoredConfusionSet(parts, confusionStrings));
            }
        }
        return list;
    }

    @NotNull
    private static ScoredConfusionSet toScoredConfusionSet(String[] parts, List<ConfusionString> confusionStrings) {
        return new ScoredConfusionSet(Float.parseFloat(parts[parts.length - 1]), confusionStrings);
    }

    private static String[] splitLine(String line) {
        String[] parts = line.replaceFirst("\\s*#.*", "").split(";\\s*");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Unexpected format: '" + line + "' - expected three semicolon-separated values: word1; word2; factor");
        }
        return parts;
    }

    private static List<ConfusionString> getConfusionStrings(String[] parts) {
        ArrayList<ConfusionString> confusionStrings = new ArrayList<ConfusionString>();
        HashSet<String> loadedForSet = new HashSet<String>();
        for (String part : Arrays.asList(parts).subList(0, parts.length - 1)) {
            String description;
            String[] subParts = part.split("\\|");
            String word = subParts[0];
            String string = description = subParts.length == 2 ? subParts[1] : null;
            if (loadedForSet.contains(word)) {
                throw new IllegalArgumentException("Word appears twice in same confusion set: '" + word + "'");
            }
            confusionStrings.add(new ConfusionString(word, description));
            loadedForSet.add(word);
        }
        return confusionStrings;
    }

    private static boolean ignoreLine(String line) {
        return line.startsWith("#") || line.trim().isEmpty();
    }
}

