/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import com.google.protobuf.ProtocolStringList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.rules.GRPCRule;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.ml.MLServerProto;
import org.languagetool.tools.Tools;

public class GRPCConfusionRule
extends GRPCRule {
    public GRPCConfusionRule(ResourceBundle messages, RemoteRuleConfig config) {
        super(messages, config);
    }

    @Override
    protected String getMessage(MLServerProto.Match match, AnalyzedSentence sentence) {
        String matched = sentence.getText().substring(match.getOffset(), match.getOffset() + match.getLength());
        ProtocolStringList suggestions = match.getSuggestionsList();
        if (suggestions == null || suggestions.isEmpty()) {
            return Tools.i18n(this.messages, "confpairs_rule_message_no_suggestion", matched);
        }
        if (suggestions.size() == 1) {
            return Tools.i18n(this.messages, "confpairs_rule_message_one_suggestion", matched, suggestions.get(0));
        }
        return Tools.i18n(this.messages, "confpairs_rule_message_more_suggestions", matched);
    }

    @Override
    public String getDescription() {
        return this.messages.getString("confpairs_rule_description");
    }
}

