/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.GrowPolicy;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import java.awt.Component;
import java.net.UnknownHostException;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.ui.GHCredentialsUi;
import org.jetbrains.plugins.github.authentication.ui.GHPasswordCredentialsUi;
import org.jetbrains.plugins.github.authentication.ui.LoginNotUniqueException;
import org.jetbrains.plugins.github.authentication.util.GHAccessTokenCreator;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubParseException;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.util.DialogValidationUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012:\u0010\u0006\u001a6\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\u0007j\u0002`\u000f\u00a2\u0006\u0002\u0010\u0010J,\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00162\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0014\u0010\u001f\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010!0 j\u0002`\"H\u0016J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000eH\u0016J\u0018\u0010)\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010*\u001a\u00020\u000eJ\u000e\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020\bJ\f\u0010-\u001a\u00020'*\u00020.H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0006\u001a6\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\u0007j\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GHPasswordCredentialsUi;", "Lorg/jetbrains/plugins/github/authentication/ui/GHCredentialsUi;", "serverTextField", "Lcom/intellij/ui/components/fields/ExtendableTextField;", "executorFactory", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "isAccountUnique", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "login", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "server", "", "Lorg/jetbrains/plugins/github/authentication/ui/UniqueLoginPredicate;", "(Lcom/intellij/ui/components/fields/ExtendableTextField;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;Lkotlin/jvm/functions/Function2;)V", "loginTextField", "Lcom/intellij/ui/components/JBTextField;", "passwordField", "Ljavax/swing/JPasswordField;", "acquireLoginAndToken", "Lkotlin/Pair;", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$WithBasicAuth;", "getPreferredFocusableComponent", "Ljavax/swing/JComponent;", "getValidator", "Lkotlin/Function0;", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lorg/jetbrains/plugins/github/ui/util/Validator;", "handleAcquireError", "error", "", "setBusy", "", "busy", "setLogin", "editable", "setPassword", "password", "centerPanel", "Lcom/intellij/ui/layout/LayoutBuilder;", "intellij.vcs.github"})
public final class GHPasswordCredentialsUi
extends GHCredentialsUi {
    private final JBTextField loginTextField;
    private final JPasswordField passwordField;
    private final ExtendableTextField serverTextField;
    private final GithubApiRequestExecutor.Factory executorFactory;
    private final Function2<String, GithubServerPath, Boolean> isAccountUnique;

    public final void setLogin(@NotNull String login2, boolean editable) {
        Intrinsics.checkNotNullParameter((Object)login2, (String)"login");
        this.loginTextField.setText(login2);
        this.loginTextField.setEditable(editable);
    }

    public static /* synthetic */ void setLogin$default(GHPasswordCredentialsUi gHPasswordCredentialsUi, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        gHPasswordCredentialsUi.setLogin(string, bl);
    }

    public final void setPassword(@NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.passwordField.setText(password);
    }

    @Override
    protected void centerPanel(@NotNull LayoutBuilder $this$centerPanel) {
        Intrinsics.checkNotNullParameter((Object)$this$centerPanel, (String)"$this$centerPanel");
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$centerPanel), (String)GithubBundle.message("credentials.server.field", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ GHPasswordCredentialsUi this$0;

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)((JComponent)GHPasswordCredentialsUi.access$getServerTextField$p(this.this$0)), (CCFlags[])new CCFlags[]{$this$row.getPushX(), $this$row.getGrowX()}, null, null, (int)6, null);
            }
            {
                this.this$0 = gHPasswordCredentialsUi;
                super(1);
            }
        }), (int)2, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$centerPanel), (String)GithubBundle.message("credentials.login.field", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ GHPasswordCredentialsUi this$0;

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)((JComponent)GHPasswordCredentialsUi.access$getLoginTextField$p(this.this$0)), (CCFlags[])new CCFlags[]{$this$row.getPushX(), $this$row.getGrowX()}, null, null, (int)6, null);
            }
            {
                this.this$0 = gHPasswordCredentialsUi;
                super(1);
            }
        }), (int)2, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$centerPanel), (String)GithubBundle.message("credentials.password.field", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ GHPasswordCredentialsUi this$0;

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                CCFlags[] cCFlagsArray = new CCFlags[]{$this$row.getPushX(), $this$row.getGrowX()};
                GrowPolicy growPolicy = null;
                String string = GithubBundle.message("credentials.password.not.saved", new Object[0]);
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)GHPasswordCredentialsUi.access$getPasswordField$p(this.this$0), (CCFlags[])cCFlagsArray, growPolicy, (String)string, (int)2, null);
            }
            {
                this.this$0 = gHPasswordCredentialsUi;
                super(1);
            }
        }), (int)2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public JComponent getPreferredFocusableComponent() {
        JComponent jComponent;
        if (this.loginTextField.isEditable()) {
            String string = this.loginTextField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loginTextField.text");
            CharSequence charSequence = string;
            boolean bl = false;
            if (charSequence.length() == 0) {
                jComponent = (JComponent)this.loginTextField;
                return jComponent;
            }
        }
        jComponent = this.passwordField;
        return jComponent;
    }

    @Override
    @NotNull
    public Function0<ValidationInfo> getValidator() {
        return DialogValidationUtils.INSTANCE.chain((Function0)new Function0<ValidationInfo>(this){
            final /* synthetic */ GHPasswordCredentialsUi this$0;

            @Nullable
            public final ValidationInfo invoke() {
                JTextField jTextField = (JTextField)GHPasswordCredentialsUi.access$getLoginTextField$p(this.this$0);
                String string = GithubBundle.message("credentials.login.cannot.be.empty", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"credentials.login.cannot.be.empty\")");
                return DialogValidationUtils.INSTANCE.notBlank(jTextField, string);
            }
            {
                this.this$0 = gHPasswordCredentialsUi;
                super(0);
            }
        }, (Function0)new Function0<ValidationInfo>(this){
            final /* synthetic */ GHPasswordCredentialsUi this$0;

            @Nullable
            public final ValidationInfo invoke() {
                JTextField jTextField = GHPasswordCredentialsUi.access$getPasswordField$p(this.this$0);
                String string = GithubBundle.message("credentials.password.cannot.be.empty", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"credentials.password.cannot.be.empty\")");
                return DialogValidationUtils.INSTANCE.notBlank(jTextField, string);
            }
            {
                this.this$0 = gHPasswordCredentialsUi;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public GithubApiRequestExecutor.WithBasicAuth createExecutor() {
        ModalityState modalityState = ModalityState.stateForComponent((Component)this.passwordField);
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.stateForComponent(passwordField)");
        ModalityState modalityState2 = modalityState;
        String string = this.loginTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loginTextField.text");
        char[] cArray = this.passwordField.getPassword();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"passwordField.password");
        return this.executorFactory.create$intellij_vcs_github(string, cArray, new Supplier<String>(this, modalityState2){
            final /* synthetic */ GHPasswordCredentialsUi this$0;
            final /* synthetic */ ModalityState $modalityState;

            @Nullable
            public final String get() {
                return (String)ActionsKt.invokeAndWaitIfNeeded((ModalityState)this.$modalityState, (Function0)((Function0)new Function0<String>(this){
                    final /* synthetic */ createExecutor.1 this$0;

                    @Nullable
                    public final String invoke() {
                        return Messages.showInputDialog((Component)GHPasswordCredentialsUi.access$getPasswordField$p(this.this$0.this$0), (String)GithubBundle.message("credentials.2fa.dialog.code.field", new Object[0]), (String)GithubBundle.message("credentials.2fa.dialog.title", new Object[0]), null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = gHPasswordCredentialsUi;
                this.$modalityState = modalityState;
            }
        });
    }

    @Override
    @NotNull
    public Pair<String, String> acquireLoginAndToken(@NotNull GithubServerPath server, @NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        String string = this.loginTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loginTextField.text");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String login2 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        if (!((Boolean)this.isAccountUnique.invoke((Object)login2, (Object)server)).booleanValue()) {
            throw (Throwable)new LoginNotUniqueException(login2);
        }
        String string4 = new GHAccessTokenCreator(server, executor, indicator).createMaster("Github Integration Plugin").getToken();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"GHAccessTokenCreator(ser\u2026EFAULT_CLIENT_NAME).token");
        String token = string4;
        return TuplesKt.to((Object)login2, (Object)token);
    }

    @Override
    @NotNull
    public ValidationInfo handleAcquireError(@NotNull Throwable error) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Throwable throwable = error;
        if (throwable instanceof LoginNotUniqueException) {
            ValidationInfo validationInfo2 = new ValidationInfo(GithubBundle.message("login.account.already.added", this.loginTextField.getText()), (JComponent)this.loginTextField).withOKEnabled();
            validationInfo = validationInfo2;
            Intrinsics.checkNotNullExpressionValue((Object)validationInfo2, (String)"ValidationInfo(message(\"\u2026extField).withOKEnabled()");
        } else if (throwable instanceof UnknownHostException) {
            ValidationInfo validationInfo3 = new ValidationInfo(GithubBundle.message("server.unreachable", new Object[0])).withOKEnabled();
            validationInfo = validationInfo3;
            Intrinsics.checkNotNullExpressionValue((Object)validationInfo3, (String)"ValidationInfo(message(\"\u2026chable\")).withOKEnabled()");
        } else if (throwable instanceof GithubAuthenticationException) {
            Object[] objectArray = new Object[1];
            String string = error.getMessage();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                string2 = "";
            }
            objectArray[0] = string2;
            ValidationInfo validationInfo4 = new ValidationInfo(GithubBundle.message("credentials.incorrect", objectArray)).withOKEnabled();
            validationInfo = validationInfo4;
            Intrinsics.checkNotNullExpressionValue((Object)validationInfo4, (String)"ValidationInfo(message(\"\u2026Empty())).withOKEnabled()");
        } else if (throwable instanceof GithubParseException) {
            String string = error.getMessage();
            if (string == null) {
                String string3 = GithubBundle.message("credentials.invalid.server.path", new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"credentials.invalid.server.path\")");
            }
            validationInfo = new ValidationInfo(string, (JComponent)this.serverTextField);
        } else {
            Object[] objectArray = new Object[1];
            String string = error.getMessage();
            boolean bl = false;
            String string4 = string;
            if (string4 == null) {
                string4 = "";
            }
            objectArray[0] = string4;
            ValidationInfo validationInfo5 = new ValidationInfo(GithubBundle.message("credentials.invalid.auth.data", objectArray)).withOKEnabled();
            validationInfo = validationInfo5;
            Intrinsics.checkNotNullExpressionValue((Object)validationInfo5, (String)"ValidationInfo(message(\"\u2026Empty())).withOKEnabled()");
        }
        return validationInfo;
    }

    @Override
    public void setBusy(boolean busy) {
        this.loginTextField.setEnabled(!busy);
        this.passwordField.setEnabled(!busy);
    }

    public GHPasswordCredentialsUi(@NotNull ExtendableTextField serverTextField, @NotNull GithubApiRequestExecutor.Factory executorFactory, @NotNull Function2<? super String, ? super GithubServerPath, Boolean> isAccountUnique) {
        Intrinsics.checkNotNullParameter((Object)serverTextField, (String)"serverTextField");
        Intrinsics.checkNotNullParameter((Object)executorFactory, (String)"executorFactory");
        Intrinsics.checkNotNullParameter(isAccountUnique, (String)"isAccountUnique");
        this.serverTextField = serverTextField;
        this.executorFactory = executorFactory;
        this.isAccountUnique = isAccountUnique;
        this.loginTextField = new JBTextField();
        this.passwordField = new JPasswordField();
    }

    public static final /* synthetic */ ExtendableTextField access$getServerTextField$p(GHPasswordCredentialsUi $this) {
        return $this.serverTextField;
    }

    public static final /* synthetic */ JBTextField access$getLoginTextField$p(GHPasswordCredentialsUi $this) {
        return $this.loginTextField;
    }

    public static final /* synthetic */ JPasswordField access$getPasswordField$p(GHPasswordCredentialsUi $this) {
        return $this.passwordField;
    }
}

