/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.ActionType;
import org.jetbrains.idea.devkit.util.ComponentType;

public final class DescriptorUtil {
    private DescriptorUtil() {
    }

    public static void processComponents(XmlTag root, ComponentType.Processor processor) {
        ComponentType[] types;
        for (ComponentType type : types = ComponentType.values()) {
            type.process(root, processor);
        }
    }

    public static void processActions(XmlTag root, ActionType.Processor processor) {
        ActionType[] types;
        for (ActionType type : types = ActionType.values()) {
            type.process(root, processor);
        }
    }

    public static void patchPluginXml(Patcher patcher, PsiClass klass, XmlFile pluginXml) throws IncorrectOperationException {
        DescriptorUtil.checkPluginXmlsWritable(klass.getProject(), pluginXml);
        WriteAction.run(() -> patcher.patchPluginXml(pluginXml, klass));
    }

    public static void checkPluginXmlsWritable(Project project, XmlFile pluginXml) {
        VirtualFile file = pluginXml.getVirtualFile();
        ReadonlyStatusHandler readonlyStatusHandler = ReadonlyStatusHandler.getInstance((Project)project);
        ReadonlyStatusHandler.OperationStatus status = readonlyStatusHandler.ensureFilesWritable(Collections.singletonList(file));
        if (status.hasReadonlyFiles()) {
            throw new IncorrectOperationException(DevKitBundle.message("error.plugin.xml.readonly", status.getReadonlyFiles()[0]));
        }
    }

    public static List<String> getPluginAndOptionalDependenciesIds(Module module) {
        XmlFile xml = PluginModuleType.getPluginXml(module);
        if (xml == null) {
            return Collections.emptyList();
        }
        IdeaPlugin plugin = DescriptorUtil.getIdeaPlugin(xml);
        if (plugin == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        ContainerUtil.addIfNotNull(result, (Object)plugin.getPluginId());
        for (Dependency dependency : plugin.getDependencies()) {
            if (!Boolean.TRUE.equals(dependency.getOptional().getValue())) continue;
            ContainerUtil.addIfNotNull(result, (Object)dependency.getRawText());
        }
        return result;
    }

    public static boolean isPluginXml(@Nullable PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        return DescriptorUtil.getIdeaPluginFileElement((XmlFile)file) != null;
    }

    @Nullable
    public static DomFileElement<IdeaPlugin> getIdeaPluginFileElement(@NotNull XmlFile file) {
        if (file == null) {
            DescriptorUtil.$$$reportNull$$$0(0);
        }
        return DomManager.getDomManager((Project)file.getProject()).getFileElement(file, IdeaPlugin.class);
    }

    @Nullable
    public static IdeaPlugin getIdeaPlugin(@NotNull XmlFile file) {
        DomFileElement<IdeaPlugin> plugin;
        if (file == null) {
            DescriptorUtil.$$$reportNull$$$0(1);
        }
        return (plugin = DescriptorUtil.getIdeaPluginFileElement(file)) != null ? (IdeaPlugin)plugin.getRootElement() : null;
    }

    @NotNull
    public static Collection<IdeaPlugin> getPlugins(Project project, GlobalSearchScope scope) {
        if (DumbService.isDumb((Project)project)) {
            List<IdeaPlugin> list = Collections.emptyList();
            if (list == null) {
                DescriptorUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        List files = DomService.getInstance().getFileElements(IdeaPlugin.class, project, scope);
        List list = ContainerUtil.map((Collection)files, ideaPluginDomFileElement -> (IdeaPlugin)ideaPluginDomFileElement.getRootElement());
        if (list == null) {
            DescriptorUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/util/DescriptorUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/util/DescriptorUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIdeaPluginFileElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIdeaPlugin";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Patcher {
        public void patchPluginXml(XmlFile var1, PsiClass var2) throws IncorrectOperationException;
    }
}

