/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.index.ExtensionPointIndex;
import org.jetbrains.idea.devkit.references.PluginConfigReference;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;
import org.jetbrains.idea.devkit.util.PluginRelatedLocatorsUtils;

abstract class ExtensionPointReferenceBase
extends PsiReferenceBase<PsiElement>
implements PluginConfigReference {
    protected ExtensionPointReferenceBase(@NotNull PsiElement element) {
        if (element == null) {
            ExtensionPointReferenceBase.$$$reportNull$$$0(0);
        }
        super(element);
    }

    protected ExtensionPointReferenceBase(@NotNull PsiElement element, TextRange rangeInElement) {
        if (element == null) {
            ExtensionPointReferenceBase.$$$reportNull$$$0(1);
        }
        super(element, rangeInElement);
    }

    protected abstract String getExtensionPointFqn();

    protected GenericAttributeValue<?> getNameElement(Extension extension) {
        return extension.getId();
    }

    protected boolean hasCustomNameElement() {
        return false;
    }

    @Nullable
    public PsiElement resolve() {
        final String resolveId = this.getResolveValue();
        Object resolveProcessor = this.hasCustomNameElement() ? new CommonProcessors.FindProcessor<Extension>(){

            protected boolean accept(Extension extension) {
                GenericAttributeValue<?> nameElement = ExtensionPointReferenceBase.this.getNameElement(extension);
                return nameElement != null && resolveId.equals(nameElement.getStringValue());
            }
        } : new CommonProcessors.FindFirstProcessor();
        this.processCandidates((Processor<? super Extension>)resolveProcessor, this.hasCustomNameElement() ? null : resolveId);
        Extension value = (Extension)resolveProcessor.getFoundValue();
        if (value == null) {
            return null;
        }
        DomTarget target = DomTarget.getTarget((DomElement)value, this.getNameElement(value));
        return target != null ? PomService.convertToPsi((PsiTarget)target) : value.getXmlElement();
    }

    @NotNull
    @NlsSafe
    protected String getResolveValue() {
        String string = this.getValue();
        if (string == null) {
            ExtensionPointReferenceBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    protected static GenericAttributeValue<?> getAttribute(Extension extension, String attributeName) {
        DomAttributeChildDescription attributeDescription = extension.getGenericInfo().getAttributeChildDescription(attributeName);
        if (attributeDescription == null) {
            return null;
        }
        return attributeDescription.getDomAttributeValue((DomElement)extension);
    }

    @Nullable
    protected static String getAttributeValue(Extension extension, String attributeName) {
        GenericAttributeValue<?> attribute = ExtensionPointReferenceBase.getAttribute(extension, attributeName);
        return attribute == null ? null : attribute.getStringValue();
    }

    protected void processCandidates(Processor<? super Extension> processor) {
        this.processCandidates(processor, null);
    }

    private void processCandidates(Processor<? super Extension> processor, @Nullable String extensionPointId) {
        Project project = this.myElement.getProject();
        ExtensionPoint extensionPointDomElement = ExtensionPointIndex.findExtensionPoint(project, PluginRelatedLocatorsUtils.getCandidatesScope(project), this.getExtensionPointFqn());
        if (extensionPointDomElement == null) {
            return;
        }
        List<ExtensionCandidate> candidates = extensionPointId == null ? ExtensionLocatorKt.locateExtensionsByExtensionPoint(extensionPointDomElement) : ExtensionLocatorKt.locateExtensionsByExtensionPointAndId(extensionPointDomElement, extensionPointId).findCandidates();
        DomManager manager = DomManager.getDomManager((Project)project);
        for (ExtensionCandidate candidate : candidates) {
            XmlTag element = (XmlTag)candidate.pointer.getElement();
            DomElement domElement = manager.getDomElement(element);
            if (!(domElement instanceof Extension) || processor.process((Object)((Extension)domElement))) continue;
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/references/ExtensionPointReferenceBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/references/ExtensionPointReferenceBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

