/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.quickfix.BaseFix;

public class CreateConstructorFix
extends BaseFix {
    public CreateConstructorFix(@NotNull PsiClass aClass, boolean isOnTheFly) {
        if (aClass == null) {
            CreateConstructorFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)aClass, isOnTheFly);
    }

    @NotNull
    public String getFamilyName() {
        String string = DevKitBundle.message("inspections.registration.problems.quickfix.create.constructor", new Object[0]);
        if (string == null) {
            CreateConstructorFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor, boolean external) throws IncorrectOperationException {
        PsiElement element = this.myPointer.getElement();
        if (!(element instanceof PsiClass)) {
            return;
        }
        PsiClass clazz = (PsiClass)element;
        PsiMethod ctor = JavaPsiFacade.getInstance((Project)clazz.getProject()).getElementFactory().createConstructor();
        PsiUtil.setModifierProperty((PsiModifierListOwner)ctor, (String)"public", (boolean)true);
        PsiMethod[] constructors = clazz.getConstructors();
        ctor = constructors.length > 0 ? (PsiMethod)clazz.addBefore((PsiElement)ctor, (PsiElement)constructors[0]) : (PsiMethod)clazz.add((PsiElement)ctor);
        if (this.myOnTheFly) {
            ctor.navigate(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/quickfix/CreateConstructorFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/quickfix/CreateConstructorFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

