/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.NonDefaultConstructorInspectionKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastFacade;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/devkit/inspections/NonDefaultConstructorInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "()V", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "aClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getArea", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint$Area;", "extensionPoint", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint;", "intellij.devkit"})
public final class NonDefaultConstructorInspection
extends DevKitUastInspectionBase {
    /*
     * Unable to fully structure code
     */
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        javaPsi = aClass.getJavaPsi();
        v0 = javaPsi.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"javaPsi.language");
        if (Intrinsics.areEqual((Object)v0.getID(), (Object)"Groovy") || javaPsi.getClassKind() != JvmClassKind.CLASS || PsiUtil.isInnerClass((PsiClass)javaPsi) || PsiUtil.isLocalOrAnonymousClass((PsiClass)javaPsi) || PsiUtil.isAbstractClass((PsiClass)javaPsi) || javaPsi.hasModifierProperty("private")) {
            return null;
        }
        constructors = javaPsi.getConstructors();
        Intrinsics.checkNotNullExpressionValue((Object)constructors, (String)"constructors");
        var6_6 = constructors;
        var7_7 = false;
        if (var6_6.length == 0) {
            return null;
        }
        area = null;
        isService = false;
        isServiceAnnotation = false;
        extensionPoint = null;
        if (javaPsi.hasAnnotation("com.intellij.openapi.components.Service")) {
            area = null;
            isService = true;
            isServiceAnnotation = true;
        } else {
            if (!NonDefaultConstructorInspectionKt.access$isExtensionBean(aClass)) {
                v1 = manager.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"manager.project");
                v2 = NonDefaultConstructorInspectionKt.access$findExtensionPoint(aClass, v1);
                if (v2 == null) {
                    return null;
                }
                extensionPoint = v2;
            } else if (Intrinsics.areEqual((Object)javaPsi.getName(), (Object)"VcsConfigurableEP")) {
                return null;
            }
            area = this.getArea((ExtensionPoint)extensionPoint);
            v3 = extensionPoint;
            isService = Intrinsics.areEqual((Object)(v3 != null && (v3 = v3.getBeanClass()) != null ? v3.getStringValue() : null), (Object)"com.intellij.openapi.components.ServiceDescriptor");
        }
        isAppLevelExtensionPoint = area == null || area == ExtensionPoint.Area.IDEA_APPLICATION;
        errors = null;
        var14_12 = constructors;
        var15_13 = var14_12.length;
        for (var13_14 = 0; var13_14 < var15_13; ++var13_14) {
            block19: {
                block18: {
                    v4 = method = var14_12[var13_14];
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"method");
                    v5 = v4.getParameterList();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"method.parameterList");
                    if (NonDefaultConstructorInspectionKt.access$isAllowedParameters(v5, extensionPoint, isAppLevelExtensionPoint, isServiceAnnotation)) {
                        return null;
                    }
                    if (errors == null) {
                        errors = (List)new SmartList();
                    }
                    if (!method.isPhysical()) break block18;
                    v6 = method.getIdentifyingElement();
                    v7 = v6;
                    Intrinsics.checkNotNull((Object)v6);
                    break block19;
                }
                v7 = aClass.getSourcePsi();
                if (v7 == null) continue;
                var17_17 = v7;
                var18_18 = false;
                var19_20 = false;
                it = var17_17;
                $i$a$-let-NonDefaultConstructorInspection$checkClass$anchorElement$1 = false;
                v8 = UastFacade.INSTANCE.findPlugin(it);
                if (v8 == null) ** GOTO lbl-1000
                var22_23 = v8;
                var23_24 = (PsiElement)method;
                parent$iv = (UElement)aClass;
                $i$f$convertOpt = false;
                v9 = $this$convertOpt$iv.convertElement((PsiElement)element$iv, parent$iv, UMethod.class);
                if (!(v9 instanceof UMethod)) {
                    v9 = null;
                }
                if ((v8 = (UMethod)((UElement)((UMethod)v9))) != null) {
                    v10 = v8.getSourcePsi();
                } else lbl-1000:
                // 2 sources

                {
                    v10 = v7 = null;
                }
                if (v10 == null) {
                    continue;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"when {\n        method.is\u2026 ?: continue@loop\n      }");
            anchorElement = v7;
            v11 = kind = isService != false ? "Service" : "Extension";
            suffix = area == null ? DevKitBundle.message("inspections.non.default.warning.suffix.project.or.module", new Object[0]) : (isAppLevelExtensionPoint != false ? "" : (area == ExtensionPoint.Area.IDEA_PROJECT ? DevKitBundle.message("inspections.non.default.warning.suffix.project", new Object[0]) : DevKitBundle.message("inspections.non.default.warning.suffix.module", new Object[0])));
            v12 = manager.createProblemDescriptor(anchorElement, DevKitBundle.message("inspections.non.default.warning.and.suffix.message", new Object[]{kind, suffix}), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]);
            Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"manager.createProblemDes\u2026R_OR_WARNING, isOnTheFly)");
            errors.add(v12);
        }
        v13 = errors;
        if (v13 != null) {
            $this$toTypedArray$iv = v13;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            v14 = thisCollection$iv.toArray(new ProblemDescriptor[0]);
            if (v14 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            v15 = v14;
        } else {
            v15 = null;
        }
        return v15;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ExtensionPoint.Area getArea(ExtensionPoint extensionPoint) {
        String areaName;
        ExtensionPoint extensionPoint2 = extensionPoint;
        if (extensionPoint2 == null) {
            return ExtensionPoint.Area.IDEA_APPLICATION;
        }
        GenericAttributeValue<ExtensionPoint.Area> genericAttributeValue = extensionPoint2.getArea();
        Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"(extensionPoint ?: retur\u2026ea.IDEA_APPLICATION).area");
        String string = areaName = genericAttributeValue.getStringValue();
        if (string != null) {
            String string2 = string;
            switch (string2.hashCode()) {
                case -660214604: {
                    if (!string2.equals("IDEA_MODULE")) break;
                    return ExtensionPoint.Area.IDEA_MODULE;
                }
                case -528560719: {
                    if (!string2.equals("IDEA_PROJECT")) break;
                    return ExtensionPoint.Area.IDEA_PROJECT;
                }
            }
        }
        GenericAttributeValue<String> genericAttributeValue2 = extensionPoint.getName();
        Intrinsics.checkNotNullExpressionValue(genericAttributeValue2, (String)"extensionPoint.name");
        String string3 = (String)genericAttributeValue2.getValue();
        if (string3 == null) return ExtensionPoint.Area.IDEA_APPLICATION;
        String string4 = string3;
        switch (string4.hashCode()) {
            case 350807721: {
                if (!string4.equals("moduleService")) return ExtensionPoint.Area.IDEA_APPLICATION;
                return ExtensionPoint.Area.IDEA_MODULE;
            }
            case -1492183716: {
                if (!string4.equals("projectService")) return ExtensionPoint.Area.IDEA_APPLICATION;
                return ExtensionPoint.Area.IDEA_PROJECT;
            }
        }
        return ExtensionPoint.Area.IDEA_APPLICATION;
    }

    public NonDefaultConstructorInspection() {
        super(UClass.class);
    }
}

