/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;

public class KeymapConverter
extends ResolvingConverter<XmlFile> {
    @Nullable
    public XmlFile fromString(@Nullable String s, ConvertContext context) {
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        return (XmlFile)ContainerUtil.find(KeymapConverter.getKeymapFiles(context), file -> s.equals(KeymapConverter.getKeymapName(file)));
    }

    @Nullable
    public String toString(@Nullable XmlFile file, ConvertContext context) {
        return file != null ? KeymapConverter.getKeymapName(file) : null;
    }

    @NotNull
    public Collection<? extends XmlFile> getVariants(ConvertContext context) {
        return KeymapConverter.getKeymapFiles(context);
    }

    @Nullable
    public LookupElement createLookupElement(XmlFile file) {
        return LookupElementBuilder.create((String)KeymapConverter.getKeymapName(file));
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return DevKitBundle.message("plugin.xml.convert.keymap.cannot.resolve", s);
    }

    private static String getKeymapName(XmlFile file) {
        return FileUtilRt.getNameWithoutExtension((String)file.getName());
    }

    @NotNull
    private static List<XmlFile> getKeymapFiles(ConvertContext context) {
        PsiPackage keymapsPackage = JavaPsiFacade.getInstance((Project)context.getProject()).findPackage("keymaps");
        if (keymapsPackage == null) {
            List<XmlFile> list = Collections.emptyList();
            if (list == null) {
                KeymapConverter.$$$reportNull$$$0(0);
            }
            return list;
        }
        Object[] files = keymapsPackage.getFiles(context.getFile().getResolveScope());
        List list = ContainerUtil.findAll((Object[])files, XmlFile.class);
        if (list == null) {
            KeymapConverter.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/impl/KeymapConverter", "getKeymapFiles"));
    }
}

