/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.google.common.base.CaseFormat;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.spellchecker.xml.NoSpellchecking;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ExtendClassImpl;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.PsiClassConverter;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import com.intellij.util.xmlb.annotations.Tag;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.With;
import org.jetbrains.idea.devkit.dom.impl.ActionOrGroupResolveConverter;
import org.jetbrains.idea.devkit.dom.impl.LanguageResolvingConverter;
import org.jetbrains.idea.devkit.dom.impl.PluginPsiClassConverter;
import org.jetbrains.idea.devkit.references.extensions.ExtensionPointBinding;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class ExtensionDomExtender
extends DomExtender<Extension> {
    private static final XmlName IMPLEMENTATION_XML_NAME = new XmlName("implementation");
    private static final PsiClassConverter CLASS_CONVERTER = new PluginPsiClassConverter();
    private static final LanguageResolvingConverter LANGUAGE_CONVERTER = new LanguageResolvingConverter();
    private static final ActionOrGroupResolveConverter ACTION_CONVERTER = new ActionOrGroupResolveConverter.OnlyActions();
    private static final Set<String> LEGACY_ENUM_NOTATION_CLASSES = ContainerUtil.immutableSet((Object[])new String[]{"com.intellij.compiler.CompileTaskBean.CompileTaskExecutionPhase", "com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainerKind", "com.intellij.notification.impl.NotificationGroupEP.DisplayType"});

    public void registerExtensions(@NotNull Extension extension, @NotNull DomExtensionsRegistrar registrar) {
        ExtensionPoint extensionPoint;
        if (extension == null) {
            ExtensionDomExtender.$$$reportNull$$$0(0);
        }
        if (registrar == null) {
            ExtensionDomExtender.$$$reportNull$$$0(1);
        }
        if ((extensionPoint = extension.getExtensionPoint()) == null) {
            return;
        }
        String interfaceName = extensionPoint.getInterface().getStringValue();
        if (interfaceName != null) {
            DomExtension implementationAttribute = registrar.registerGenericAttributeValueChildExtension(IMPLEMENTATION_XML_NAME, PsiClass.class).setConverter((Converter)CLASS_CONVERTER).addCustomAnnotation((Annotation)((Object)new MyImplementationExtendClass(interfaceName))).addCustomAnnotation((Annotation)((Object)MyRequired.INSTANCE));
            PsiClass interfaceClass = (PsiClass)extensionPoint.getInterface().getValue();
            if (interfaceClass != null) {
                implementationAttribute.setDeclaringElement((PsiElement)interfaceClass);
            } else {
                implementationAttribute.setDeclaringElement((DomElement)extensionPoint);
            }
            ExtensionDomExtender.registerXmlb(registrar, interfaceClass, Collections.emptyList());
        } else {
            PsiClass beanClass = (PsiClass)extensionPoint.getBeanClass().getValue();
            ExtensionDomExtender.registerXmlb(registrar, beanClass, extensionPoint.getWithElements());
        }
    }

    private static void registerXmlb(final DomExtensionsRegistrar registrar, @Nullable PsiClass psiClass, final @NotNull List<With> elements) {
        if (elements == null) {
            ExtensionDomExtender.$$$reportNull$$$0(2);
        }
        if (psiClass == null) {
            return;
        }
        ExtensionPointBinding binding = new ExtensionPointBinding(psiClass);
        binding.visit(new ExtensionPointBinding.BindingVisitor(){

            @Override
            public void visitAttribute(@NotNull PsiField field, @NotNull @NonNls String attributeName, ExtensionPointBinding.BindingVisitor.RequiredFlag required) {
                if (field == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (attributeName == null) {
                    1.$$$reportNull$$$0(1);
                }
                With withElement = ExtensionDomExtender.findWithElement(elements, field);
                PsiType fieldType = field.getType();
                Class clazz = String.class;
                if (PsiType.BOOLEAN.equals((Object)fieldType)) {
                    clazz = Boolean.class;
                } else if (PsiType.INT.equals((Object)fieldType) || fieldType.equalsToText("java.lang.Integer")) {
                    clazz = Integer.class;
                } else if (withElement != null || Extension.isClassField(attributeName)) {
                    clazz = PsiClass.class;
                }
                DomExtension extension = registrar.registerGenericAttributeValueChildExtension(new XmlName(attributeName), clazz).setDeclaringElement((PsiElement)field);
                ExtensionDomExtender.markAsRequired(extension, required);
                if (clazz == String.class) {
                    PsiClass fieldPsiClass;
                    if (PsiUtil.findAnnotation(NonNls.class, new PsiMember[]{field}) != null) {
                        extension.addCustomAnnotation((Annotation)((Object)MyNoSpellchecking.INSTANCE));
                    } else if (!fieldType.equalsToText("java.lang.String") && (fieldPsiClass = PsiTypesUtil.getPsiClass((PsiType)fieldType)) != null && fieldPsiClass.isEnum()) {
                        extension.setConverter(ExtensionDomExtender.createEnumConverter(fieldPsiClass));
                        return;
                    }
                    if ("language".equals(attributeName) || StringUtil.endsWith((CharSequence)attributeName, (CharSequence)"Language")) {
                        extension.setConverter((Converter)LANGUAGE_CONVERTER);
                    } else if ("action".equals(attributeName)) {
                        extension.setConverter((Converter)ACTION_CONVERTER);
                    }
                } else if (clazz == PsiClass.class) {
                    ExtensionDomExtender.markAsClass(extension, true, withElement);
                }
            }

            @Override
            public void visitTagOrProperty(@NotNull PsiField field, @NotNull String tagName, ExtensionPointBinding.BindingVisitor.RequiredFlag required) {
                if (field == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (tagName == null) {
                    1.$$$reportNull$$$0(3);
                }
                DomExtension extension = registrar.registerFixedNumberChildExtension(new XmlName(tagName), SimpleTagValue.class).setDeclaringElement((PsiElement)field);
                ExtensionDomExtender.markAsRequired(extension, required);
                With withElement = ExtensionDomExtender.findWithElement(elements, field);
                ExtensionDomExtender.markAsClass(extension, Extension.isClassField(field.getName()), withElement);
                if (PsiUtil.findAnnotation(NonNls.class, new PsiMember[]{field}) != null) {
                    extension.addCustomAnnotation((Annotation)((Object)MyNoSpellchecking.INSTANCE));
                }
            }

            @Override
            public void visitXCollection(final @NotNull PsiField field, @Nullable String tagName, final @NotNull PsiAnnotation collectionAnnotation, final ExtensionPointBinding.BindingVisitor.RequiredFlag required) {
                if (field == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (collectionAnnotation == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (tagName == null) {
                    ExtensionDomExtender.registerCollectionBinding(field, registrar, collectionAnnotation, required);
                    return;
                }
                registrar.registerFixedNumberChildExtension(new XmlName(tagName), DomElement.class).addExtender(new DomExtender(){

                    public void registerExtensions(@NotNull DomElement domElement, @NotNull DomExtensionsRegistrar registrar) {
                        if (domElement == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (registrar == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        ExtensionDomExtender.registerCollectionBinding(field, registrar, collectionAnnotation, required);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "domElement";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "registrar";
                                break;
                            }
                        }
                        objectArray[1] = "org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender$1$1";
                        objectArray[2] = "registerExtensions";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attributeName";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tagName";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "collectionAnnotation";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAttribute";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTagOrProperty";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXCollection";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    static With findWithElement(List<? extends With> withElements, PsiField field) {
        for (With with : withElements) {
            PsiField withPsiField;
            PsiField psiField = withPsiField = DomUtil.hasXml(with.getTag()) ? (PsiField)with.getTag().getValue() : (PsiField)with.getAttribute().getValue();
            if (!field.getManager().areElementsEquivalent((PsiElement)field, (PsiElement)withPsiField)) continue;
            return with;
        }
        return null;
    }

    private static void markAsClass(DomExtension extension, boolean isClassField, @Nullable With withElement) {
        if (withElement != null) {
            final String withClassName = withElement.getImplements().getStringValue();
            extension.addCustomAnnotation((Annotation)new ExtendClassImpl(){

                public String[] value() {
                    return new String[]{withClassName};
                }
            });
        }
        if (withElement != null || isClassField) {
            extension.setConverter((Converter)CLASS_CONVERTER);
        }
    }

    private static void markAsRequired(DomExtension extension, ExtensionPointBinding.BindingVisitor.RequiredFlag required) {
        if (required == ExtensionPointBinding.BindingVisitor.RequiredFlag.REQUIRED) {
            extension.addCustomAnnotation((Annotation)((Object)MyRequired.INSTANCE));
        } else if (required == ExtensionPointBinding.BindingVisitor.RequiredFlag.REQUIRED_ALLOW_EMPTY) {
            extension.addCustomAnnotation((Annotation)((Object)MyRequiredCanBeEmpty.INSTANCE));
        }
    }

    private static void registerCollectionBinding(PsiField field, DomExtensionsRegistrar registrar, PsiAnnotation collectionAnnotation, ExtensionPointBinding.BindingVisitor.RequiredFlag required) {
        boolean surroundWithTag = PsiUtil.getAnnotationBooleanAttribute(collectionAnnotation, "surroundWithTag");
        if (surroundWithTag) {
            return;
        }
        String tagName = PsiUtil.getAnnotationStringAttribute(collectionAnnotation, "elementTag", null);
        final String attrName = PsiUtil.getAnnotationStringAttribute(collectionAnnotation, "elementValueAttribute", null);
        PsiType elementType = ExtensionDomExtender.getElementType(field.getType());
        if (elementType == null || TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)elementType) || "java.lang.String".equals(elementType.getCanonicalText()) || TypeConversionUtil.isEnumType((PsiType)elementType)) {
            if (tagName != null && attrName == null) {
                DomExtension extension = registrar.registerCollectionChildrenExtension(new XmlName(tagName), SimpleTagValue.class).setDeclaringElement((PsiElement)field);
                ExtensionDomExtender.markAsRequired(extension, required);
            } else if (tagName != null) {
                DomExtension extension = registrar.registerCollectionChildrenExtension(new XmlName(tagName), DomElement.class).setDeclaringElement((PsiElement)field);
                ExtensionDomExtender.markAsRequired(extension, required);
                extension.addExtender(new DomExtender(){

                    public void registerExtensions(@NotNull DomElement domElement, @NotNull DomExtensionsRegistrar registrar) {
                        if (domElement == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (registrar == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        registrar.registerGenericAttributeValueChildExtension(new XmlName(attrName), String.class);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "domElement";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "registrar";
                                break;
                            }
                        }
                        objectArray[1] = "org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender$3";
                        objectArray[2] = "registerExtensions";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        } else {
            final PsiClass elementPsiClass = PsiTypesUtil.getPsiClass((PsiType)elementType);
            if (elementPsiClass != null) {
                String classTagName;
                PsiModifierList modifierList = elementPsiClass.getModifierList();
                PsiAnnotation tagAnno = modifierList == null ? null : modifierList.findAnnotation(Tag.class.getName());
                String string = classTagName = tagAnno == null ? elementPsiClass.getName() : PsiUtil.getAnnotationStringAttribute(tagAnno, "value", null);
                if (classTagName != null) {
                    DomExtension extension = registrar.registerCollectionChildrenExtension(new XmlName(classTagName), DomElement.class).setDeclaringElement((PsiElement)field);
                    ExtensionDomExtender.markAsRequired(extension, required);
                    extension.addExtender(new DomExtender(){

                        public void registerExtensions(@NotNull DomElement domElement, @NotNull DomExtensionsRegistrar registrar) {
                            if (domElement == null) {
                                4.$$$reportNull$$$0(0);
                            }
                            if (registrar == null) {
                                4.$$$reportNull$$$0(1);
                            }
                            ExtensionDomExtender.registerXmlb(registrar, elementPsiClass, Collections.emptyList());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "domElement";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "registrar";
                                    break;
                                }
                            }
                            objectArray[1] = "org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender$4";
                            objectArray[2] = "registerExtensions";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }
            }
        }
    }

    @Nullable
    private static PsiType getElementType(PsiType psiType) {
        if (psiType instanceof PsiArrayType) {
            return ((PsiArrayType)psiType).getComponentType();
        }
        if (psiType instanceof PsiClassType) {
            PsiType[] types = ((PsiClassType)psiType).getParameters();
            return types.length == 1 ? types[0] : null;
        }
        return null;
    }

    @NotNull
    private static ResolvingConverter<PsiEnumConstant> createEnumConverter(final PsiClass fieldPsiClass) {
        return new ResolvingConverter<PsiEnumConstant>(){

            public String getErrorMessage(@Nullable String s, ConvertContext context) {
                return DevKitBundle.message("plugin.xml.convert.enum.cannot.resolve", s, fieldPsiClass.getQualifiedName());
            }

            @NotNull
            public Collection<? extends PsiEnumConstant> getVariants(ConvertContext context) {
                List list = ContainerUtil.findAll((Object[])fieldPsiClass.getFields(), PsiEnumConstant.class);
                if (list == null) {
                    5.$$$reportNull$$$0(0);
                }
                return list;
            }

            @Nullable
            public LookupElement createLookupElement(PsiEnumConstant constant) {
                return JavaLookupElementBuilder.forField((PsiField)constant, (String)this.toXmlName(constant), null);
            }

            @Nullable
            public PsiEnumConstant fromString(@Nullable String s, ConvertContext context) {
                if (s == null) {
                    return null;
                }
                PsiField name = fieldPsiClass.findFieldByName(this.fromXmlName(s), false);
                return name instanceof PsiEnumConstant ? (PsiEnumConstant)name : null;
            }

            @Nullable
            public String toString(@Nullable PsiEnumConstant constant, ConvertContext context) {
                return constant == null ? null : this.toXmlName(constant);
            }

            private String fromXmlName(@NotNull String name) {
                if (name == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (this.doNotTransformName()) {
                    return name;
                }
                return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, name);
            }

            private String toXmlName(PsiEnumConstant constant) {
                if (this.doNotTransformName()) {
                    return constant.getName();
                }
                return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, constant.getName());
            }

            private boolean doNotTransformName() {
                return LEGACY_ENUM_NOTATION_CLASSES.contains(fieldPsiClass.getQualifiedName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender$5";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariants";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "fromXmlName";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerExtensions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerXmlb";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyImplementationExtendClass
    extends ExtendClassImpl {
        private final String myInterfaceName;

        private MyImplementationExtendClass(String interfaceName) {
            this.myInterfaceName = interfaceName;
        }

        public boolean allowAbstract() {
            return false;
        }

        public boolean allowInterface() {
            return false;
        }

        public boolean allowEnum() {
            return false;
        }

        public String[] value() {
            return new String[]{this.myInterfaceName};
        }
    }

    private static class MyRequiredCanBeEmpty
    implements Required {
        private static final MyRequiredCanBeEmpty INSTANCE = new MyRequiredCanBeEmpty();

        private MyRequiredCanBeEmpty() {
        }

        public boolean value() {
            return true;
        }

        public boolean nonEmpty() {
            return false;
        }

        public boolean identifier() {
            return false;
        }

        public Class<? extends Annotation> annotationType() {
            return Required.class;
        }
    }

    private static class MyRequired
    implements Required {
        private static final MyRequired INSTANCE = new MyRequired();

        private MyRequired() {
        }

        public boolean value() {
            return true;
        }

        public boolean nonEmpty() {
            return true;
        }

        public boolean identifier() {
            return false;
        }

        public Class<? extends Annotation> annotationType() {
            return Required.class;
        }
    }

    private static class MyNoSpellchecking
    implements NoSpellchecking {
        private static final MyNoSpellchecking INSTANCE = new MyNoSpellchecking();

        private MyNoSpellchecking() {
        }

        public Class<? extends Annotation> annotationType() {
            return NoSpellchecking.class;
        }
    }

    public static interface SimpleTagValue
    extends GenericDomValue<String> {
    }
}

