/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\f0\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\tH\u0016J\u0012\u0010\n\u001a\f0\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\tH\u0016J\u0012\u0010\u000b\u001a\f0\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticInheritorRenamer;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "newName", "", "(Lorg/jetbrains/kotlin/psi/KtClass;Ljava/lang/String;)V", "entityName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getDialogDescription", "getDialogTitle", "kotlin.idea"})
public final class AutomaticInheritorRenamer
extends AutomaticRenamer {
    @NotNull
    public String getDialogTitle() {
        String string = RefactoringBundle.message((String)"rename.inheritors.title");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RefactoringBundle.messag\u2026rename.inheritors.title\")");
        return string;
    }

    @NotNull
    public String getDialogDescription() {
        String string = JavaRefactoringBundle.message((String)"rename.inheritors.with.the.following.names.to", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JavaRefactoringBundle.me\u2026.the.following.names.to\")");
        return string;
    }

    @NotNull
    public String entityName() {
        String string = JavaRefactoringBundle.message((String)"entity.name.inheritor", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JavaRefactoringBundle.me\u2026(\"entity.name.inheritor\")");
        return string;
    }

    public AutomaticInheritorRenamer(@NotNull KtClass klass2, @NotNull String newName2) {
        Intrinsics.checkNotNullParameter((Object)klass2, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        KtLightClass lightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)klass2));
        if (lightClass != null) {
            Iterator iterator = ClassInheritorsSearch.search((PsiClass)((PsiClass)lightClass), (boolean)true).findAll().iterator();
            while (iterator.hasNext()) {
                PsiClass inheritorLightClass;
                PsiClass psiClass2 = inheritorLightClass = (PsiClass)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)psiClass2, (String)"inheritorLightClass");
                PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)psiClass2));
                if (!(psiElement2 instanceof PsiNamedElement)) {
                    psiElement2 = null;
                }
                PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement2;
                if ((psiNamedElement != null ? psiNamedElement.getName() : null) == null) continue;
                PsiElement psiElement3 = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)inheritorLightClass));
                if (psiElement3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiNamedElement");
                }
                this.myElements.add((PsiNamedElement)psiElement3);
            }
        }
        this.suggestAllNames(klass2.getName(), newName2);
    }
}

