/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveFilesOrDirectories;

import com.intellij.lang.Language;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.ContainerChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.move.ContainerInfo;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.EmptyKotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTargetForDeferredFile;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDelegate;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDescriptor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessorKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveFilesOrDirectories.MoveKotlinFileHandlerKt;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\"#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0004J0\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\"\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0004J,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\f2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J,\u0010\u0019\u001a\u00020\u00132\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u001bH\u0016J\u001e\u0010\u0019\u001a\u00020\u00132\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u0011J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J \u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020 2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\u0004H\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/MoveKotlinFileHandler;", "Lcom/intellij/refactoring/move/moveFilesOrDirectories/MoveFileHandler;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiFile;", "findUsages", "", "Lcom/intellij/usageView/UsageInfo;", "psiFile", "newParent", "Lcom/intellij/psi/PsiDirectory;", "withConflicts", "searchInComments", "searchInNonJavaFiles", "initMoveProcessor", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;", "prepareMovedFile", "", "file", "moveDestination", "oldToNewMap", "", "Lcom/intellij/psi/PsiElement;", "retargetUsages", "usageInfos", "", "moveDeclarationsProcessor", "updateMovedFile", "getPackageNameInfo", "Lorg/jetbrains/kotlin/idea/refactoring/move/ContainerChangeInfo;", "Lorg/jetbrains/kotlin/psi/KtFile;", "clearUserData", "FileInfo", "MoveContext", "kotlin.idea"})
public final class MoveKotlinFileHandler
extends MoveFileHandler {
    private final ContainerChangeInfo getPackageNameInfo(KtFile $this$getPackageNameInfo, PsiDirectory newParent, boolean clearUserData) {
        Boolean bl = MoveUtilsKt.getUpdatePackageDirective($this$getPackageNameInfo);
        boolean shouldUpdatePackageDirective = bl != null ? bl : PackageUtilsKt.packageMatchesDirectoryOrImplicit((KtFile)$this$getPackageNameInfo);
        MoveUtilsKt.setUpdatePackageDirective($this$getPackageNameInfo, clearUserData ? null : Boolean.valueOf(shouldUpdatePackageDirective));
        if (!shouldUpdatePackageDirective) {
            return null;
        }
        FqName oldPackageName = $this$getPackageNameInfo.getPackageFqName();
        PsiDirectory psiDirectory = newParent;
        if (psiDirectory == null || (psiDirectory = PackageUtilsKt.getFqNameWithImplicitPrefix((PsiDirectory)psiDirectory)) == null) {
            return new ContainerChangeInfo(new ContainerInfo.Package(oldPackageName), ContainerInfo.UnknownPackage.INSTANCE);
        }
        PsiDirectory newPackageName = psiDirectory;
        if (Intrinsics.areEqual((Object)oldPackageName.asString(), (Object)newPackageName.asString()) && Intrinsics.areEqual((Object)ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)$this$getPackageNameInfo)), (Object)ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)newParent)))) {
            return null;
        }
        if (!KotlinRefactoringUtilKt.hasIdentifiersOnly((FqName)newPackageName)) {
            return null;
        }
        return new ContainerChangeInfo(new ContainerInfo.Package(oldPackageName), new ContainerInfo.Package((FqName)newPackageName));
    }

    @Nullable
    public final MoveKotlinDeclarationsProcessor initMoveProcessor(@NotNull PsiFile psiFile, @Nullable PsiDirectory newParent, boolean withConflicts) {
        KotlinMoveTarget kotlinMoveTarget;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (!(psiFile instanceof KtFile)) {
            return null;
        }
        ContainerChangeInfo containerChangeInfo = this.getPackageNameInfo((KtFile)psiFile, newParent, false);
        if (containerChangeInfo == null) {
            return null;
        }
        ContainerChangeInfo packageNameInfo = containerChangeInfo;
        Project project2 = ((KtFile)psiFile).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiFile.project");
        Project project3 = project2;
        ContainerInfo newPackage = packageNameInfo.getNewContainer();
        if (Intrinsics.areEqual((Object)newPackage, (Object)ContainerInfo.UnknownPackage.INSTANCE)) {
            kotlinMoveTarget = EmptyKotlinMoveTarget.INSTANCE;
        } else {
            FqName fqName = newPackage.getFqName();
            Intrinsics.checkNotNull((Object)fqName);
            kotlinMoveTarget = new KotlinMoveTargetForDeferredFile(fqName, newParent, null, (Function1)new Function1<KtFile, KtFile>(newParent, psiFile){
                final /* synthetic */ PsiDirectory $newParent;
                final /* synthetic */ PsiFile $psiFile;

                @Nullable
                public final KtFile invoke(@NotNull KtFile it) {
                    KtFile ktFile;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    PsiDirectory psiDirectory = this.$newParent;
                    if (psiDirectory != null) {
                        PsiDirectory psiDirectory2 = psiDirectory;
                        boolean bl = false;
                        boolean bl2 = false;
                        PsiDirectory it2 = psiDirectory2;
                        boolean bl3 = false;
                        MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)this.$psiFile, (PsiDirectory)it2);
                        PsiFile psiFile = it2.findFile(((KtFile)this.$psiFile).getName());
                        if (!(psiFile instanceof KtFile)) {
                            psiFile = null;
                        }
                        ktFile = (KtFile)psiFile;
                    } else {
                        ktFile = null;
                    }
                    return ktFile;
                }
                {
                    this.$newParent = psiDirectory;
                    this.$psiFile = psiFile;
                    super(1);
                }
            }, 4, null);
        }
        KotlinMoveTarget moveTarget2 = kotlinMoveTarget;
        return new MoveKotlinDeclarationsProcessor(new MoveDeclarationsDescriptor(project3, MoveKotlinDeclarationsProcessorKt.MoveSource((KtFile)psiFile), moveTarget2, MoveDeclarationsDelegate.TopLevel.INSTANCE, false, false, false, null, false, MoveKotlinFileHandlerKt.getAllElementsToMove((KtFile)psiFile), withConflicts, false, 2544, null), null, false, 6, null);
    }

    public boolean canProcessElement(@Nullable PsiFile element3) {
        if (element3 instanceof PsiCompiledElement || !(element3 instanceof KtFile)) {
            return false;
        }
        return !ProjectRootUtilsKt.isOutsideKotlinAwareSourceRoot(element3);
    }

    @NotNull
    public List<UsageInfo> findUsages(@NotNull PsiFile psiFile, @Nullable PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return this.findUsages(psiFile, newParent, true);
    }

    @NotNull
    public final List<UsageInfo> findUsages(@NotNull PsiFile psiFile, @Nullable PsiDirectory newParent, boolean withConflicts) {
        ArrayList usages2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            if (!(psiFile instanceof KtFile)) {
                return CollectionsKt.emptyList();
            }
            usages2 = CollectionsKt.arrayListOf((Object[])new UsageInfo[]{new FileInfo((KtFile)psiFile)});
            MoveKotlinDeclarationsProcessor moveKotlinDeclarationsProcessor = this.initMoveProcessor(psiFile, newParent, withConflicts);
            if (moveKotlinDeclarationsProcessor == null) break block1;
            MoveKotlinDeclarationsProcessor moveKotlinDeclarationsProcessor2 = moveKotlinDeclarationsProcessor;
            boolean bl = false;
            boolean bl2 = false;
            MoveKotlinDeclarationsProcessor it = moveKotlinDeclarationsProcessor2;
            boolean bl3 = false;
            Collection collection = usages2;
            Object object = it.findUsages();
            boolean bl4 = false;
            CollectionsKt.addAll((Collection)collection, (Object[])object);
            collection = usages2;
            object = it.getConflictsAsUsages();
            bl4 = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
        }
        return usages2;
    }

    public void prepareMovedFile(@NotNull PsiFile file, @NotNull PsiDirectory moveDestination, @NotNull Map<PsiElement, PsiElement> oldToNewMap) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)moveDestination, (String)"moveDestination");
            Intrinsics.checkNotNullParameter(oldToNewMap, (String)"oldToNewMap");
            if (!(file instanceof KtFile)) {
                return;
            }
            MoveKotlinDeclarationsProcessor moveKotlinDeclarationsProcessor = this.initMoveProcessor(file, moveDestination, false);
            if (moveKotlinDeclarationsProcessor == null) {
                return;
            }
            MoveKotlinDeclarationsProcessor moveProcessor = moveKotlinDeclarationsProcessor;
            MoveContext moveContext = new MoveContext(file, moveProcessor);
            oldToNewMap.put((PsiElement)moveContext, (PsiElement)moveContext);
            ContainerChangeInfo containerChangeInfo = this.getPackageNameInfo((KtFile)file, moveDestination, true);
            if (containerChangeInfo == null) {
                return;
            }
            ContainerChangeInfo packageNameInfo = containerChangeInfo;
            FqName newFqName = packageNameInfo.getNewContainer().getFqName();
            if (newFqName == null) break block4;
            KtPackageDirective ktPackageDirective = ((KtFile)file).getPackageDirective();
            if (ktPackageDirective != null) {
                ktPackageDirective.setFqName(UtilsKt.quoteIfNeeded((FqName)newFqName));
            }
        }
    }

    public void updateMovedFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
    }

    public void retargetUsages(@Nullable List<? extends UsageInfo> usageInfos, @NotNull Map<PsiElement, ? extends PsiElement> oldToNewMap) {
        Object v4;
        Object v3;
        block4: {
            Intrinsics.checkNotNullParameter(oldToNewMap, (String)"oldToNewMap");
            List<? extends UsageInfo> list = usageInfos;
            Object object = list != null ? (UsageInfo)CollectionsKt.firstOrNull(list) : null;
            if (!(object instanceof FileInfo)) {
                object = null;
            }
            FileInfo fileInfo = (FileInfo)((Object)object);
            PsiElement currentFile = fileInfo != null ? fileInfo.getElement() : null;
            Iterable $this$firstOrNull$iv = oldToNewMap.keySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof MoveContext && Intrinsics.areEqual((Object)((MoveContext)it).getFile(), (Object)currentFile))) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = v4 = null;
        }
        if (!(v3 instanceof MoveContext)) {
            v4 = null;
        }
        MoveContext moveContext = v4;
        if (moveContext == null) {
            return;
        }
        MoveContext moveContext2 = moveContext;
        this.retargetUsages(usageInfos, moveContext2.getDeclarationMoveProcessor());
    }

    public final void retargetUsages(@Nullable List<? extends UsageInfo> usageInfos, @NotNull MoveKotlinDeclarationsProcessor moveDeclarationsProcessor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)moveDeclarationsProcessor), (String)"moveDeclarationsProcessor");
            List<? extends UsageInfo> list = usageInfos;
            if (list == null) break block0;
            List<? extends UsageInfo> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<? extends UsageInfo> it = list2;
            boolean bl3 = false;
            moveDeclarationsProcessor.doPerformRefactoring$kotlin_idea(it);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/MoveKotlinFileHandler$FileInfo;", "Lcom/intellij/usageView/UsageInfo;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "kotlin.idea"})
    public static final class FileInfo
    extends UsageInfo {
        public FileInfo(@NotNull KtFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super((PsiFile)file);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/MoveKotlinFileHandler$MoveContext;", "Lcom/intellij/psi/impl/light/LightElement;", "file", "Lcom/intellij/psi/PsiFile;", "declarationMoveProcessor", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;", "(Lcom/intellij/psi/PsiFile;Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;)V", "getDeclarationMoveProcessor", "()Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;", "getFile", "()Lcom/intellij/psi/PsiFile;", "toString", "", "kotlin.idea"})
    private static final class MoveContext
    extends LightElement {
        @NotNull
        private final PsiFile file;
        @NotNull
        private final MoveKotlinDeclarationsProcessor declarationMoveProcessor;

        @NotNull
        public String toString() {
            return "";
        }

        @NotNull
        public final PsiFile getFile() {
            return this.file;
        }

        @NotNull
        public final MoveKotlinDeclarationsProcessor getDeclarationMoveProcessor() {
            return this.declarationMoveProcessor;
        }

        public MoveContext(@NotNull PsiFile file, @NotNull MoveKotlinDeclarationsProcessor declarationMoveProcessor) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)((Object)declarationMoveProcessor), (String)"declarationMoveProcessor");
            super(file.getManager(), (Language)KotlinLanguage.INSTANCE);
            this.file = file;
            this.declarationMoveProcessor = declarationMoveProcessor;
        }
    }
}

