/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.ConvertEnumToSealedClassIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertEnumToSealedClassIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtClass;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
public final class ConvertEnumToSealedClassIntention
extends SelfTargetingRangeIntention<KtClass> {
    @Nullable
    public TextRange applicabilityRange(@NotNull KtClass element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (element3.getClassKeyword() == null) {
            return null;
        }
        PsiElement psiElement2 = element3.getNameIdentifier();
        if (psiElement2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.nameIdentifier ?: return null");
        PsiElement nameIdentifier = psiElement2;
        KtModifierList ktModifierList = element3.getModifierList();
        if (ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.ENUM_KEYWORD)) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierList, (String)"element.modifierList?.ge\u2026M_KEYWORD) ?: return null");
        KtModifierList enumKeyword = ktModifierList;
        return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)enumKeyword), PsiUtilsKt.getEndOffset((PsiElement)nameIdentifier));
    }

    public void applyTo(@NotNull KtClass element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        String string = element3.getName();
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.name ?: return");
        String name2 = string;
        CharSequence charSequence = name2;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        for (KtDeclaration klass2 : KotlinRefactoringUtilKt.withExpectedActuals((KtDeclaration)element3)) {
            PsiElement nonWhiteSibling;
            PsiElement psiElement2;
            Object v10;
            PsiElement semicolon;
            KtClassBody body2;
            block20: {
                PsiElement psiElement3;
                Object v9;
                block19: {
                    KtClassBody ktClassBody;
                    ClassDescriptor classDescriptor;
                    KtDeclaration ktDeclaration = klass2;
                    if (!(ktDeclaration instanceof KtClass)) {
                        ktDeclaration = null;
                    }
                    if ((KtClass)ktDeclaration == null) {
                        continue;
                    }
                    if (ResolutionUtils.resolveToDescriptorIfAny$default((KtClassOrObject)((KtClassOrObject)klass2), null, (int)1, null) == null) {
                        continue;
                    }
                    boolean isExpect = classDescriptor.isExpect();
                    boolean isActual = classDescriptor.isActual();
                    klass2.removeModifier(KtTokens.ENUM_KEYWORD);
                    klass2.addModifier(KtTokens.SEALED_KEYWORD);
                    KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)klass2), (boolean)false, (int)2, null);
                    for (KtDeclaration member : ((KtClass)klass2).getDeclarations()) {
                        KtSuperTypeListEntry defaultEntry;
                        boolean $i$f$forEach;
                        if (!(member instanceof KtEnumEntry)) continue;
                        KtObjectDeclaration obj = (KtObjectDeclaration)psiFactory.createDeclaration("object " + ((KtEnumEntry)member).getName());
                        Object object = ((KtEnumEntry)member).getInitializerList();
                        if (object == null || (object = object.getInitializers()) == null) {
                            object = CollectionsKt.emptyList();
                        }
                        Object initializers = object;
                        Collection collection = (Collection)initializers;
                        boolean bl2 = false;
                        if (!collection.isEmpty()) {
                            Iterable $this$forEach$iv = (Iterable)initializers;
                            $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv;
                                boolean bl3 = false;
                                StringBuilder stringBuilder = new StringBuilder().append(((KtClass)klass2).getName());
                                KtSuperTypeListEntry ktSuperTypeListEntry = it;
                                Intrinsics.checkNotNullExpressionValue((Object)ktSuperTypeListEntry, (String)"it");
                                obj.addSuperTypeListEntry((KtSuperTypeListEntry)psiFactory.createSuperTypeCallEntry(stringBuilder.append(ktSuperTypeListEntry.getText()).toString()));
                            }
                        } else {
                            defaultEntry = isExpect ? (KtSuperTypeListEntry)psiFactory.createSuperTypeEntry(name2) : (KtSuperTypeListEntry)psiFactory.createSuperTypeCallEntry(name2 + "()");
                            obj.addSuperTypeListEntry(defaultEntry);
                        }
                        if (isActual) {
                            obj.addModifier(KtTokens.ACTUAL_KEYWORD);
                        }
                        if (((KtEnumEntry)member).getBody() != null) {
                            $i$f$forEach = false;
                            boolean bl4 = false;
                            KtSuperTypeListEntry body3 = defaultEntry;
                            boolean bl5 = false;
                            obj.add((PsiElement)body3);
                        }
                        member.delete();
                        KtClassOrObject this_$iv = (KtClassOrObject)((KtClass)klass2);
                        boolean $i$f$addDeclaration = false;
                        KtClassBody body$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
                        PsiElement psiElement4 = body$iv.getRBrace();
                        if (psiElement4 == null) {
                            PsiElement psiElement5 = body$iv.getLastChild();
                            psiElement4 = psiElement5;
                            Intrinsics.checkNotNull((Object)psiElement5);
                        }
                        PsiElement anchor$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement4, (Class[])new Class[]{PsiWhiteSpace.class});
                        PsiElement psiElement6 = body$iv.addAfter((PsiElement)((KtDeclaration)obj), anchor$iv);
                        if (psiElement6 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtObjectDeclaration");
                        }
                        KtDeclaration cfr_ignored_0 = (KtDeclaration)((KtObjectDeclaration)psiElement6);
                    }
                    if (((KtClass)klass2).getBody() == null) continue;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    body2 = ktClassBody;
                    boolean bl8 = false;
                    Sequence $this$firstOrNull$iv = SequencesKt.takeWhile((Sequence)((Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)body2))), (Function1)applyTo.3.1.INSTANCE);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl9 = false;
                        ASTNode aSTNode = it.getNode();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it.node");
                        if (!Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)KtTokens.SEMICOLON)) continue;
                        v9 = element$iv;
                        break block19;
                    }
                    v9 = null;
                }
                if ((PsiElement)v9 == null) continue;
                boolean bl10 = false;
                boolean bl11 = false;
                semicolon = psiElement3;
                boolean bl12 = false;
                Sequence $this$firstOrNull$iv = PsiUtilsKt.siblings((PsiElement)semicolon, (boolean)true, (boolean)false);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl13 = false;
                    if (!(!(it instanceof PsiWhiteSpace))) continue;
                    v10 = element$iv;
                    break block20;
                }
                v10 = null;
            }
            if ((psiElement2 = (nonWhiteSibling = (PsiElement)v10)) == null || (psiElement2 = psiElement2.getPrevSibling()) == null) {
                psiElement2 = semicolon;
            }
            body2.deleteChildRange(semicolon, psiElement2);
            if (nonWhiteSibling == null) continue;
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)((KtClass)klass2).getProject());
            PsiElement psiElement7 = nonWhiteSibling.getFirstChild();
            if (psiElement7 == null) {
                psiElement7 = nonWhiteSibling;
            }
            codeStyleManager.reformat(psiElement7);
        }
    }

    public ConvertEnumToSealedClassIntention() {
        super(KtClass.class, KotlinBundle.lazyMessage("convert.to.sealed.class", new Object[0]), null, 4, null);
    }
}

