/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/IncompleteDestructuringQuickfix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "primaryParameterNames", "", "", "(Ljava/util/List;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "kotlin.idea"})
public final class IncompleteDestructuringQuickfix
implements LocalQuickFix {
    private final List<String> primaryParameterNames;

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("incomplete.destructuring.fix.family.name", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        void $this$mapNotNullTo$iv$iv;
        PsiElement element3;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = element3 = descriptor2.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element");
        PsiElement psiElement3 = psiElement2.getParent();
        if (!(psiElement3 instanceof KtDestructuringDeclaration)) {
            psiElement3 = null;
        }
        KtDestructuringDeclaration ktDestructuringDeclaration = (KtDestructuringDeclaration)psiElement3;
        if (ktDestructuringDeclaration == null) {
            return;
        }
        KtDestructuringDeclaration destructuringDeclaration = ktDestructuringDeclaration;
        if (destructuringDeclaration.getEntries().size() >= this.primaryParameterNames.size()) {
            return;
        }
        List<String> namesToAdd = this.primaryParameterNames.subList(destructuringDeclaration.getEntries().size(), this.primaryParameterNames.size());
        List list = destructuringDeclaration.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"destructuringDeclaration.entries");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KtDestructuringDeclarationEntry it = (KtDestructuringDeclarationEntry)element$iv$iv;
            boolean bl2 = false;
            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = it;
            Intrinsics.checkNotNullExpressionValue((Object)ktDestructuringDeclarationEntry, (String)"it");
            if (ktDestructuringDeclarationEntry.getName() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List names = CollectionsKt.plus((Collection)CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)), (Iterable)namesToAdd);
        String joinedNames = CollectionsKt.joinToString$default((Iterable)names, null, null, null, (int)0, null, null, (int)63, null);
        KtExpression ktExpression = destructuringDeclaration.getInitializer();
        if (ktExpression == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"destructuringDeclaration.initializer ?: return");
        KtExpression initializer2 = ktExpression;
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)destructuringDeclaration), (boolean)false, (int)2, null);
        KtDestructuringDeclaration newDestructuringDeclaration = CreateByPatternKt.createDestructuringDeclarationByPattern$default((KtPsiFactory)factory2, (String)(destructuringDeclaration.isVar() ? "var ($0) = $1" : "val ($0) = $1"), (Object[])new Object[]{joinedNames, initializer2}, (boolean)false, (int)4, null);
        element3.getParent().replace((PsiElement)newDestructuringDeclaration);
    }

    public IncompleteDestructuringQuickfix(@NotNull List<String> primaryParameterNames) {
        Intrinsics.checkNotNullParameter(primaryParameterNames, (String)"primaryParameterNames");
        this.primaryParameterNames = primaryParameterNames;
    }
}

