/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeConverter;
import org.jetbrains.kotlin.j2k.Converter;
import org.jetbrains.kotlin.j2k.ConverterKt;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.ExpressionConverter;
import org.jetbrains.kotlin.j2k.ExpressionConverterKt;
import org.jetbrains.kotlin.j2k.ReferenceSearcherKt;
import org.jetbrains.kotlin.j2k.SpecialExpressionConverter;
import org.jetbrains.kotlin.j2k.SpecialStatementConverter;
import org.jetbrains.kotlin.j2k.StatementConverter;
import org.jetbrains.kotlin.j2k.StatementConverterKt;
import org.jetbrains.kotlin.j2k.TypeConverter;
import org.jetbrains.kotlin.j2k.TypeConverterKt;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.ArgumentList;
import org.jetbrains.kotlin.j2k.ast.BangBangExpression;
import org.jetbrains.kotlin.j2k.ast.Block;
import org.jetbrains.kotlin.j2k.ast.CommentsAndSpacesInheritance;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.ErrorType;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.IdentifierKt;
import org.jetbrains.kotlin.j2k.ast.LBrace;
import org.jetbrains.kotlin.j2k.ast.LPar;
import org.jetbrains.kotlin.j2k.ast.LiteralExpression;
import org.jetbrains.kotlin.j2k.ast.LocalVariable;
import org.jetbrains.kotlin.j2k.ast.MethodCallExpression;
import org.jetbrains.kotlin.j2k.ast.Nullability;
import org.jetbrains.kotlin.j2k.ast.Operator;
import org.jetbrains.kotlin.j2k.ast.ParenthesizedExpression;
import org.jetbrains.kotlin.j2k.ast.PrefixExpression;
import org.jetbrains.kotlin.j2k.ast.RBrace;
import org.jetbrains.kotlin.j2k.ast.RPar;
import org.jetbrains.kotlin.j2k.ast.Statement;
import org.jetbrains.kotlin.j2k.ast.Type;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ0\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\b\u0002\u0010#\u001a\u00020\u00182\u0014\b\u0002\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u00180%J&\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-J\u001a\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\b\b\u0002\u0010.\u001a\u00020\u0018J\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020(002\f\u00101\u001a\b\u0012\u0004\u0012\u00020*00J\u000e\u00102\u001a\u0002032\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u00010&J\u0016\u00107\u001a\u0002082\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\tJ\u000e\u00109\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010:\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u000e\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010<\u001a\u00020?J\f\u0010@\u001a\u00020\u0018*\u00020AH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/j2k/CodeConverter;", "", "converter", "Lorg/jetbrains/kotlin/j2k/Converter;", "expressionConverter", "Lorg/jetbrains/kotlin/j2k/ExpressionConverter;", "statementConverter", "Lorg/jetbrains/kotlin/j2k/StatementConverter;", "methodReturnType", "Lcom/intellij/psi/PsiType;", "(Lorg/jetbrains/kotlin/j2k/Converter;Lorg/jetbrains/kotlin/j2k/ExpressionConverter;Lorg/jetbrains/kotlin/j2k/StatementConverter;Lcom/intellij/psi/PsiType;)V", "getConverter", "()Lorg/jetbrains/kotlin/j2k/Converter;", "getMethodReturnType", "()Lcom/intellij/psi/PsiType;", "settings", "Lorg/jetbrains/kotlin/j2k/ConverterSettings;", "getSettings", "()Lorg/jetbrains/kotlin/j2k/ConverterSettings;", "typeConverter", "Lorg/jetbrains/kotlin/j2k/TypeConverter;", "getTypeConverter", "()Lorg/jetbrains/kotlin/j2k/TypeConverter;", "canChangeType", "", "variable", "Lcom/intellij/psi/PsiLocalVariable;", "convertArgumentList", "Lorg/jetbrains/kotlin/j2k/ast/ArgumentList;", "list", "Lcom/intellij/psi/PsiExpressionList;", "convertBlock", "Lorg/jetbrains/kotlin/j2k/ast/Block;", "block", "Lcom/intellij/psi/PsiCodeBlock;", "notEmpty", "statementFilter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiStatement;", "convertExpression", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "expression", "Lcom/intellij/psi/PsiExpression;", "expectedType", "expectedNullability", "Lorg/jetbrains/kotlin/j2k/ast/Nullability;", "shouldParenthesize", "convertExpressionsInList", "", "expressions", "convertLocalVariable", "Lorg/jetbrains/kotlin/j2k/ast/LocalVariable;", "convertStatement", "Lorg/jetbrains/kotlin/j2k/ast/Statement;", "statement", "convertedExpressionType", "Lorg/jetbrains/kotlin/j2k/ast/Type;", "withConverter", "withMethodReturnType", "withSpecialExpressionConverter", "specialConverter", "Lorg/jetbrains/kotlin/j2k/SpecialExpressionConverter;", "withSpecialStatementConverter", "Lorg/jetbrains/kotlin/j2k/SpecialStatementConverter;", "isLiteralWithSign", "Lcom/intellij/psi/PsiPrefixExpression;", "kotlin.j2k.old"})
public final class CodeConverter {
    @NotNull
    private final TypeConverter typeConverter;
    @NotNull
    private final ConverterSettings settings;
    @NotNull
    private final Converter converter;
    private final ExpressionConverter expressionConverter;
    private final StatementConverter statementConverter;
    @Nullable
    private final PsiType methodReturnType;

    @NotNull
    public final TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    @NotNull
    public final ConverterSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public final CodeConverter withSpecialExpressionConverter(@NotNull SpecialExpressionConverter specialConverter) {
        Intrinsics.checkNotNullParameter((Object)specialConverter, (String)"specialConverter");
        return new CodeConverter(this.converter, ExpressionConverterKt.withSpecialConverter(this.expressionConverter, specialConverter), this.statementConverter, this.methodReturnType);
    }

    @NotNull
    public final CodeConverter withSpecialStatementConverter(@NotNull SpecialStatementConverter specialConverter) {
        Intrinsics.checkNotNullParameter((Object)specialConverter, (String)"specialConverter");
        return new CodeConverter(this.converter, this.expressionConverter, StatementConverterKt.withSpecialConverter(this.statementConverter, specialConverter), this.methodReturnType);
    }

    @NotNull
    public final CodeConverter withMethodReturnType(@Nullable PsiType methodReturnType) {
        return new CodeConverter(this.converter, this.expressionConverter, this.statementConverter, methodReturnType);
    }

    @NotNull
    public final CodeConverter withConverter(@NotNull Converter converter) {
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        return new CodeConverter(converter, this.expressionConverter, this.statementConverter, this.methodReturnType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Block convertBlock(@Nullable PsiCodeBlock block, boolean notEmpty, @NotNull Function1<? super PsiStatement, Boolean> statementFilter) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(statementFilter, (String)"statementFilter");
        if (block == null) {
            return Block.Companion.getEmpty();
        }
        LBrace lBrace = (LBrace)ElementKt.assignPrototype$default(new LBrace(), (PsiElement)block.getLBrace(), null, 2, null);
        RBrace rBrace = (RBrace)ElementKt.assignPrototype$default(new RBrace(), (PsiElement)block.getRBrace(), null, 2, null);
        PsiStatement[] psiStatementArray = block.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)psiStatementArray, (String)"block.statements");
        PsiStatement[] $this$filter$iv = psiStatementArray;
        boolean $i$f$filter = false;
        PsiStatement[] psiStatementArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)statementFilter.invoke((Object)element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<Statement> collection = (List)destination$iv$iv;
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiStatement psiStatement = (PsiStatement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Statement statement = this.convertStatement((PsiStatement)it);
            collection.add(statement);
        }
        collection = (List)destination$iv$iv;
        boolean bl = notEmpty;
        RBrace rBrace2 = rBrace;
        LBrace lBrace2 = lBrace;
        List list = collection;
        return (Block)ElementKt.assignPrototype$default(new Block(list, lBrace2, rBrace2, bl), (PsiElement)block, null, 2, null);
    }

    public static /* synthetic */ Block convertBlock$default(CodeConverter codeConverter, PsiCodeBlock psiCodeBlock, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            function1 = convertBlock.1.INSTANCE;
        }
        return codeConverter.convertBlock(psiCodeBlock, bl, (Function1<? super PsiStatement, Boolean>)function1);
    }

    @NotNull
    public final Statement convertStatement(@Nullable PsiStatement statement) {
        if (statement == null) {
            return Statement.Empty.INSTANCE;
        }
        return (Statement)ElementKt.assignPrototype$default(this.statementConverter.convertStatement(statement, this), (PsiElement)statement, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Expression> convertExpressionsInList(@NotNull List<? extends PsiExpression> expressions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        Iterable $this$map$iv = expressions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiExpression psiExpression = (PsiExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Expression expression = (Expression)ElementKt.assignPrototype((Element)CodeConverter.convertExpression$default(this, (PsiExpression)it, false, 2, null), (PsiElement)it, CommentsAndSpacesInheritance.Companion.getLINE_BREAKS());
            collection.add(expression);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ArgumentList convertArgumentList(@NotNull PsiExpressionList list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Object[] objectArray = list.getExpressions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"list.expressions");
        return (ArgumentList)ElementKt.assignPrototype$default(new ArgumentList(this.convertExpressionsInList(ArraysKt.asList((Object[])objectArray)), LPar.Companion.withPrototype(UtilsKt.lPar(list)), RPar.Companion.withPrototype(UtilsKt.rPar(list))), (PsiElement)list, null, 2, null);
    }

    @NotNull
    public final Expression convertExpression(@Nullable PsiExpression expression, boolean shouldParenthesize) {
        if (expression == null) {
            return Expression.Empty.INSTANCE;
        }
        Expression converted = (Expression)ElementKt.assignPrototype$default(this.expressionConverter.convertExpression(expression, this), (PsiElement)expression, null, 2, null);
        if (shouldParenthesize) {
            return (Expression)ElementKt.assignNoPrototype((Element)new ParenthesizedExpression(converted));
        }
        return converted;
    }

    public static /* synthetic */ Expression convertExpression$default(CodeConverter codeConverter, PsiExpression psiExpression, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return codeConverter.convertExpression(psiExpression, bl);
    }

    @NotNull
    public final LocalVariable convertLocalVariable(@NotNull PsiLocalVariable variable) {
        Type type;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        boolean isVal = this.canChangeType(variable);
        Type type2 = type = this.typeConverter.convertVariableType((PsiVariable)variable);
        boolean bl = false;
        boolean bl2 = false;
        Type it = type2;
        boolean bl3 = false;
        Type explicitType = this.settings.getSpecifyLocalVariableTypeByDefault() || this.converter.shouldDeclareVariableType((PsiVariable)variable, type, isVal) ? type2 : null;
        return (LocalVariable)ElementKt.assignPrototype$default(new LocalVariable(IdentifierKt.declarationIdentifier((PsiNameIdentifierOwner)variable), Converter.convertAnnotations$default(this.converter, (PsiModifierListOwner)variable, null, 2, null), this.converter.convertModifiers((PsiModifierListOwner)variable, false, false), explicitType, CodeConverter.convertExpression$default(this, variable.getInitializer(), variable.getType(), null, 4, null), isVal), (PsiElement)variable, null, 2, null);
    }

    public final boolean canChangeType(@NotNull PsiLocalVariable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return variable.hasModifierProperty("final") || variable.getInitializer() == null || !ReferenceSearcherKt.hasWriteAccesses((PsiVariable)variable, this.converter.getReferenceSearcher(), (PsiElement)UtilsKt.getContainingMethod((PsiElement)variable));
    }

    @NotNull
    public final Expression convertExpression(@Nullable PsiExpression expression, @Nullable PsiType expectedType, @Nullable Nullability expectedNullability) {
        if (expression == null) {
            return Identifier.Companion.getEmpty();
        }
        Expression convertedExpression = CodeConverter.convertExpression$default(this, expression, false, 2, null);
        if (convertedExpression.isNullable() && expectedNullability != null && expectedNullability == Nullability.NotNull) {
            convertedExpression = BangBangExpression.Companion.surroundIfNullable(convertedExpression);
        }
        if (expectedType == null || Intrinsics.areEqual((Object)expectedType, (Object)PsiType.VOID)) {
            return convertedExpression;
        }
        PsiType psiType = expression.getType();
        if (psiType == null) {
            return convertedExpression;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"expression.type ?: return convertedExpression");
        PsiType actualType = psiType;
        if (actualType instanceof PsiPrimitiveType && Intrinsics.areEqual((Object)actualType, (Object)PsiType.NULL) ^ true || actualType instanceof PsiClassType && expectedType instanceof PsiPrimitiveType) {
            convertedExpression = BangBangExpression.Companion.surroundIfNullable(convertedExpression);
        }
        if (TypeConverterKt.needTypeConversion(actualType, expectedType)) {
            String string = expectedType.getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expectedType.canonicalText");
            String expectedTypeStr = string;
            if (expression instanceof PsiLiteralExpression) {
                if (Intrinsics.areEqual((Object)actualType.getCanonicalText(), (Object)"char") && !(((PsiLiteralExpression)expression).getParent() instanceof PsiExpressionList)) {
                    String string2 = TypeConverterKt.getTypeConversionMethod(expression, expectedType);
                    if (string2 != null) {
                        String string3 = string2;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string3;
                        boolean bl3 = false;
                        convertedExpression = MethodCallExpression.Companion.buildNonNull$default(MethodCallExpression.Companion, convertedExpression, it, null, null, null, 28, null);
                    }
                } else if (Intrinsics.areEqual((Object)expectedTypeStr, (Object)"float") || Intrinsics.areEqual((Object)expectedTypeStr, (Object)"double")) {
                    String text2 = ElementKt.canonicalCode(convertedExpression);
                    if (SetsKt.setOf((Object[])new Character[]{Character.valueOf('f'), Character.valueOf('L')}).contains(Character.valueOf(StringsKt.last((CharSequence)text2)))) {
                        String string4 = text2;
                        int n = 0;
                        int n2 = text2.length() - 1;
                        boolean bl = false;
                        String string5 = string4;
                        if (string5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string6 = string5.substring(n, n2);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        text2 = string6;
                    }
                    if (Intrinsics.areEqual((Object)expectedTypeStr, (Object)"float")) {
                        text2 = text2 + "f";
                    }
                    if (Intrinsics.areEqual((Object)expectedTypeStr, (Object)"double") && !StringsKt.contains$default((CharSequence)text2, (CharSequence)".", (boolean)false, (int)2, null) && !StringsKt.contains((CharSequence)text2, (CharSequence)"e", (boolean)true)) {
                        text2 = text2 + ".0";
                    }
                    convertedExpression = new LiteralExpression(text2);
                } else if (Intrinsics.areEqual((Object)expectedTypeStr, (Object)"long")) {
                    if (((PsiLiteralExpression)expression).getParent() instanceof PsiBinaryExpression) {
                        convertedExpression = new LiteralExpression(ElementKt.canonicalCode(convertedExpression) + 'L');
                    }
                } else if (Intrinsics.areEqual((Object)expectedTypeStr, (Object)"char")) {
                    convertedExpression = MethodCallExpression.Companion.buildNonNull$default(MethodCallExpression.Companion, convertedExpression, "toChar", null, null, null, 28, null);
                }
            } else if (expression instanceof PsiPrefixExpression && this.isLiteralWithSign((PsiPrefixExpression)expression)) {
                Expression operandConverted = CodeConverter.convertExpression$default(this, ((PsiPrefixExpression)expression).getOperand(), expectedType, null, 4, null);
                PsiJavaToken psiJavaToken = ((PsiPrefixExpression)expression).getOperationSign();
                Intrinsics.checkNotNullExpressionValue((Object)psiJavaToken, (String)"expression.operationSign");
                IElementType iElementType = psiJavaToken.getTokenType();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"expression.operationSign.tokenType");
                convertedExpression = new PrefixExpression((Operator)ElementKt.assignPrototype$default(new Operator(iElementType), (PsiElement)((PsiPrefixExpression)expression).getOperationSign(), null, 2, null), operandConverted);
            } else {
                String conversion = ConverterKt.getPRIMITIVE_TYPE_CONVERSIONS().get(expectedTypeStr);
                if (conversion != null) {
                    convertedExpression = MethodCallExpression.Companion.buildNonNull$default(MethodCallExpression.Companion, convertedExpression, conversion, null, null, null, 28, null);
                }
            }
        }
        return (Expression)ElementKt.assignPrototype$default(convertedExpression, (PsiElement)expression, null, 2, null);
    }

    public static /* synthetic */ Expression convertExpression$default(CodeConverter codeConverter, PsiExpression psiExpression, PsiType psiType, Nullability nullability, int n, Object object) {
        if ((n & 4) != 0) {
            nullability = null;
        }
        return codeConverter.convertExpression(psiExpression, psiType, nullability);
    }

    @NotNull
    public final Type convertedExpressionType(@NotNull PsiExpression expression, @NotNull PsiType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        CodeConverter codeConverter = this.converter.getCodeConverterForType();
        boolean bl = false;
        boolean bl2 = false;
        CodeConverter $this$with = codeConverter;
        boolean bl3 = false;
        Expression convertedExpression = CodeConverter.convertExpression$default($this$with, expression, false, 2, null);
        PsiType psiType = expression.getType();
        if (psiType == null) {
            return new ErrorType();
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"expression.type ?: return ErrorType()");
        PsiType actualType = psiType;
        Type resultType = TypeConverter.convertType$default($this$with.typeConverter, actualType, convertedExpression.isNullable() ? Nullability.Nullable : Nullability.NotNull, null, false, 12, null);
        if (actualType instanceof PsiPrimitiveType && resultType.isNullable() || expectedType instanceof PsiPrimitiveType && actualType instanceof PsiClassType) {
            resultType = resultType.toNotNullType();
        }
        if (TypeConverterKt.needTypeConversion(actualType, expectedType)) {
            boolean willConvert;
            String string = expectedType.getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expectedType.canonicalText");
            String expectedTypeStr = string;
            boolean bl4 = convertedExpression instanceof LiteralExpression || expression instanceof PsiPrefixExpression && $this$with.isLiteralWithSign((PsiPrefixExpression)expression) ? Intrinsics.areEqual((Object)expectedTypeStr, (Object)"float") || Intrinsics.areEqual((Object)expectedTypeStr, (Object)"double") : (willConvert = ConverterKt.getPRIMITIVE_TYPE_CONVERSIONS().get(expectedTypeStr) != null);
            if (willConvert) {
                resultType = TypeConverter.convertType$default($this$with.typeConverter, expectedType, Nullability.NotNull, null, false, 12, null);
            }
        }
        return resultType;
    }

    private final boolean isLiteralWithSign(PsiPrefixExpression $this$isLiteralWithSign) {
        return $this$isLiteralWithSign.getOperand() instanceof PsiLiteralExpression && SetsKt.setOf((Object[])new IElementType[]{JavaTokenType.PLUS, JavaTokenType.MINUS}).contains($this$isLiteralWithSign.getOperationTokenType());
    }

    @NotNull
    public final Converter getConverter() {
        return this.converter;
    }

    @Nullable
    public final PsiType getMethodReturnType() {
        return this.methodReturnType;
    }

    public CodeConverter(@NotNull Converter converter, @NotNull ExpressionConverter expressionConverter, @NotNull StatementConverter statementConverter, @Nullable PsiType methodReturnType) {
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        Intrinsics.checkNotNullParameter((Object)expressionConverter, (String)"expressionConverter");
        Intrinsics.checkNotNullParameter((Object)statementConverter, (String)"statementConverter");
        this.converter = converter;
        this.expressionConverter = expressionConverter;
        this.statementConverter = statementConverter;
        this.methodReturnType = methodReturnType;
        this.typeConverter = this.converter.getTypeConverter();
        this.settings = this.converter.getSettings();
    }
}

