/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.youtrack.lang;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.tasks.youtrack.YouTrackIntellisense;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YouTrackHighlightingAnnotator
extends ExternalAnnotator<QueryInfo, List<YouTrackIntellisense.HighlightRange>> {
    private static final Logger LOG = Logger.getInstance(YouTrackHighlightingAnnotator.class);

    @Nullable
    public QueryInfo collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        YouTrackIntellisense intellisense;
        if (file == null) {
            YouTrackHighlightingAnnotator.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            YouTrackHighlightingAnnotator.$$$reportNull$$$0(1);
        }
        if ((intellisense = (YouTrackIntellisense)file.getUserData(YouTrackIntellisense.INTELLISENSE_KEY)) == null || !intellisense.getRepository().isConfigured()) {
            return null;
        }
        String text = file.getText();
        int offset = editor.getCaretModel().getOffset();
        return new QueryInfo(offset, text, intellisense);
    }

    @Nullable
    public List<YouTrackIntellisense.HighlightRange> doAnnotate(QueryInfo collectedInfo) {
        if (collectedInfo == null) {
            return Collections.emptyList();
        }
        String query = collectedInfo.myText;
        int offset = collectedInfo.myCaretOffset;
        try {
            return collectedInfo.myIntellisense.fetchHighlighting(query, offset);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public void apply(@NotNull PsiFile file, List<YouTrackIntellisense.HighlightRange> ranges, @NotNull AnnotationHolder holder) {
        if (file == null) {
            YouTrackHighlightingAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            YouTrackHighlightingAnnotator.$$$reportNull$$$0(3);
        }
        for (YouTrackIntellisense.HighlightRange range : ranges) {
            if (range.getStyleClass().equals("error")) {
                holder.newSilentAnnotation(HighlightSeverity.ERROR).range(range.getTextRange()).create();
                continue;
            }
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(range.getTextRange()).enforcedTextAttributes(range.getTextAttributes()).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/tasks/youtrack/lang/YouTrackHighlightingAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectInformation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class QueryInfo {
        private final int myCaretOffset;
        private final String myText;
        private final YouTrackIntellisense myIntellisense;

        private QueryInfo(int caretOffset, String text, YouTrackIntellisense repository) {
            this.myCaretOffset = caretOffset;
            this.myText = text;
            this.myIntellisense = repository;
        }
    }
}

