/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameViewModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiManager;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.actions.GotoTaskAction;
import com.intellij.tasks.actions.TaskSearchSupport;
import com.intellij.tasks.doc.TaskPsiElement;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

class TaskItemProvider
implements ChooseByNameItemProvider,
Disposable {
    private static final Logger LOG = Logger.getInstance(TaskItemProvider.class);
    private static final int DELAY_PERIOD = 200;
    private final Project myProject;
    private int myCurrentOffset = 0;
    private boolean myOldEverywhere = false;
    private String myOldPattern = "";
    private final AtomicReference<Future<List<Task>>> myFutureReference = new AtomicReference();
    private boolean myDisposed;

    TaskItemProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameBase base, String @NotNull [] names, @NotNull String pattern) {
        if (base == null) {
            TaskItemProvider.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            TaskItemProvider.$$$reportNull$$$0(1);
        }
        if (names == null) {
            TaskItemProvider.$$$reportNull$$$0(2);
        }
        List<String> list = this.filterNames((ChooseByNameViewModel)base, names, pattern);
        if (list == null) {
            TaskItemProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameViewModel base, String @NotNull [] names, @NotNull String pattern) {
        if (base == null) {
            TaskItemProvider.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            TaskItemProvider.$$$reportNull$$$0(5);
        }
        if (names == null) {
            TaskItemProvider.$$$reportNull$$$0(6);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TaskItemProvider.$$$reportNull$$$0(7);
        }
        return list;
    }

    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator cancelled, @NotNull Processor<Object> consumer) {
        if (base == null) {
            TaskItemProvider.$$$reportNull$$$0(8);
        }
        if (pattern == null) {
            TaskItemProvider.$$$reportNull$$$0(9);
        }
        if (cancelled == null) {
            TaskItemProvider.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            TaskItemProvider.$$$reportNull$$$0(11);
        }
        return this.filterElements((ChooseByNameViewModel)base, pattern, everywhere, cancelled, consumer);
    }

    public boolean filterElements(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator cancelled, @NotNull Processor<Object> consumer) {
        if (base == null) {
            TaskItemProvider.$$$reportNull$$$0(12);
        }
        if (pattern == null) {
            TaskItemProvider.$$$reportNull$$$0(13);
        }
        if (cancelled == null) {
            TaskItemProvider.$$$reportNull$$$0(14);
        }
        if (consumer == null) {
            TaskItemProvider.$$$reportNull$$$0(15);
        }
        GotoTaskAction.CREATE_NEW_TASK_ACTION.setTaskName(pattern);
        if (!consumer.process((Object)GotoTaskAction.CREATE_NEW_TASK_ACTION)) {
            return false;
        }
        TaskManager taskManager = TaskManager.getManager((Project)this.myProject);
        List allCachedAndLocalTasks = ContainerUtil.concat((List)taskManager.getCachedIssues(), (List)taskManager.getLocalTasks());
        List<Task> filteredCachedAndLocalTasks = TaskSearchSupport.getLocalAndCachedTasks(taskManager, pattern, everywhere);
        if (!this.processTasks(filteredCachedAndLocalTasks, consumer, cancelled)) {
            return false;
        }
        if (filteredCachedAndLocalTasks.size() >= base.getMaximumListSizeLimit()) {
            return true;
        }
        if (this.myDisposed) {
            return false;
        }
        int delay = this.myFutureReference.get() == null && pattern.length() > 5 ? 0 : 200;
        ScheduledFuture<List> future = JobScheduler.getScheduler().schedule(() -> this.fetchFromServer(pattern, everywhere, cancelled), (long)delay, TimeUnit.MILLISECONDS);
        Future oldFuture = this.myFutureReference.getAndSet(future);
        if (oldFuture != null) {
            LOG.debug("Cancelling existing task");
            oldFuture.cancel(true);
        }
        try {
            List tasks;
            while (true) {
                try {
                    tasks = (List)future.get(10L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    continue;
                }
                break;
            }
            this.myFutureReference.compareAndSet(future, null);
            tasks.removeAll(allCachedAndLocalTasks);
            return this.processTasks(tasks, consumer, cancelled);
        }
        catch (InterruptedException interrupted) {
            Thread.interrupted();
        }
        catch (CancellationException e) {
            LOG.debug("Task cancelled");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ProcessCanceledException) {
                LOG.debug("Task cancelled via progress indicator");
            }
            ExceptionUtil.rethrow((Throwable)cause);
        }
        return false;
    }

    private List<Task> fetchFromServer(String pattern, boolean everywhere, ProgressIndicator cancelled) {
        int limit;
        int offset;
        if (!this.myOldPattern.equals(pattern)) {
            offset = 0;
            this.myCurrentOffset = 0;
            limit = 20;
        } else if (this.myOldEverywhere != everywhere) {
            offset = 0;
            this.myCurrentOffset = limit = this.myCurrentOffset + 20;
        } else {
            offset = this.myCurrentOffset;
            limit = 20;
            this.myCurrentOffset += 20;
        }
        List<Task> tasks = TaskSearchSupport.getRepositoriesTasks(this.myProject, pattern, offset, limit, true, everywhere, cancelled);
        this.myOldEverywhere = everywhere;
        this.myOldPattern = pattern;
        return tasks;
    }

    private boolean processTasks(List<Task> tasks, Processor<Object> consumer, ProgressIndicator cancelled) {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (Task task : tasks) {
            cancelled.checkCanceled();
            if (consumer.process((Object)new TaskPsiElement(psiManager, task))) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        Future<List<Task>> future = this.myFutureReference.get();
        if (future != null) {
            future.cancel(true);
        }
        this.myDisposed = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/actions/TaskItemProvider";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelled";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/actions/TaskItemProvider";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterNames";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

