/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.service.scopes.VirtualFileSystemServices;
import org.gradle.internal.vfs.VirtualFileSystem;
import org.gradle.internal.watch.vfs.BuildLifecycleAwareVirtualFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemWatchingBuildActionRunner
implements BuildActionRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemWatchingBuildActionRunner.class);
    private final BuildActionRunner delegate;

    public FileSystemWatchingBuildActionRunner(BuildActionRunner delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildActionRunner.Result run(BuildAction action, BuildController buildController) {
        GradleInternal gradle = buildController.getGradle();
        StartParameterInternal startParameter = gradle.getStartParameter();
        BuildLifecycleAwareVirtualFileSystem virtualFileSystem = gradle.getServices().get(BuildLifecycleAwareVirtualFileSystem.class);
        BuildOperationRunner buildOperationRunner = gradle.getServices().get(BuildOperationRunner.class);
        boolean watchFileSystem = startParameter.isWatchFileSystem();
        BuildLifecycleAwareVirtualFileSystem.VfsLogging verboseVfsLogging = startParameter.isVfsVerboseLogging() ? BuildLifecycleAwareVirtualFileSystem.VfsLogging.VERBOSE : BuildLifecycleAwareVirtualFileSystem.VfsLogging.NORMAL;
        BuildLifecycleAwareVirtualFileSystem.WatchLogging debugWatchLogging = startParameter.isWatchFileSystemDebugLogging() ? BuildLifecycleAwareVirtualFileSystem.WatchLogging.DEBUG : BuildLifecycleAwareVirtualFileSystem.WatchLogging.NORMAL;
        FileSystemWatchingBuildActionRunner.logMessageForDeprecatedWatchFileSystemProperty(startParameter);
        FileSystemWatchingBuildActionRunner.logMessageForDeprecatedVfsRetentionProperty(startParameter);
        LOGGER.info("Watching the file system is {}", (Object)(watchFileSystem ? "enabled" : "disabled"));
        if (watchFileSystem) {
            FileSystemWatchingBuildActionRunner.dropVirtualFileSystemIfRequested(startParameter, virtualFileSystem);
        }
        virtualFileSystem.afterBuildStarted(watchFileSystem, verboseVfsLogging, debugWatchLogging, buildOperationRunner);
        try {
            BuildActionRunner.Result result = this.delegate.run(action, buildController);
            return result;
        }
        finally {
            int maximumNumberOfWatchedHierarchies = VirtualFileSystemServices.getMaximumNumberOfWatchedHierarchies(startParameter);
            virtualFileSystem.beforeBuildFinished(watchFileSystem, verboseVfsLogging, debugWatchLogging, buildOperationRunner, maximumNumberOfWatchedHierarchies);
        }
    }

    private static void dropVirtualFileSystemIfRequested(StartParameterInternal startParameter, BuildLifecycleAwareVirtualFileSystem virtualFileSystem) {
        if (VirtualFileSystemServices.isDropVfs(startParameter)) {
            virtualFileSystem.update(VirtualFileSystem.INVALIDATE_ALL);
        }
    }

    private static void logMessageForDeprecatedWatchFileSystemProperty(StartParameterInternal startParameter) {
        if (startParameter.isWatchFileSystemUsingDeprecatedOption()) {
            String deprecatedWatchFsProperty = "org.gradle.unsafe.watch-fs";
            ((DeprecationMessageBuilder.DeprecateSystemProperty)DeprecationLogger.deprecateSystemProperty(deprecatedWatchFsProperty).replaceWith("org.gradle.vfs.watch")).willBeRemovedInGradle7().withUserManual("gradle_daemon").nagUser();
        }
    }

    private static void logMessageForDeprecatedVfsRetentionProperty(StartParameterInternal startParameter) {
        if (VirtualFileSystemServices.isDeprecatedVfsRetentionPropertyPresent(startParameter)) {
            String deprecatedVfsRetentionEnabledProperty = "org.gradle.unsafe.vfs.retention";
            ((DeprecationMessageBuilder)DeprecationLogger.deprecateIndirectUsage("Using the system property " + deprecatedVfsRetentionEnabledProperty + " to enable watching the file system").withAdvice("Use the gradle property org.gradle.vfs.watch instead.")).willBeRemovedInGradle7().withUserManual("gradle_daemon").nagUser();
        }
    }
}

