/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Cast;
import org.gradle.internal.Pair;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.Collections2;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.LinkedHashMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.metaobject.DynamicObjectUtil;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;
import org.gradle.plugins.ide.eclipse.model.internal.PathUtil;
import org.gradle.util.CollectionUtils;

public class SourceFoldersCreator {
    public List<SourceFolder> createSourceFolders(final EclipseClasspath classpath) {
        Function<File, String> provideRelativePath = new Function<File, String>(){

            public String apply(File input) {
                return classpath.getProject().relativePath(input);
            }
        };
        List<SourceFolder> sourceFolders = this.projectRelativeFolders(classpath.getSourceSets(), provideRelativePath, classpath.getDefaultOutputDir());
        return this.collectRegularAndExternalSourceFolders(sourceFolders, new Function<Pair<Collection<SourceFolder>, Collection<SourceFolder>>, List<SourceFolder>>(){

            public List<SourceFolder> apply(Pair<Collection<SourceFolder>, Collection<SourceFolder>> sourceFolders) {
                ArrayList entries = Lists.newArrayListWithCapacity((int)(sourceFolders.getLeft().size() + sourceFolders.getRight().size()));
                entries.addAll(sourceFolders.getLeft());
                entries.addAll(sourceFolders.getRight());
                return entries;
            }
        });
    }

    public List<SourceFolder> getBasicExternalSourceFolders(Iterable<SourceSet> sourceSets, Function<File, String> provideRelativePath, File defaultOutputDir) {
        List<SourceFolder> basicSourceFolders = this.basicProjectRelativeFolders(sourceSets, provideRelativePath, defaultOutputDir);
        return this.collectRegularAndExternalSourceFolders(basicSourceFolders, new Function<Pair<Collection<SourceFolder>, Collection<SourceFolder>>, List<SourceFolder>>(){

            public List<SourceFolder> apply(Pair<Collection<SourceFolder>, Collection<SourceFolder>> sourceFolders) {
                return Lists.newArrayList((Iterable)sourceFolders.right());
            }
        });
    }

    private <T> T collectRegularAndExternalSourceFolders(List<SourceFolder> sourceFolder, Function<Pair<Collection<SourceFolder>, Collection<SourceFolder>>, T> collector) {
        Pair<Collection<SourceFolder>, Collection<SourceFolder>> partitionedFolders = CollectionUtils.partition(sourceFolder, new Spec<SourceFolder>(){

            @Override
            public boolean isSatisfiedBy(SourceFolder sourceFolder) {
                return sourceFolder.getPath().contains("..");
            }
        });
        Collection<SourceFolder> externalSourceFolders = partitionedFolders.getLeft();
        Collection<SourceFolder> regularSourceFolders = partitionedFolders.getRight();
        ArrayList sources = Lists.newArrayList((Iterable)Collections2.transform(regularSourceFolders, (Function)new Function<SourceFolder, String>(){

            public String apply(SourceFolder sourceFolder) {
                return sourceFolder.getName();
            }
        }));
        List<SourceFolder> dedupedExternalSourceFolders = this.trimAndDedup(externalSourceFolders, sources);
        return (T)collector.apply(Pair.of(regularSourceFolders, dedupedExternalSourceFolders));
    }

    private List<SourceFolder> projectRelativeFolders(Iterable<SourceSet> sourceSets, Function<File, String> provideRelativePath, File defaultOutputDir) {
        String defaultOutputPath = PathUtil.normalizePath((String)provideRelativePath.apply((Object)defaultOutputDir));
        ArrayList entries = Lists.newArrayList();
        List<SourceSet> sortedSourceSets = this.sortSourceSetsAsPerUsualConvention(sourceSets);
        Map<SourceSet, String> sourceSetOutputPaths = this.collectSourceSetOutputPaths(sortedSourceSets, defaultOutputPath);
        Multimap<SourceSet, SourceSet> sourceSetUsages = this.getSourceSetUsages(sortedSourceSets);
        for (SourceSet sourceSet : sortedSourceSets) {
            List<DirectoryTree> sortedSourceDirs = this.sortSourceDirsAsPerUsualConvention(sourceSet.getAllSource().getSrcDirTrees());
            for (DirectoryTree tree : sortedSourceDirs) {
                File dir = tree.getDir();
                if (!dir.isDirectory()) continue;
                String relativePath = (String)provideRelativePath.apply((Object)dir);
                SourceFolder folder = new SourceFolder(relativePath, null);
                folder.setDir(dir);
                folder.setName(dir.getName());
                folder.setIncludes(this.getIncludesForTree(sourceSet, tree));
                folder.setExcludes(this.getExcludesForTree(sourceSet, tree));
                folder.setOutput(sourceSetOutputPaths.get(sourceSet));
                this.addScopeAttributes(folder, sourceSet, sourceSetUsages);
                this.addSourceSetAttribute(sourceSet, folder);
                entries.add(folder);
            }
        }
        return entries;
    }

    private List<SourceFolder> basicProjectRelativeFolders(Iterable<SourceSet> sourceSets, Function<File, String> provideRelativePath, File defaultOutputDir) {
        ArrayList entries = Lists.newArrayList();
        List<SourceSet> sortedSourceSets = this.sortSourceSetsAsPerUsualConvention(sourceSets);
        for (SourceSet sourceSet : sortedSourceSets) {
            List<DirectoryTree> sortedSourceDirs = this.sortSourceDirsAsPerUsualConvention(sourceSet.getAllSource().getSrcDirTrees());
            for (DirectoryTree tree : sortedSourceDirs) {
                File dir = tree.getDir();
                if (!dir.isDirectory()) continue;
                SourceFolder folder = new SourceFolder((String)provideRelativePath.apply((Object)dir), null);
                folder.setDir(dir);
                folder.setName(dir.getName());
                entries.add(folder);
            }
        }
        return entries;
    }

    private List<SourceFolder> trimAndDedup(Collection<SourceFolder> externalSourceFolders, List<String> givenSources) {
        ArrayList trimmedSourceFolders = Lists.newArrayList();
        for (SourceFolder folder : externalSourceFolders) {
            folder.trim();
            for (File parentFile = folder.getDir().getParentFile(); givenSources.contains(folder.getName()) && parentFile != null; parentFile = parentFile.getParentFile()) {
                folder.trim(parentFile.getName());
            }
            givenSources.add(folder.getName());
            trimmedSourceFolders.add(folder);
        }
        return trimmedSourceFolders;
    }

    private void addScopeAttributes(SourceFolder folder, SourceSet sourceSet, Multimap<SourceSet, SourceSet> sourceSetUsages) {
        folder.getEntryAttributes().put("gradle_scope", this.sanitizeNameForAttribute(sourceSet));
        folder.getEntryAttributes().put("gradle_used_by_scope", Joiner.on((char)',').join(this.getUsingSourceSetNames(sourceSet, sourceSetUsages)));
    }

    private List<String> getUsingSourceSetNames(SourceSet sourceSet, Multimap<SourceSet, SourceSet> sourceSetUsages) {
        Collection usingSourceSets = sourceSetUsages.get((Object)sourceSet);
        ArrayList usingSourceSetNames = Lists.newArrayList();
        for (SourceSet usingSourceSet : usingSourceSets) {
            usingSourceSetNames.add(this.sanitizeNameForAttribute(usingSourceSet));
        }
        return usingSourceSetNames;
    }

    private String sanitizeNameForAttribute(SourceSet sourceSet) {
        return sourceSet.getName().replaceAll(",", "");
    }

    private Multimap<SourceSet, SourceSet> getSourceSetUsages(Iterable<SourceSet> sourceSets) {
        LinkedHashMultimap usages = LinkedHashMultimap.create();
        for (SourceSet sourceSet : sourceSets) {
            for (SourceSet otherSourceSet : sourceSets) {
                if (!this.containsOutputOf(sourceSet, otherSourceSet)) continue;
                usages.put((Object)otherSourceSet, (Object)sourceSet);
            }
        }
        return usages;
    }

    private boolean containsOutputOf(SourceSet sourceSet, SourceSet otherSourceSet) {
        try {
            return this.containsAll(sourceSet.getRuntimeClasspath(), otherSourceSet.getOutput());
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean containsAll(FileCollection first, FileCollection second) {
        for (File file : second) {
            if (first.contains(file)) continue;
            return false;
        }
        return true;
    }

    private void addSourceSetAttribute(SourceSet sourceSet, SourceFolder folder) {
        String name = sourceSet.getName();
        if (!"main".equals(name) && ("test".equals(name) || folder.getPath().toLowerCase().contains("test"))) {
            folder.getEntryAttributes().put("test", "true");
        }
    }

    private Map<SourceSet, String> collectSourceSetOutputPaths(Iterable<SourceSet> sourceSets, String defaultOutputPath) {
        HashSet existingPaths = Sets.newHashSet((Object[])new String[]{defaultOutputPath});
        HashMap result = Maps.newHashMap();
        for (SourceSet sourceSet : sourceSets) {
            String path = this.collectSourceSetOutputPath(sourceSet.getName(), existingPaths, "");
            existingPaths.add(path);
            result.put(sourceSet, path);
        }
        return result;
    }

    private String collectSourceSetOutputPath(String sourceSetName, Set<String> existingPaths, String suffix) {
        String path = "bin/" + sourceSetName + suffix;
        return existingPaths.contains(path) ? this.collectSourceSetOutputPath(sourceSetName, existingPaths, suffix + "_") : path;
    }

    private List<String> getExcludesForTree(SourceSet sourceSet, DirectoryTree directoryTree) {
        List<Set<String>> excludesByType = this.getFiltersForTreeGroupedByType(sourceSet, directoryTree, "excludes");
        return CollectionUtils.intersection(excludesByType);
    }

    private List<String> getIncludesForTree(SourceSet sourceSet, DirectoryTree directoryTree) {
        List<Set<String>> includesByType = this.getFiltersForTreeGroupedByType(sourceSet, directoryTree, "includes");
        for (Set<String> it : includesByType) {
            if (!it.isEmpty()) continue;
            return Collections.emptyList();
        }
        List<String> allIncludes = CollectionUtils.flattenCollections(String.class, includesByType);
        return ImmutableSet.copyOf(allIncludes).asList();
    }

    private List<Set<String>> getFiltersForTreeGroupedByType(SourceSet sourceSet, DirectoryTree directoryTree, String filterOperation) {
        Set<File> javaSrcDirs = sourceSet.getAllJava().getSrcDirs();
        Set<File> resSrcDirs = sourceSet.getResources().getSrcDirs();
        List srcDirs = CollectionUtils.intersection(Lists.newArrayList((Object[])new Set[]{javaSrcDirs, resSrcDirs}));
        if (!srcDirs.contains(directoryTree.getDir())) {
            return Lists.newArrayList((Object[])new Set[]{this.collectFilters(directoryTree.getPatterns(), filterOperation)});
        }
        Set<String> resourcesFilter = this.collectFilters(sourceSet.getResources().getSrcDirTrees(), directoryTree.getDir(), filterOperation);
        Set<String> sourceFilter = this.collectFilters(sourceSet.getAllJava().getSrcDirTrees(), directoryTree.getDir(), filterOperation);
        return Lists.newArrayList((Object[])new Set[]{resourcesFilter, sourceFilter});
    }

    private Set<String> collectFilters(Set<DirectoryTree> directoryTrees, File targetDir, String filterOperation) {
        for (DirectoryTree directoryTree : directoryTrees) {
            if (!directoryTree.getDir().equals(targetDir)) continue;
            PatternSet patterns = directoryTree.getPatterns();
            return this.collectFilters(patterns, filterOperation);
        }
        return Collections.emptySet();
    }

    private Set<String> collectFilters(PatternSet patterns, String filterOperation) {
        return (Set)Cast.uncheckedCast(DynamicObjectUtil.asDynamicObject(patterns).getProperty(filterOperation));
    }

    private List<SourceSet> sortSourceSetsAsPerUsualConvention(Iterable<SourceSet> sourceSets) {
        return CollectionUtils.sort(sourceSets, new Comparator<SourceSet>(){

            @Override
            public int compare(SourceSet left, SourceSet right) {
                return SourceFoldersCreator.toComparable(left).compareTo(SourceFoldersCreator.toComparable(right));
            }
        });
    }

    private List<DirectoryTree> sortSourceDirsAsPerUsualConvention(Iterable<DirectoryTree> sourceDirs) {
        return CollectionUtils.sort(sourceDirs, new Comparator<DirectoryTree>(){

            @Override
            public int compare(DirectoryTree left, DirectoryTree right) {
                return SourceFoldersCreator.toComparable(left).compareTo(SourceFoldersCreator.toComparable(right));
            }
        });
    }

    private static Integer toComparable(SourceSet sourceSet) {
        String name = sourceSet.getName();
        if ("main".equals(name)) {
            return 0;
        }
        if ("test".equals(name)) {
            return 1;
        }
        return 2;
    }

    private static Integer toComparable(DirectoryTree tree) {
        String path = tree.getDir().getPath();
        if (path.endsWith("java")) {
            return 0;
        }
        if (path.endsWith("resources")) {
            return 2;
        }
        return 1;
    }
}

