/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Optional;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.install.internal.JavaToolchainProvisioningService;
import org.gradle.jvm.toolchain.internal.DefaultToolchainSpec;
import org.gradle.jvm.toolchain.internal.JavaToolchain;
import org.gradle.jvm.toolchain.internal.JavaToolchainComparator;
import org.gradle.jvm.toolchain.internal.JavaToolchainFactory;
import org.gradle.jvm.toolchain.internal.NoToolchainAvailableException;
import org.gradle.jvm.toolchain.internal.SharedJavaInstallationRegistry;

public class JavaToolchainQueryService {
    private final SharedJavaInstallationRegistry registry;
    private final JavaToolchainFactory toolchainFactory;
    private final JavaToolchainProvisioningService installService;
    private final Provider<Boolean> detectEnabled;
    private final Provider<Boolean> downloadEnabled;

    @Inject
    public JavaToolchainQueryService(SharedJavaInstallationRegistry registry, JavaToolchainFactory toolchainFactory, JavaToolchainProvisioningService provisioningService, ProviderFactory factory) {
        this.registry = registry;
        this.toolchainFactory = toolchainFactory;
        this.installService = provisioningService;
        this.detectEnabled = factory.gradleProperty("org.gradle.java.installations.auto-detect").forUseAtConfigurationTime().map(Boolean::parseBoolean);
        this.downloadEnabled = factory.gradleProperty("org.gradle.java.installations.auto-download").forUseAtConfigurationTime().map(Boolean::parseBoolean);
    }

    <T> Provider<T> toolFor(JavaToolchainSpec spec, Transformer<T, JavaToolchain> toolFunction) {
        return this.findMatchingToolchain(spec).map(toolFunction);
    }

    Provider<JavaToolchain> findMatchingToolchain(JavaToolchainSpec filter) {
        return new DefaultProvider<JavaToolchain>(() -> {
            if (((DefaultToolchainSpec)filter).isConfigured()) {
                return this.query(filter);
            }
            return null;
        });
    }

    private JavaToolchain query(JavaToolchainSpec filter) {
        return this.registry.listInstallations().stream().map(this::asToolchain).filter(this.matchingToolchain(filter)).sorted(new JavaToolchainComparator()).findFirst().orElseGet(() -> this.downloadToolchain(filter));
    }

    private JavaToolchain downloadToolchain(JavaToolchainSpec spec) {
        Optional<File> installation = this.installService.tryInstall(spec);
        return installation.map(this::asToolchain).orElseThrow(() -> this.noToolchainAvailable(spec));
    }

    private NoToolchainAvailableException noToolchainAvailable(JavaToolchainSpec spec) {
        return new NoToolchainAvailableException(spec, this.detectEnabled.getOrElse(true), this.downloadEnabled.getOrElse(true));
    }

    private Predicate<JavaToolchain> matchingToolchain(JavaToolchainSpec spec) {
        return toolchain -> toolchain.getLanguageVersion().equals(spec.getLanguageVersion().get());
    }

    private JavaToolchain asToolchain(File javaHome) {
        return this.toolchainFactory.newInstance(javaHome);
    }
}

