/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.jvm.toolchain.internal.AutoDetectingInstallationSupplier;
import org.gradle.jvm.toolchain.internal.FileBasedInstallationFactory;
import org.gradle.jvm.toolchain.internal.InstallationLocation;

public class AsdfInstallationSupplier
extends AutoDetectingInstallationSupplier {
    private final Provider<String> asdfDataDir = this.getEnvironmentProperty("ASDF_DATA_DIR");
    private final Provider<String> asdfUserHome = this.getSystemProperty("user.home").map(home -> new File((String)home, ".asdf").getAbsolutePath());

    @Inject
    public AsdfInstallationSupplier(ProviderFactory factory) {
        super(factory);
    }

    @Override
    protected Set<InstallationLocation> findCandidates() {
        return this.asdfDataDir.map(this.findJavaCandidates()).orElse(this.asdfUserHome.map(this.findJavaCandidates())).getOrElse(Collections.emptySet());
    }

    private Transformer<Set<InstallationLocation>, String> findJavaCandidates() {
        return candidatesDir -> {
            File root = new File((String)candidatesDir, "installs/java");
            return FileBasedInstallationFactory.fromDirectory(root, "asdf-vm");
        };
    }
}

