/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.gradle.authentication.Authentication;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.base.Supplier;
import org.gradle.internal.impldep.com.google.common.base.Suppliers;
import org.gradle.internal.impldep.org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.gradle.internal.resource.transport.http.HttpProxySettings;
import org.gradle.internal.resource.transport.http.HttpSettings;
import org.gradle.internal.resource.transport.http.HttpTimeoutSettings;
import org.gradle.internal.resource.transport.http.JavaSystemPropertiesHttpProxySettings;
import org.gradle.internal.resource.transport.http.JavaSystemPropertiesHttpTimeoutSettings;
import org.gradle.internal.resource.transport.http.JavaSystemPropertiesSecureHttpProxySettings;
import org.gradle.internal.resource.transport.http.SslContextFactory;
import org.gradle.internal.verifier.HttpRedirectVerifier;

public class DefaultHttpSettings
implements HttpSettings {
    private final Collection<Authentication> authenticationSettings;
    private final SslContextFactory sslContextFactory;
    private final HostnameVerifier hostnameVerifier;
    private final HttpRedirectVerifier redirectVerifier;
    private final boolean followRedirects;
    private HttpProxySettings proxySettings;
    private HttpProxySettings secureProxySettings;
    private HttpTimeoutSettings timeoutSettings;
    private static final HostnameVerifier ALL_TRUSTING_HOSTNAME_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    private static final SslContextFactory ALL_TRUSTING_SSL_CONTEXT_FACTORY = new SslContextFactory(){
        private final Supplier<SSLContext> sslContextSupplier = Suppliers.memoize((Supplier)new Supplier<SSLContext>(){

            public SSLContext get() {
                try {
                    SSLContext sslcontext = SSLContext.getInstance("TLS");
                    sslcontext.init(null, allTrustingTrustManager, null);
                    return sslcontext;
                }
                catch (GeneralSecurityException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
        });
        private final TrustManager[] allTrustingTrustManager = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};

        @Override
        public SSLContext createSslContext() {
            return (SSLContext)this.sslContextSupplier.get();
        }
    };

    public static Builder builder() {
        return new Builder();
    }

    private DefaultHttpSettings(Collection<Authentication> authenticationSettings, SslContextFactory sslContextFactory, HostnameVerifier hostnameVerifier, HttpRedirectVerifier redirectVerifier, boolean followRedirects) {
        this.followRedirects = followRedirects;
        Preconditions.checkNotNull(authenticationSettings, (Object)"authenticationSettings");
        Preconditions.checkNotNull((Object)sslContextFactory, (Object)"sslContextFactory");
        Preconditions.checkNotNull((Object)hostnameVerifier, (Object)"hostnameVerifier");
        Preconditions.checkNotNull((Object)redirectVerifier, (Object)"redirectVerifier");
        this.authenticationSettings = authenticationSettings;
        this.sslContextFactory = sslContextFactory;
        this.hostnameVerifier = hostnameVerifier;
        this.redirectVerifier = redirectVerifier;
    }

    @Override
    public HttpProxySettings getProxySettings() {
        if (this.proxySettings == null) {
            this.proxySettings = new JavaSystemPropertiesHttpProxySettings();
        }
        return this.proxySettings;
    }

    @Override
    public HttpProxySettings getSecureProxySettings() {
        if (this.secureProxySettings == null) {
            this.secureProxySettings = new JavaSystemPropertiesSecureHttpProxySettings();
        }
        return this.secureProxySettings;
    }

    @Override
    public HttpTimeoutSettings getTimeoutSettings() {
        if (this.timeoutSettings == null) {
            this.timeoutSettings = new JavaSystemPropertiesHttpTimeoutSettings();
        }
        return this.timeoutSettings;
    }

    @Override
    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    @Override
    public HttpRedirectVerifier getRedirectVerifier() {
        return this.redirectVerifier;
    }

    @Override
    public Collection<Authentication> getAuthenticationSettings() {
        return this.authenticationSettings;
    }

    @Override
    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public static class Builder {
        private Collection<Authentication> authenticationSettings;
        private SslContextFactory sslContextFactory;
        private HostnameVerifier hostnameVerifier;
        private HttpRedirectVerifier redirectVerifier;
        private boolean followRedirects = true;

        public Builder withAuthenticationSettings(Collection<Authentication> authenticationSettings) {
            this.authenticationSettings = authenticationSettings;
            return this;
        }

        public Builder withSslContextFactory(SslContextFactory sslContextFactory) {
            this.sslContextFactory = sslContextFactory;
            this.hostnameVerifier = new DefaultHostnameVerifier(null);
            return this;
        }

        public Builder withRedirectVerifier(HttpRedirectVerifier redirectVerifier) {
            this.redirectVerifier = redirectVerifier;
            return this;
        }

        public Builder allowUntrustedConnections() {
            this.sslContextFactory = ALL_TRUSTING_SSL_CONTEXT_FACTORY;
            this.hostnameVerifier = ALL_TRUSTING_HOSTNAME_VERIFIER;
            return this;
        }

        public Builder followRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public HttpSettings build() {
            return new DefaultHttpSettings(this.authenticationSettings, this.sslContextFactory, this.hostnameVerifier, this.redirectVerifier, this.followRedirects);
        }
    }
}

