/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.cached;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.resource.cached.ExternalResourceFileStore;
import org.gradle.internal.resource.local.FileStoreException;
import org.gradle.internal.resource.local.LocallyAvailableResource;

public class TwoStageExternalResourceFileStore
implements ExternalResourceFileStore {
    private final ExternalResourceFileStore readOnlyStore;
    private final ExternalResourceFileStore writableStore;
    private final DelegatingFileAccessTracker delegatingFileAccessTracker;

    public TwoStageExternalResourceFileStore(ExternalResourceFileStore readOnlyStore, ExternalResourceFileStore writableStore) {
        this.readOnlyStore = readOnlyStore;
        this.writableStore = writableStore;
        this.delegatingFileAccessTracker = new DelegatingFileAccessTracker();
    }

    @Override
    public FileAccessTracker getFileAccessTracker() {
        return this.delegatingFileAccessTracker;
    }

    @Override
    public LocallyAvailableResource move(String key, File source) throws FileStoreException {
        return this.writableStore.move(key, source);
    }

    @Override
    public LocallyAvailableResource add(String key, Action<File> addAction) throws FileStoreException {
        return this.writableStore.add(key, addAction);
    }

    @Override
    public Set<? extends LocallyAvailableResource> search(String key) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.writableStore.search(key));
        builder.addAll(this.readOnlyStore.search(key));
        return builder.build();
    }

    private class DelegatingFileAccessTracker
    implements FileAccessTracker {
        private DelegatingFileAccessTracker() {
        }

        @Override
        public void markAccessed(File file) {
            TwoStageExternalResourceFileStore.this.readOnlyStore.getFileAccessTracker().markAccessed(file);
            TwoStageExternalResourceFileStore.this.writableStore.getFileAccessTracker().markAccessed(file);
        }

        @Override
        public void markAccessed(Collection<File> files2) {
            TwoStageExternalResourceFileStore.this.readOnlyStore.getFileAccessTracker().markAccessed(files2);
            TwoStageExternalResourceFileStore.this.writableStore.getFileAccessTracker().markAccessed(files2);
        }
    }
}

